/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus.parsers;

import com.aliasi.corpus.ChunkTagHandlerAdapter;
import com.aliasi.corpus.TagHandler;
import com.aliasi.corpus.parsers.AbstractMedTagParser;

public class GeneTagParser
extends AbstractMedTagParser {
    public static String GENE_TYPE = "GENE";
    public static final String B_GENE_TAG = ChunkTagHandlerAdapter.toBeginTag(GENE_TYPE);
    public static final String I_GENE_TAG = ChunkTagHandlerAdapter.toInTag(GENE_TYPE);

    public GeneTagParser() {
    }

    public GeneTagParser(TagHandler handler) {
        super(handler);
    }

    protected void parseTokensTags(String[] tokens, String[] whitespaces, String[] tags) {
        String[] normalTags = GeneTagParser.normalize(tags);
        this.tagHandler().handle(tokens, null, normalTags);
    }

    static String[] normalize(String[] tags) {
        String[] result = new String[tags.length];
        int i = 0;
        while (i < tags.length) {
            if (tags[i].startsWith("GENE")) {
                String tag = tags[i];
                result[i] = B_GENE_TAG;
                ++i;
                while (i < tags.length && tags[i].equals(tag)) {
                    result[i++] = I_GENE_TAG;
                }
                continue;
            }
            result[i++] = "O";
        }
        return result;
    }
}

