/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus.parsers;

import com.aliasi.corpus.StringParser;
import com.aliasi.corpus.TextHandler;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;

public class BrownTextParser
extends StringParser {
    public BrownTextParser() {
    }

    public BrownTextParser(TextHandler handler) {
        super(handler);
    }

    public void parseString(char[] cs, int start, int end) throws IOException {
        String line;
        TextHandler handler = (TextHandler)this.getHandler();
        CharArrayReader reader = new CharArrayReader(cs, start, end - start);
        BufferedReader bufReader = new BufferedReader(reader);
        StringBuffer sb = new StringBuffer();
        boolean continuationLine = false;
        block0: while ((line = bufReader.readLine()) != null) {
            int i;
            boolean startParagraph = line.startsWith("\t");
            String trimmedText = line.trim();
            if (trimmedText.length() == 0) continue;
            if (continuationLine) {
                sb.append(' ');
            } else if (startParagraph) {
                sb.append('\t');
            }
            continuationLine = true;
            String[] tokenTags = trimmedText.split(" ");
            String[] toks = new String[tokenTags.length];
            for (i = 0; i < tokenTags.length; ++i) {
                String tokTag = tokenTags[i];
                int k = tokTag.lastIndexOf(47);
                toks[i] = k < 0 ? tokTag : tokTag.substring(0, k);
            }
            for (i = 0; i < toks.length; ++i) {
                sb.append(toks[i]);
                if (i + 1 == toks.length) continue block0;
                if (toks[i].equals("``") || toks[i].equals("`") || toks[i].equals("(") || toks[i].equals("[") || toks[i].equals("{") || toks[i].equals("$") || toks[i + 1].equals("''") || toks[i + 1].equals("'") || toks[i + 1].equals("]") || toks[i + 1].equals("}") || toks[i + 1].equals(".") || toks[i + 1].equals("?") || toks[i + 1].equals("!") || toks[i + 1].equals(":") || toks[i + 1].equals(";") || toks[i + 1].equals(",") || toks[i + 1].equals("%")) continue;
                sb.append(' ');
            }
        }
        char[] csFound = sb.toString().toCharArray();
        handler.handle(csFound, 0, csFound.length);
    }
}

