/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus.parsers;

import com.aliasi.corpus.StringParser;
import com.aliasi.corpus.TagHandler;
import com.aliasi.util.Strings;

public class BrownPosParser
extends StringParser {
    public BrownPosParser() {
    }

    public BrownPosParser(TagHandler handler) {
        super(handler);
    }

    public TagHandler tagHandler() {
        return (TagHandler)this.getHandler();
    }

    public void parseString(char[] cs, int start, int end) {
        String in = new String(cs, start, end - start);
        String[] sentences = in.split("\n");
        for (int i = 0; i < sentences.length; ++i) {
            if (Strings.allWhitespace(sentences[i])) continue;
            this.processSentence(sentences[i]);
        }
    }

    public String normalizeTag(String rawTag) {
        int negIndex;
        int firstHyphen;
        int lastHyphen;
        String tag;
        String startTag = tag = rawTag;
        int splitIndex = tag.indexOf(43);
        if (splitIndex >= 0) {
            tag = tag.substring(0, splitIndex);
        }
        if ((lastHyphen = tag.lastIndexOf(45)) >= 0) {
            String first = tag.substring(0, lastHyphen);
            String suffix = tag.substring(lastHyphen + 1);
            if (suffix.equalsIgnoreCase("HL") || suffix.equalsIgnoreCase("TL") || suffix.equalsIgnoreCase("NC")) {
                tag = first;
            }
        }
        if ((firstHyphen = tag.indexOf(45)) > 0) {
            String prefix = tag.substring(0, firstHyphen);
            String rest = tag.substring(firstHyphen + 1);
            if (prefix.equalsIgnoreCase("FW") || prefix.equalsIgnoreCase("NC") || prefix.equalsIgnoreCase("NP")) {
                tag = rest;
            }
        }
        if ((negIndex = tag.indexOf(42)) > 0) {
            tag = negIndex == tag.length() - 1 ? tag.substring(0, negIndex) : tag.substring(0, negIndex) + tag.substring(negIndex + 1);
        }
        return tag.equals(startTag) ? tag : this.normalizeTag(tag);
    }

    private void processSentence(String sentence) {
        String[] tagTokenPairs = sentence.split(" ");
        String[] tokens = new String[tagTokenPairs.length];
        String[] tags = new String[tagTokenPairs.length];
        for (int i = 0; i < tagTokenPairs.length; ++i) {
            String pair = tagTokenPairs[i];
            int j = pair.lastIndexOf(47);
            tokens[i] = pair.substring(0, j);
            tags[i] = this.normalizeTag(pair.substring(j + 1));
        }
        this.tagHandler().handle(tokens, null, tags);
    }
}

