/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus;

import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.Handler;
import com.aliasi.corpus.Parser;
import com.aliasi.util.Streams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskCorpus<H extends Handler>
extends Corpus<H> {
    private final Parser<H> mParser;
    private final File mTrainDir;
    private final File mTestDir;
    private String mCharEncoding = null;
    private String mSystemId = null;
    public static final String DEFAULT_TRAIN_DIR_NAME = "train";
    public static final String DEFAULT_TEST_DIR_NAME = "test";

    public DiskCorpus(Parser<H> parser, File dir) {
        this(parser, new File(dir, DEFAULT_TRAIN_DIR_NAME), new File(dir, DEFAULT_TEST_DIR_NAME));
    }

    public DiskCorpus(Parser<H> parser, File trainDir, File testDir) {
        this.mParser = parser;
        this.mTrainDir = trainDir;
        this.mTestDir = testDir;
    }

    public void setCharEncoding(String encoding) {
        this.mCharEncoding = encoding;
    }

    public String getCharEncoding() {
        return this.mCharEncoding;
    }

    public void setSystemId(String systemId) {
        this.mSystemId = systemId;
    }

    public String getSystemId() {
        return this.mSystemId;
    }

    public Parser<H> parser() {
        return this.mParser;
    }

    @Override
    public void visitTrain(H handler) throws IOException {
        this.visit(handler, this.mTrainDir);
    }

    @Override
    public void visitTest(H handler) throws IOException {
        this.visit(handler, this.mTestDir);
    }

    private void visit(H handler, File file) throws IOException {
        Parser<H> parser = this.parser();
        parser.setHandler(handler);
        this.visit(parser, file);
    }

    private void visit(Parser<H> parser, File file) throws IOException {
        if (file.isDirectory()) {
            this.visitDir(parser, file);
        } else if (file.getName().endsWith(".gz")) {
            this.visitGzip(parser, file);
        } else if (file.getName().endsWith(".zip")) {
            this.visitZip(parser, file);
        } else {
            this.visitOrdinaryFile(parser, file);
        }
    }

    private void visitDir(Parser<H> parser, File dir) throws IOException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.visit(parser, files[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitGzip(Parser<H> parser, File gzipFile) throws IOException {
        FileInputStream fileIn = null;
        BufferedInputStream bufIn = null;
        GZIPInputStream gzipIn = null;
        try {
            fileIn = new FileInputStream(gzipFile);
            bufIn = new BufferedInputStream(bufIn);
            gzipIn = new GZIPInputStream(bufIn);
            InputSource inSource = new InputSource(gzipIn);
            this.configure(inSource, gzipFile);
            parser.parse(inSource);
        }
        catch (Throwable throwable) {
            Streams.closeInputStream(gzipIn);
            Streams.closeInputStream(bufIn);
            Streams.closeInputStream(fileIn);
            throw throwable;
        }
        Streams.closeInputStream(gzipIn);
        Streams.closeInputStream(bufIn);
        Streams.closeInputStream(fileIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitZip(Parser<H> parser, File zipFile) throws IOException {
        FileInputStream fileIn = null;
        BufferedInputStream bufIn = null;
        ZipInputStream zipIn = null;
        try {
            fileIn = new FileInputStream(zipFile);
            bufIn = new BufferedInputStream(bufIn);
            zipIn = new ZipInputStream(bufIn);
            ZipEntry entry = null;
            while ((entry = zipIn.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                InputSource inSource = new InputSource(zipIn);
                this.configure(inSource, zipFile);
                parser.parse(inSource);
            }
        }
        catch (Throwable throwable) {
            Streams.closeInputStream(zipIn);
            Streams.closeInputStream(bufIn);
            Streams.closeInputStream(fileIn);
            throw throwable;
        }
        Streams.closeInputStream(zipIn);
        Streams.closeInputStream(bufIn);
        Streams.closeInputStream(fileIn);
    }

    private void visitOrdinaryFile(Parser<H> parser, File file) throws IOException {
        InputSource in = new InputSource(file.getCanonicalPath());
        this.configure(in, file);
        parser.parse(in);
    }

    private void configure(InputSource inSource, File file) throws IOException {
        inSource.setSystemId(this.mSystemId == null ? file.getCanonicalPath() : this.mSystemId);
        if (this.mCharEncoding != null) {
            inSource.setEncoding(this.mCharEncoding);
        }
    }
}

