/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.coref;

import com.aliasi.coref.Mention;
import com.aliasi.coref.MentionChain;
import com.aliasi.coref.MentionFactory;
import com.aliasi.util.Collections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class WithinDocCoref {
    private final ArrayList mMentionChains = new ArrayList();
    private final MentionFactory mMentionFactory;
    public static final Comparator SENTENCE_FINAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return this.compare((MentionChain)o1, (MentionChain)o2);
        }

        public int compare(MentionChain chain1, MentionChain chain2) {
            if (chain1.maxSentenceOffset() < chain2.maxSentenceOffset()) {
                return 1;
            }
            if (chain1.maxSentenceOffset() > chain2.maxSentenceOffset()) {
                return -1;
            }
            return 0;
        }
    };

    public WithinDocCoref(MentionFactory mentionFactory) {
        this.mMentionFactory = mentionFactory;
    }

    public MentionChain[] mentionChains() {
        MentionChain[] result = new MentionChain[this.mMentionChains.size()];
        this.mMentionChains.toArray(result);
        return result;
    }

    public int resolveMention(Mention mention, int offset) {
        MentionChain nextAntecedent;
        List[] hypotheses = new List[7];
        for (int i = 0; i < hypotheses.length; ++i) {
            hypotheses[i] = new ArrayList();
        }
        MentionChain[] antecedents = this.mentionChains();
        Arrays.sort(antecedents, SENTENCE_FINAL_COMPARATOR);
        for (int i = 0; i < antecedents.length && !this.finished(offset, nextAntecedent = antecedents[i], hypotheses); ++i) {
            this.addPossibleAntecedent(mention, offset, nextAntecedent, hypotheses);
        }
        return this.selectAntecedent(hypotheses, mention, offset);
    }

    private boolean finished(int mentionOffset, MentionChain chain, List[] hypotheses) {
        int distance;
        for (int i = distance = WithinDocCoref.distanceScore(mentionOffset, chain); i > 0; --i) {
            if (hypotheses[i].size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void addPossibleAntecedent(Mention mention, int offset, MentionChain antecedent, List[] hypotheses) {
        if (antecedent.killed(mention)) {
            return;
        }
        int matchScore = antecedent.matchScore(mention);
        if (matchScore == -1) {
            return;
        }
        int totalScore = matchScore + WithinDocCoref.distanceScore(offset, antecedent);
        hypotheses[totalScore].add(antecedent);
    }

    private int selectAntecedent(List[] hypotheses, Mention mention, int offset) {
        for (int score = 0; score < hypotheses.length; ++score) {
            if (hypotheses[score].size() == 1) {
                MentionChain antecedent = (MentionChain)Collections.getFirst(hypotheses[score]);
                antecedent.add(mention, offset);
                return antecedent.identifier();
            }
            if (hypotheses[score].size() <= 1) continue;
            return this.promoteToNewChain(mention, offset);
        }
        return this.promoteToNewChain(mention, offset);
    }

    private int promoteToNewChain(Mention mention, int offset) {
        if (mention.isPronominal()) {
            return -1;
        }
        MentionChain chain = this.mMentionFactory.promote(mention, offset);
        this.mMentionChains.add(chain);
        return chain.identifier();
    }

    private static int distanceScore(int mentionOffset, MentionChain antecedent) {
        switch (mentionOffset - antecedent.maxSentenceOffset()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
        }
        return 2;
    }
}

