/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.coref;

import com.aliasi.coref.CachedMention;
import com.aliasi.coref.Mention;
import com.aliasi.coref.MentionChain;
import com.aliasi.coref.MentionChainImpl;
import com.aliasi.coref.MentionFactory;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.Collections;
import com.aliasi.util.SmallSet;
import java.util.ArrayList;

public abstract class AbstractMentionFactory
implements MentionFactory {
    private int mNextChainIdentifier = 0;
    private final TokenizerFactory mTokenizerFactory;

    public AbstractMentionFactory(TokenizerFactory tokenizerFactory) {
        this.mTokenizerFactory = tokenizerFactory;
    }

    public Mention create(String phrase, String entityType) {
        ArrayList tokens = new ArrayList();
        SmallSet honorifics = this.extractTokens(phrase, tokens);
        return new CachedMention(phrase, entityType, honorifics, Collections.toStringArray(tokens), this.gender(entityType), this.isPronominal(entityType));
    }

    public MentionChain promote(Mention mention, int offset) {
        return new MentionChainImpl(mention, offset, this.nextChainIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextChainIdentifier() {
        AbstractMentionFactory abstractMentionFactory = this;
        synchronized (abstractMentionFactory) {
            return this.mNextChainIdentifier++;
        }
    }

    protected abstract boolean isHonorific(String var1);

    protected abstract String gender(String var1);

    protected abstract boolean isPronominal(String var1);

    protected abstract String normalizeToken(String var1);

    private SmallSet extractTokens(String phrase, ArrayList tokens) {
        String token;
        SmallSet<Object> honorifics = SmallSet.create();
        char[] cs = phrase.toCharArray();
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, 0, cs.length);
        while ((token = tokenizer.nextToken()) != null) {
            String normalToken = this.normalizeToken(token);
            if (normalToken == null) continue;
            if (this.isHonorific(normalToken)) {
                honorifics = SmallSet.create(normalToken, honorifics);
                continue;
            }
            tokens.add(normalToken);
        }
        return honorifics;
    }
}

