/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.cluster;

import com.aliasi.cluster.AbstractHierarchicalClusterer;
import com.aliasi.cluster.Dendrogram;
import com.aliasi.cluster.LeafDendrogram;
import com.aliasi.cluster.LinkDendrogram;
import com.aliasi.util.Distance;
import com.aliasi.util.Scored;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleLinkClusterer<E>
extends AbstractHierarchicalClusterer<E> {
    public SingleLinkClusterer(double maxDistance, Distance<? super E> distance) {
        super(maxDistance, distance);
    }

    public SingleLinkClusterer(Distance<? super E> distance) {
        this(Double.POSITIVE_INFINITY, distance);
    }

    @Override
    public Dendrogram<E> hierarchicalCluster(Set<? extends E> elementSet) {
        AbstractHierarchicalClusterer.PairScore ps;
        if (elementSet.size() == 0) {
            String msg = "Require non-empty set to form dendrogram. Found elementSet.size()=" + elementSet.size();
            throw new IllegalArgumentException(msg);
        }
        if (elementSet.size() == 1) {
            return new LeafDendrogram<E>(elementSet.iterator().next());
        }
        Object[] elements = this.toElements(elementSet);
        LeafDendrogram[] leafs = new LeafDendrogram[elements.length];
        for (int i = 0; i < leafs.length; ++i) {
            leafs[i] = new LeafDendrogram<Object>(elements[i]);
        }
        HashSet<Dendrogram> clusters = new HashSet<Dendrogram>(elements.length);
        for (LeafDendrogram dendrogram : leafs) {
            clusters.add(dendrogram);
        }
        ArrayList pairScoreList = new ArrayList();
        int len = elements.length;
        double maxDistance = this.getMaxDistance();
        for (int i = 0; i < len; ++i) {
            Object eI = elements[i];
            LeafDendrogram dendroI = leafs[i];
            for (int j = i + 1; j < len; ++j) {
                Object eJ = elements[j];
                double distanceIJ = this.distance().distance(eI, eJ);
                if (distanceIJ > maxDistance) continue;
                LeafDendrogram dendroJ = leafs[j];
                pairScoreList.add(new AbstractHierarchicalClusterer.PairScore(dendroI, dendroJ, distanceIJ));
            }
        }
        AbstractHierarchicalClusterer.PairScore[] pairScores = new AbstractHierarchicalClusterer.PairScore[pairScoreList.size()];
        pairScoreList.toArray(pairScores);
        Arrays.sort(pairScores, Scored.SCORE_COMPARATOR);
        for (int i = 0; i < pairScores.length && clusters.size() > 1 && !((ps = pairScores[i]).score() > this.getMaxDistance()); ++i) {
            Dendrogram d2;
            Dendrogram d1 = ps.mDendrogram1.dereference();
            if (d1.equals(d2 = ps.mDendrogram2.dereference())) continue;
            clusters.remove(d1);
            clusters.remove(d2);
            LinkDendrogram dLink = new LinkDendrogram(d1, d2, pairScores[i].mScore);
            clusters.add(dLink);
        }
        Iterator it = clusters.iterator();
        LinkDendrogram dendro = (LinkDendrogram)it.next();
        while (it.hasNext()) {
            dendro = new LinkDendrogram(dendro, (Dendrogram)it.next(), Double.POSITIVE_INFINITY);
        }
        return dendro;
    }
}

