/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.cluster;

import com.aliasi.cluster.Dendrogram;
import com.aliasi.util.Distance;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkDendrogram<E>
extends Dendrogram<E> {
    private final double mCost;
    private final Dendrogram<E> mDendrogram1;
    private final Dendrogram<E> mDendrogram2;

    public LinkDendrogram(Dendrogram<E> dendrogram1, Dendrogram<E> dendrogram2, double cost) {
        if (cost < 0.0 || Double.isNaN(cost)) {
            String msg = "Cost must be >= 0.0 Found cost=" + cost;
            throw new IllegalArgumentException(msg);
        }
        dendrogram1.setParent(this);
        dendrogram2.setParent(this);
        this.mDendrogram1 = dendrogram1;
        this.mDendrogram2 = dendrogram2;
        this.mCost = cost;
    }

    @Override
    public double score() {
        return this.mCost;
    }

    @Override
    public Set<E> memberSet() {
        HashSet members = new HashSet();
        this.addMembers(members);
        return members;
    }

    @Override
    void addMembers(Set<E> set) {
        this.mDendrogram1.addMembers(set);
        this.mDendrogram2.addMembers(set);
    }

    @Override
    void split(Collection<Set<E>> resultSet, Collection<Dendrogram<E>> queue) {
        queue.add(this.mDendrogram1);
        queue.add(this.mDendrogram2);
    }

    @Override
    void partitionDistance(Set<Set<E>> clustering, double maxProximity) {
        if (this.score() <= maxProximity) {
            clustering.add(this.memberSet());
        } else {
            this.mDendrogram1.partitionDistance(clustering, maxProximity);
            this.mDendrogram2.partitionDistance(clustering, maxProximity);
        }
    }

    public Dendrogram dendrogram1() {
        return this.mDendrogram1;
    }

    public Dendrogram dendrogram2() {
        return this.mDendrogram2;
    }

    Dendrogram[] daughters() {
        return new Dendrogram[]{this.mDendrogram1, this.mDendrogram2};
    }

    @Override
    int copheneticCorrelation(int i, double[] xs, double[] ys, Distance<? super E> distance) {
        for (E e1 : this.mDendrogram1.memberSet()) {
            for (E e2 : this.mDendrogram2.memberSet()) {
                xs[i] = this.score();
                ys[i] = distance.distance(e1, e2);
                ++i;
            }
        }
        return i;
    }

    @Override
    void toString(StringBuffer sb, int depth) {
        sb.append('{');
        this.mDendrogram1.toString(sb, depth + 1);
        sb.append('+');
        this.mDendrogram2.toString(sb, depth + 1);
        sb.append("}:");
        sb.append(this.mCost);
    }

    @Override
    void prettyPrint(StringBuffer sb, int depth) {
        this.indent(sb, depth);
        sb.append(this.score());
        this.mDendrogram1.prettyPrint(sb, depth + 1);
        this.mDendrogram2.prettyPrint(sb, depth + 1);
    }
}

