/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.cluster;

import com.aliasi.cluster.Clusterer;
import com.aliasi.util.Arrays;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToDoubleMap;
import com.aliasi.util.SmallSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansClusterer<E>
implements Clusterer<E> {
    final FeatureExtractor<E> mFeatureExtractor;
    final int mNumClusters;
    final int mMaxIterations;

    public KMeansClusterer(FeatureExtractor<E> featureExtractor, int numClusters, int maxIterations) {
        if (numClusters < 1) {
            String msg = "Number of clusters must be positive. Found numClusters=" + numClusters;
            throw new IllegalArgumentException(msg);
        }
        if (maxIterations < 0) {
            String msg = "Number of iterations must be non-negative. Found maxIterations=" + maxIterations;
            throw new IllegalArgumentException(msg);
        }
        this.mFeatureExtractor = featureExtractor;
        this.mNumClusters = numClusters;
        this.mMaxIterations = maxIterations;
    }

    public FeatureExtractor<E> featureExtractor() {
        return this.mFeatureExtractor;
    }

    public int numClusters() {
        return this.mNumClusters;
    }

    public Set<Set<E>> recluster(Set<Set<E>> clustering, int maxIterations) {
        int numElements = this.numElements(clustering);
        Object[] elements = new Object[numElements];
        Map[] featureMaps = new Map[numElements];
        ObjectToDoubleMap[] centroids = new ObjectToDoubleMap[clustering.size()];
        for (int i = 0; i < centroids.length; ++i) {
            centroids[i] = new ObjectToDoubleMap();
        }
        List[] clusterElements = new List[clustering.size()];
        for (int i = 0; i < clusterElements.length; ++i) {
            clusterElements[i] = new ArrayList();
        }
        int eltIndex = 0;
        int clusterIndex = 0;
        for (Set<E> cluster : clustering) {
            for (E e : cluster) {
                elements[eltIndex] = e;
                featureMaps[eltIndex] = this.mFeatureExtractor.features(e);
                KMeansClusterer.add(centroids[clusterIndex], featureMaps[eltIndex]);
                clusterElements[clusterIndex].add(new Integer(eltIndex));
                ++eltIndex;
            }
            ++clusterIndex;
        }
        return this.clusterIterations(centroids, clusterElements, elements, featureMaps, maxIterations);
    }

    int numElements(Set<Set<E>> clustering) {
        int count = 0;
        for (Set<E> cluster : clustering) {
            count += cluster.size();
        }
        return count;
    }

    @Override
    public Set<Set<E>> cluster(Set<? extends E> elementSet) {
        if (elementSet.size() <= this.mNumClusters) {
            HashSet<Set<SmallSet<E>>> clustering = new HashSet<Set<SmallSet<E>>>(3 * elementSet.size() / 2);
            for (E elt : elementSet) {
                SmallSet<E> cluster = SmallSet.create(elt);
                clustering.add(cluster);
            }
            return clustering;
        }
        Object[] elements = new Object[elementSet.size()];
        elementSet.toArray(elements);
        Arrays.permute(elements);
        Map[] featureMaps = new Map[elements.length];
        for (int i = 0; i < featureMaps.length; ++i) {
            featureMaps[i] = this.mFeatureExtractor.features(elements[i]);
        }
        ObjectToDoubleMap<String>[] centroids = this.createCentroids();
        List<Integer>[] clusterElements = this.createClusterElements();
        for (int i = 0; i < elements.length; ++i) {
            int clusterId = i % this.mNumClusters;
            KMeansClusterer.add(centroids[clusterId], featureMaps[i]);
            clusterElements[clusterId].add(new Integer(i));
        }
        return this.clusterIterations(centroids, clusterElements, elements, featureMaps, this.mMaxIterations);
    }

    Set<Set<E>> clusterIterations(ObjectToDoubleMap<String>[] centroids, List<Integer>[] clusterElements, Object[] elements, Map<String, ? extends Number>[] featureMaps, int maxIterations) {
        for (int iteration = 0; iteration < maxIterations; ++iteration) {
            this.scale(centroids, clusterElements);
            ObjectToDoubleMap<String>[] nextCentroids = this.createCentroids();
            List<Integer>[] nextClusterElements = this.createClusterElements();
            boolean fixed = true;
            for (int i = 0; i < this.mNumClusters; ++i) {
                List<Integer> cluster = clusterElements[i];
                for (int k = 0; k < cluster.size(); ++k) {
                    Integer eltIndexInt = cluster.get(k);
                    int eltIndex = eltIndexInt;
                    double closestDistance = Double.POSITIVE_INFINITY;
                    int closestIndex = -1;
                    for (int j = 0; j < this.mNumClusters; ++j) {
                        double distance = KMeansClusterer.euclideanDistance(centroids[j], featureMaps[eltIndex]);
                        if (!(distance < closestDistance)) continue;
                        closestDistance = distance;
                        closestIndex = j;
                    }
                    if (closestIndex == -1) {
                        closestIndex = 0;
                    }
                    KMeansClusterer.add(nextCentroids[closestIndex], featureMaps[eltIndex]);
                    nextClusterElements[closestIndex].add(eltIndexInt);
                    if (closestIndex == i) continue;
                    fixed = false;
                }
            }
            if (fixed) break;
            centroids = nextCentroids;
            clusterElements = nextClusterElements;
        }
        HashSet clustering = new HashSet(3 * this.mNumClusters / 2);
        for (int i = 0; i < this.mNumClusters; ++i) {
            HashSet<Object> cluster = new HashSet<Object>();
            for (Integer k : clusterElements[i]) {
                cluster.add(elements[k]);
            }
            if (cluster.size() <= 0) continue;
            clustering.add(cluster);
        }
        return clustering;
    }

    void scale(ObjectToDoubleMap<String>[] centroids, List<Integer>[] nextClusterElements) {
        for (int i = 0; i < centroids.length; ++i) {
            double numElts = nextClusterElements[i].size();
            ObjectToDoubleMap<String> centroid = centroids[i];
            for (String s : centroid.keySet()) {
                centroid.set(s, centroid.getValue(s) / numElts);
            }
        }
    }

    void printFeaturesClosest(Map<String, ? extends Number> featureMap, int closestIndex) {
        System.out.println("  features=" + featureMap.toString().trim().replaceAll("\n", ", "));
        System.out.println("       closest centroid=" + closestIndex);
    }

    void printCentroids(ObjectToDoubleMap<String>[] centroids) {
        System.out.println("\nCentroids");
        for (int i = 0; i < centroids.length; ++i) {
            System.out.println("  " + i + "  " + centroids[i]);
        }
    }

    void scale(ObjectToDoubleMap<String> centroid, double scalar) {
    }

    List<Integer>[] createClusterElements() {
        List[] clusterElements = new List[this.mNumClusters];
        for (int i = 0; i < clusterElements.length; ++i) {
            clusterElements[i] = new ArrayList();
        }
        return clusterElements;
    }

    ObjectToDoubleMap<String>[] createCentroids() {
        ObjectToDoubleMap[] centroids = new ObjectToDoubleMap[this.mNumClusters];
        for (int i = 0; i < centroids.length; ++i) {
            centroids[i] = new ObjectToDoubleMap();
        }
        return centroids;
    }

    static void add(ObjectToDoubleMap<String> centroid, Map<String, ? extends Number> featureMap) {
        for (Map.Entry<String, ? extends Number> entry : featureMap.entrySet()) {
            centroid.increment(entry.getKey(), entry.getValue().doubleValue());
        }
    }

    static double euclideanDistance(ObjectToDoubleMap<String> centroid, Map<String, ? extends Number> featureMap) {
        double diff;
        double sqDist = 0.0;
        for (Map.Entry<String, ? extends Number> entry : featureMap.entrySet()) {
            diff = entry.getValue().doubleValue() - centroid.getValue(entry.getKey());
            sqDist += diff * diff;
        }
        for (Map.Entry<String, Number> entry : centroid.entrySet()) {
            if (featureMap.containsKey(entry.getKey())) continue;
            diff = (Double)entry.getValue();
            sqDist += diff * diff;
        }
        return sqDist;
    }
}

