/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.cluster;

import com.aliasi.cluster.AbstractHierarchicalClusterer;
import com.aliasi.cluster.Dendrogram;
import com.aliasi.cluster.LeafDendrogram;
import com.aliasi.cluster.LinkDendrogram;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Distance;
import com.aliasi.util.ObjectToSet;
import com.aliasi.util.Scored;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteLinkClusterer<E>
extends AbstractHierarchicalClusterer<E> {
    public CompleteLinkClusterer(double maxDistance, Distance<? super E> distance) {
        super(maxDistance, distance);
    }

    public CompleteLinkClusterer(Distance<? super E> distance) {
        this(Double.POSITIVE_INFINITY, distance);
    }

    @Override
    public Dendrogram<E> hierarchicalCluster(Set<? extends E> elementSet) {
        if (elementSet.size() == 0) {
            String msg = "Require non-empty set to form dendrogram. Found elementSet.size()=" + elementSet.size();
            throw new IllegalArgumentException(msg);
        }
        if (elementSet.size() == 1) {
            return new LeafDendrogram<E>(elementSet.iterator().next());
        }
        BoundedPriorityQueue<Scored> queue = new BoundedPriorityQueue<Scored>(Scored.REVERSE_SCORE_COMPARATOR, Integer.MAX_VALUE);
        ObjectToSet index = new ObjectToSet();
        Object[] elements = this.toElements(elementSet);
        LeafDendrogram[] leafs = new LeafDendrogram[elements.length];
        for (int i = 0; i < leafs.length; ++i) {
            leafs[i] = new LeafDendrogram<Object>(elements[i]);
        }
        double maxDistance = this.getMaxDistance();
        for (int i = 0; i < elements.length; ++i) {
            Object eI = elements[i];
            LeafDendrogram dI = leafs[i];
            for (int j = i + 1; j < elements.length; ++j) {
                Object eJ = elements[j];
                double score = this.distance().distance(eI, eJ);
                if (score > maxDistance) continue;
                LeafDendrogram dJ = leafs[j];
                AbstractHierarchicalClusterer.PairScore psIJ = new AbstractHierarchicalClusterer.PairScore(dI, dJ, score);
                queue.add(psIJ);
                index.addMember(dI, psIJ);
                index.addMember(dJ, psIJ);
            }
        }
        while (queue.size() > 0) {
            Dendrogram dendro3;
            AbstractHierarchicalClusterer.PairScore next = (AbstractHierarchicalClusterer.PairScore)queue.pop();
            Dendrogram dendro1 = next.mDendrogram1.dereference();
            Dendrogram dendro2 = next.mDendrogram2.dereference();
            double dist12 = next.score();
            LinkDendrogram dendro12 = new LinkDendrogram(dendro1, dendro2, dist12);
            HashMap distanceBuf = new HashMap();
            Set ps3Set = (Set)index.remove(dendro1);
            queue.removeAll(ps3Set);
            for (AbstractHierarchicalClusterer.PairScore ps3 : ps3Set) {
                dendro3 = ps3.mDendrogram1 == dendro1 ? ps3.mDendrogram2 : ps3.mDendrogram1;
                ((Set)index.get(dendro3)).remove(ps3);
                double dist1_3 = ps3.score();
                distanceBuf.put(dendro3, new Double(dist1_3));
            }
            ps3Set = (Set)index.remove(dendro2);
            queue.removeAll(ps3Set);
            for (AbstractHierarchicalClusterer.PairScore ps3 : ps3Set) {
                dendro3 = ps3.mDendrogram1 == dendro2 ? ps3.mDendrogram2 : ps3.mDendrogram1;
                ((Set)index.get(dendro3)).remove(ps3);
                Double dist1_3D = (Double)distanceBuf.get(dendro3);
                if (dist1_3D == null) continue;
                double dist1_3 = dist1_3D;
                double dist2_3 = ps3.score();
                double dist12_3 = Math.max(dist1_3, dist2_3);
                AbstractHierarchicalClusterer.PairScore ps = new AbstractHierarchicalClusterer.PairScore(dendro12, dendro3, dist12_3);
                queue.add(ps);
                index.addMember(dendro12, ps);
                index.addMember(dendro3, ps);
            }
            if (!queue.isEmpty()) continue;
            return dendro12;
        }
        Iterator it = index.keySet().iterator();
        LinkDendrogram dendro = (LinkDendrogram)it.next();
        while (it.hasNext()) {
            dendro = new LinkDendrogram(dendro, (Dendrogram)it.next(), Double.POSITIVE_INFINITY);
        }
        return dendro;
    }
}

