/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.PrecisionRecallEvaluation;
import com.aliasi.util.Scored;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

public class ScoredPrecisionRecallEvaluation {
    private final Set mCases = new TreeSet<Scored>(Scored.REVERSE_SCORE_COMPARATOR);
    private int mNegativeRef = 0;
    private int mPositiveRef = 0;

    public void addCase(boolean correct, double score) {
        this.mCases.add(new Case(correct, score));
        if (correct) {
            ++this.mPositiveRef;
        } else {
            ++this.mNegativeRef;
        }
    }

    public double[][] prCurve(boolean interpolate) {
        PrecisionRecallEvaluation eval = new PrecisionRecallEvaluation();
        ArrayList<double[]> prList = new ArrayList<double[]>();
        Iterator it = this.mCases.iterator();
        int i = 0;
        while (it.hasNext()) {
            Case cse = (Case)it.next();
            boolean correct = cse.mCorrect;
            eval.addCase(correct, true);
            if (correct) {
                double r = ScoredPrecisionRecallEvaluation.div(eval.truePositive(), this.mPositiveRef);
                double p = eval.precision();
                prList.add(new double[]{r, p});
            }
            ++i;
        }
        return ScoredPrecisionRecallEvaluation.interpolate(prList, interpolate);
    }

    public double[][] rocCurve(boolean interpolate) {
        PrecisionRecallEvaluation eval = new PrecisionRecallEvaluation();
        ArrayList<double[]> prList = new ArrayList<double[]>();
        Iterator it = this.mCases.iterator();
        int i = 0;
        while (it.hasNext()) {
            Case cse = (Case)it.next();
            boolean correct = cse.mCorrect;
            eval.addCase(correct, true);
            if (correct) {
                double r = ScoredPrecisionRecallEvaluation.div(eval.truePositive(), this.mPositiveRef);
                double rr = 1.0 - ScoredPrecisionRecallEvaluation.div(eval.falsePositive(), this.mNegativeRef);
                prList.add(new double[]{r, rr});
            }
            ++i;
        }
        return ScoredPrecisionRecallEvaluation.interpolate(prList, interpolate);
    }

    public double maximumFMeasure() {
        return this.maximumFMeasure(1.0);
    }

    public double maximumFMeasure(double beta) {
        double maxF = 0.0;
        double[][] pr = this.prCurve(false);
        for (int i = 0; i < pr.length; ++i) {
            double f = PrecisionRecallEvaluation.fMeasure(beta, pr[i][0], pr[i][1]);
            maxF = Math.max(maxF, f);
        }
        return maxF;
    }

    public double prBreakevenPoint() {
        double[][] prCurve = this.prCurve(true);
        for (int i = 0; i < prCurve.length; ++i) {
            if (!(prCurve[i][0] > prCurve[i][1])) continue;
            return prCurve[i][1];
        }
        return 0.0;
    }

    public double averagePrecision() {
        double[][] prCurve = this.prCurve(false);
        double sum = 0.0;
        for (int i = 0; i < prCurve.length; ++i) {
            sum += prCurve[i][1];
        }
        return sum / (double)prCurve.length;
    }

    public double precisionAt(int rank) {
        if (this.mCases.size() < rank) {
            return Double.NaN;
        }
        int correctCount = 0;
        Iterator it = this.mCases.iterator();
        for (int i = 0; i < rank; ++i) {
            if (!((Case)it.next()).mCorrect) continue;
            ++correctCount;
        }
        return (double)correctCount / (double)rank;
    }

    public double reciprocalRank() {
        Iterator it = this.mCases.iterator();
        int i = 0;
        while (it.hasNext()) {
            Case cse = (Case)it.next();
            boolean correct = cse.mCorrect;
            if (correct) {
                return 1.0 / (double)(i + 1);
            }
            ++i;
        }
        return 0.0;
    }

    public double areaUnderPrCurve(boolean interpolate) {
        return ScoredPrecisionRecallEvaluation.areaUnder(this.prCurve(interpolate));
    }

    public double areaUnderRocCurve(boolean interpolate) {
        return ScoredPrecisionRecallEvaluation.areaUnder(this.rocCurve(interpolate));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  Area Under PR Curve (interpolated)=" + this.areaUnderPrCurve(true));
        sb.append("\n  Area Under PR Curve (uninterpolated)=" + this.areaUnderPrCurve(false));
        sb.append("\n  Area Under ROC Curve (interpolated)=" + this.areaUnderRocCurve(true));
        sb.append("\n  Area Under ROC Curve (uninterpolated)=" + this.areaUnderRocCurve(false));
        sb.append("\n  Average Precision=" + this.averagePrecision());
        sb.append("\n  Maximum F(1) Measure=" + this.maximumFMeasure());
        sb.append("\n  BEP (Precision-Recall break even point)=" + this.prBreakevenPoint());
        sb.append("\n  Reciprocal Rank=" + this.reciprocalRank());
        int[] ranks = new int[]{5, 10, 25, 100, 500};
        for (int i = 0; i < ranks.length && this.mCases.size() < ranks[i]; ++i) {
            sb.append("\n  Precision at " + ranks[i] + "=" + this.precisionAt(ranks[i]));
        }
        return sb.toString();
    }

    static double div(double x, double y) {
        return x / y;
    }

    private static double[][] interpolate(ArrayList prList, boolean interpolate) {
        if (!interpolate) {
            double[][] rps = new double[prList.size()][];
            prList.toArray((T[])rps);
            return rps;
        }
        Collections.reverse(prList);
        LinkedList<double[]> resultList = new LinkedList<double[]>();
        Iterator it = prList.iterator();
        double maxP = Double.NEGATIVE_INFINITY;
        while (it.hasNext()) {
            double[] rp = (double[])it.next();
            double p = rp[1];
            if (!(maxP < p)) continue;
            maxP = p;
            resultList.addFirst(rp);
        }
        double[][] rps = new double[resultList.size()][];
        resultList.toArray((T[])rps);
        return rps;
    }

    private static double areaUnder(double[][] zeroOneStepFunction) {
        double area = 0.0;
        double lastX = 0.0;
        for (int i = 0; i < zeroOneStepFunction.length; ++i) {
            double x = zeroOneStepFunction[i][0];
            double height = zeroOneStepFunction[i][1];
            double width = x - lastX;
            area += width * height;
            lastX = x;
        }
        return area;
    }

    static class Case
    implements Scored {
        private final boolean mCorrect;
        private final double mScore;

        Case(boolean correct, double score) {
            this.mCorrect = correct;
            this.mScore = score;
        }

        public double score() {
            return this.mScore;
        }

        public String toString() {
            return this.mCorrect + " : " + this.mScore;
        }
    }
}

