/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classifier;
import com.aliasi.classify.PerceptronClassifier;
import com.aliasi.classify.ScoredClassification;
import com.aliasi.corpus.ClassificationHandler;
import com.aliasi.matrix.EuclideanDistance;
import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.matrix.Vector;
import com.aliasi.symbol.MapSymbolTable;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Compilable;
import com.aliasi.util.Distance;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.Proximity;
import com.aliasi.util.ScoredObject;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnnClassifier<E>
implements Classifier<E, ScoredClassification>,
ClassificationHandler<E, Classification>,
Compilable,
Serializable {
    static final long serialVersionUID = 5692985587478284405L;
    final FeatureExtractor<? super E> mFeatureExtractor;
    final int mK;
    final Proximity<Vector> mProximity;
    final boolean mWeightByProximity;
    final List<Integer> mTrainingCategories;
    final List<SparseFloatVector> mTrainingVectors;
    final MapSymbolTable mFeatureSymbolTable;
    final MapSymbolTable mCategorySymbolTable;

    KnnClassifier(FeatureExtractor<? super E> featureExtractor, int k, Proximity<Vector> proximity, boolean weightByProximity, List<Integer> trainingCategories, List<SparseFloatVector> trainingVectors, MapSymbolTable featureSymbolTable, MapSymbolTable categorySymbolTable) {
        this.mFeatureExtractor = featureExtractor;
        this.mK = k;
        this.mProximity = proximity;
        this.mWeightByProximity = weightByProximity;
        this.mTrainingCategories = trainingCategories;
        this.mTrainingVectors = trainingVectors;
        this.mFeatureSymbolTable = featureSymbolTable;
        this.mCategorySymbolTable = categorySymbolTable;
    }

    public KnnClassifier(FeatureExtractor<? super E> featureExtractor, int k) {
        this(featureExtractor, k, EuclideanDistance.DISTANCE);
    }

    public KnnClassifier(FeatureExtractor<? super E> featureExtractor, int k, Distance<Vector> distance) {
        this(featureExtractor, k, new ProximityWrapper(distance), false);
    }

    public KnnClassifier(FeatureExtractor<? super E> featureExtractor, int k, Proximity<Vector> proximity, boolean weightByProximity) {
        this.mFeatureExtractor = featureExtractor;
        this.mK = k;
        this.mProximity = proximity;
        this.mWeightByProximity = weightByProximity;
        this.mFeatureSymbolTable = new MapSymbolTable();
        this.mCategorySymbolTable = new MapSymbolTable();
        this.mTrainingCategories = new ArrayList<Integer>();
        this.mTrainingVectors = new ArrayList<SparseFloatVector>();
    }

    @Override
    public void handle(E trainingInstance, Classification classification) {
        String category = classification.bestCategory();
        Map<String, Number> featureMap = this.mFeatureExtractor.features(trainingInstance);
        SparseFloatVector vector = PerceptronClassifier.toVectorAddSymbols(featureMap, this.mFeatureSymbolTable, 0x7FFFFFFE);
        this.mTrainingCategories.add(this.mCategorySymbolTable.getOrAddSymbolInteger(category));
        this.mTrainingVectors.add(vector);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ScoredClassification classify(E in) {
        void var8_11;
        Map<String, Number> featureMap = this.mFeatureExtractor.features(in);
        SparseFloatVector inputVector = PerceptronClassifier.toVector(featureMap, this.mFeatureSymbolTable, 0x7FFFFFFE);
        BoundedPriorityQueue<ScoredObject<Integer>> queue = new BoundedPriorityQueue<ScoredObject<Integer>>(ScoredObject.SCORE_COMPARATOR, this.mK);
        for (int i = 0; i < this.mTrainingCategories.size(); ++i) {
            Integer catId = this.mTrainingCategories.get(i);
            SparseFloatVector trainingVector = this.mTrainingVectors.get(i);
            double d = this.mProximity.proximity(inputVector, trainingVector);
            queue.add(new ScoredObject<Integer>(catId, d));
        }
        int numCats = this.mCategorySymbolTable.numSymbols();
        double[] scores = new double[numCats];
        for (ScoredObject scoredObject : queue) {
            int key = (Integer)scoredObject.getObject();
            double score = scoredObject.score();
            int n = key;
            scores[n] = scores[n] + (this.mWeightByProximity ? score : 1.0);
        }
        ScoredObject[] categoryScores = new ScoredObject[numCats];
        boolean bl = false;
        while (var8_11 < numCats) {
            categoryScores[var8_11] = new ScoredObject<String>(this.mCategorySymbolTable.idToSymbol((int)var8_11), scores[var8_11]);
            ++var8_11;
        }
        return ScoredClassification.create(categoryScores);
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    @Override
    public void compileTo(ObjectOutput out) throws IOException {
        out.writeObject(this.writeReplace());
    }

    static class TrainingInstance {
        final String mCategory;
        final SparseFloatVector mVector;

        TrainingInstance(String category, SparseFloatVector vector) {
            this.mCategory = category;
            this.mVector = vector;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProximityWrapper
    implements Proximity<Vector>,
    Serializable {
        Distance<Vector> mDistance;

        public ProximityWrapper() {
        }

        public ProximityWrapper(Distance<Vector> distance) {
            this.mDistance = distance;
        }

        @Override
        public double proximity(Vector v1, Vector v2) {
            double d = this.mDistance.distance(v1, v2);
            return d < 0.0 ? Double.MAX_VALUE : 1.0 / (1.0 + d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = 4951969636521202268L;
        final KnnClassifier<F> mClassifier;

        public Serializer() {
            this(null);
        }

        public Serializer(KnnClassifier<F> classifier) {
            this.mClassifier = classifier;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int i;
            AbstractExternalizable.serializeOrCompile(this.mClassifier.mFeatureExtractor, out);
            out.writeInt(this.mClassifier.mK);
            AbstractExternalizable.serializeOrCompile(this.mClassifier.mProximity, out);
            out.writeBoolean(this.mClassifier.mWeightByProximity);
            int numInstances = this.mClassifier.mTrainingCategories.size();
            out.writeInt(numInstances);
            List<Integer> catList = this.mClassifier.mTrainingCategories;
            for (i = 0; i < numInstances; ++i) {
                out.writeInt(this.mClassifier.mTrainingCategories.get(i));
            }
            for (i = 0; i < numInstances; ++i) {
                AbstractExternalizable.serializeOrCompile(this.mClassifier.mTrainingVectors.get(i), out);
            }
            AbstractExternalizable.serializeOrCompile(this.mClassifier.mFeatureSymbolTable, out);
            AbstractExternalizable.serializeOrCompile(this.mClassifier.mCategorySymbolTable, out);
        }

        @Override
        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            FeatureExtractor featureExtractor = (FeatureExtractor)in.readObject();
            int k = in.readInt();
            Proximity proximity = (Proximity)in.readObject();
            boolean weightByProximity = in.readBoolean();
            int numInstances = in.readInt();
            ArrayList<Integer> categoryList = new ArrayList<Integer>(numInstances);
            for (int i = 0; i < numInstances; ++i) {
                categoryList.add(new Integer(in.readInt()));
            }
            ArrayList<SparseFloatVector> vectorList = new ArrayList<SparseFloatVector>(numInstances);
            for (int i = 0; i < numInstances; ++i) {
                vectorList.add((SparseFloatVector)in.readObject());
            }
            MapSymbolTable featureSymbolTable = (MapSymbolTable)in.readObject();
            MapSymbolTable categorySymbolTable = (MapSymbolTable)in.readObject();
            return new KnnClassifier(featureExtractor, k, proximity, weightByProximity, categoryList, vectorList, featureSymbolTable, categorySymbolTable);
        }
    }
}

