/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.ConditionalClassification;
import com.aliasi.stats.Statistics;
import com.aliasi.util.Math;

public class JointClassification
extends ConditionalClassification {
    private final double[] mLogJointProbs;

    public JointClassification(String[] categories, double[] log2JointProbs) {
        this(categories, log2JointProbs, log2JointProbs);
    }

    public JointClassification(String[] categories, double[] scores, double[] log2JointProbs) {
        super(categories, scores, JointClassification.logJointToConditional(log2JointProbs), Double.POSITIVE_INFINITY);
        this.mLogJointProbs = log2JointProbs;
    }

    public double jointLog2Probability(int rank) {
        return rank >= this.mLogJointProbs.length ? Double.NEGATIVE_INFINITY : this.mLogJointProbs[rank];
    }

    public double score(int rank) {
        return super.score(rank);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Rank  Category  Score  P(Category|Input)   log2 P(Category,Input)\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(i + "=" + this.category(i) + " " + this.score(i) + " " + this.conditionalProbability(i) + " " + this.jointLog2Probability(i) + '\n');
        }
        return sb.toString();
    }

    private static double[] logJointToConditional(double[] logJointProbs) {
        for (int i = 0; i < logJointProbs.length; ++i) {
            if (logJointProbs[i] > 0.0 && logJointProbs[i] < 1.0E-10) {
                logJointProbs[i] = 0.0;
            }
            if (!(logJointProbs[i] > 0.0) && !Double.isNaN(logJointProbs[i])) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("Joint probs must be zero or negative. Found log2JointProbs[" + i + "]=" + logJointProbs[i]);
            for (int k = 0; k < logJointProbs.length; ++k) {
                sb.append("\nlogJointProbs[" + k + "]=" + logJointProbs[k]);
            }
            throw new IllegalArgumentException(sb.toString());
        }
        double max = Math.maximum(logJointProbs);
        double[] probRatios = new double[logJointProbs.length];
        for (int i = 0; i < logJointProbs.length; ++i) {
            probRatios[i] = java.lang.Math.pow(2.0, logJointProbs[i] - max);
            if (probRatios[i] == Double.POSITIVE_INFINITY) {
                probRatios[i] = 3.4028234663852886E38;
                continue;
            }
            if (probRatios[i] != Double.NEGATIVE_INFINITY && !Double.isNaN(probRatios[i])) continue;
            probRatios[i] = 0.0;
        }
        return Statistics.normalize(probRatios);
    }
}

