/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.ScoredClassification;
import com.aliasi.util.Math;

public class ConditionalClassification
extends ScoredClassification {
    private final double[] mConditionalProbs;
    private static final double TOLERANCE = 0.01;

    public ConditionalClassification(String[] categories, double[] conditionalProbs) {
        this(categories, conditionalProbs, conditionalProbs, 0.01);
    }

    public ConditionalClassification(String[] categories, double[] scores, double[] conditionalProbs) {
        this(categories, scores, conditionalProbs, 0.01);
    }

    public ConditionalClassification(String[] categories, double[] conditionalProbs, double tolerance) {
        this(categories, conditionalProbs, conditionalProbs, tolerance);
    }

    public ConditionalClassification(String[] categories, double[] scores, double[] conditionalProbs, double tolerance) {
        super(categories, scores);
        this.mConditionalProbs = conditionalProbs;
        if (tolerance < 0.0 || Double.isNaN(tolerance)) {
            String msg = "Tolerance must be a positive number. Found tolerance=" + tolerance;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < conditionalProbs.length; ++i) {
            if (!(conditionalProbs[i] < 0.0) && !(conditionalProbs[i] > 1.0)) continue;
            String msg = "Conditional probabilities must be  between 0.0 and 1.0. Found conditionalProbs[" + i + "]=" + conditionalProbs[i];
            throw new IllegalArgumentException(msg);
        }
        double sum = Math.sum(conditionalProbs);
        if (sum < 1.0 - tolerance || sum > 1.0 + tolerance) {
            String msg = "Conditional probabilities must sum to 1.0. Acceptable tolerance=" + tolerance + " Found sum=" + sum;
            throw new IllegalArgumentException(msg);
        }
    }

    public double conditionalProbability(int rank) {
        if (rank < 0 || rank > this.mConditionalProbs.length - 1) {
            String msg = "Require rank in range 0.." + (this.mConditionalProbs.length - 1) + " Found rank=" + rank;
            throw new IllegalArgumentException(msg);
        }
        return this.mConditionalProbs[rank];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Rank  Category  Score  P(Category|Input)\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(i + "=" + this.category(i) + " " + this.score(i) + " " + this.conditionalProbability(i) + '\n');
        }
        return sb.toString();
    }
}

