/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.DynamicLMClassifier;
import com.aliasi.lm.LanguageModel;
import com.aliasi.lm.UniformBoundaryLM;
import com.aliasi.lm.UniformProcessLM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryLMClassifier
extends DynamicLMClassifier<LanguageModel.Dynamic> {
    private final String mAcceptCategory;
    private final String mRejectCategory;
    public static final String DEFAULT_ACCEPT_CATEGORY = Boolean.TRUE.toString();
    public static final String DEFAULT_REJECT_CATEGORY = Boolean.FALSE.toString();

    public BinaryLMClassifier(LanguageModel.Dynamic acceptingLM, double crossEntropyThreshold) {
        this(acceptingLM, crossEntropyThreshold, DEFAULT_ACCEPT_CATEGORY, DEFAULT_REJECT_CATEGORY);
    }

    public BinaryLMClassifier(LanguageModel.Dynamic acceptingLM, double crossEntropyThreshold, String acceptCategory, String rejectCategory) {
        super(new String[]{rejectCategory, acceptCategory}, new LanguageModel.Dynamic[]{BinaryLMClassifier.createRejectLM(crossEntropyThreshold, acceptingLM), acceptingLM});
        this.mAcceptCategory = acceptCategory;
        this.mRejectCategory = rejectCategory;
        this.categoryEstimator().train(acceptCategory, 1L);
        this.categoryEstimator().train(rejectCategory, 1L);
    }

    public String acceptCategory() {
        return this.mAcceptCategory;
    }

    public String rejectCategory() {
        return this.mRejectCategory;
    }

    @Override
    public void train(String category, char[] cs, int start, int end) {
        super.train(category, cs, start, end);
    }

    @Override
    public void train(String category, CharSequence cSeq) {
        this.lmForCategory(this.mAcceptCategory).train(cSeq);
    }

    @Override
    public void resetCategory(String category, LanguageModel.Dynamic lm, int newCount) {
        String msg = "Resets not allowed for Binary LM classifier.";
        throw new UnsupportedOperationException(msg);
    }

    static LanguageModel.Dynamic createRejectLM(double crossEntropyThreshold, LanguageModel acceptingLM) {
        if (acceptingLM instanceof LanguageModel.Sequence) {
            return new UniformBoundaryLM(crossEntropyThreshold);
        }
        return new UniformProcessLM(crossEntropyThreshold);
    }
}

