/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.CompiledEstimator;
import com.aliasi.chunk.TokenShapeChunker;
import com.aliasi.chunk.TokenShapeDecoder;
import com.aliasi.chunk.TrainableEstimator;
import com.aliasi.corpus.ChunkHandler;
import com.aliasi.corpus.ChunkHandlerAdapter;
import com.aliasi.corpus.TagHandler;
import com.aliasi.tokenizer.TokenCategorizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import com.aliasi.util.ObjectToCounterMap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class TrainTokenShapeChunker
implements TagHandler,
ChunkHandler,
Compilable {
    private final int mKnownMinTokenCount;
    private final int mMinTokenCount;
    private final int mMinTagCount;
    private final TokenCategorizer mTokenCategorizer;
    private final TokenizerFactory mTokenizerFactory;
    private final TrainableEstimator mTrainableEstimator;
    private final ArrayList mTokenList = new ArrayList();
    private final ArrayList mTagList = new ArrayList();

    public TrainTokenShapeChunker(TokenCategorizer categorizer, TokenizerFactory factory) {
        this(categorizer, factory, 8, 1, 1);
    }

    public TrainTokenShapeChunker(TokenCategorizer categorizer, TokenizerFactory factory, int knownMinTokenCount, int minTokenCount, int minTagCount) {
        this.mTokenCategorizer = categorizer;
        this.mTokenizerFactory = factory;
        this.mKnownMinTokenCount = knownMinTokenCount;
        this.mMinTokenCount = minTokenCount;
        this.mMinTagCount = minTagCount;
        this.mTrainableEstimator = new TrainableEstimator(categorizer);
    }

    public void handle(String[] tokens, String[] whitespaces, String[] tags) {
        if (tokens.length != tags.length) {
            String msg = "Tokens and tags must be same length. Found tokens.length=" + tokens.length + " tags.length=" + tags.length;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < tokens.length; ++i) {
            this.mTokenList.add(tokens[i]);
            this.mTagList.add(tags[i]);
        }
    }

    public void handle(Chunking chunking) {
        ChunkHandlerAdapter handler = new ChunkHandlerAdapter(this, this.mTokenizerFactory, false);
        handler.handle(chunking);
    }

    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    void replaceUnknownsWithCategories(String[] tokens) {
        int i;
        ObjectToCounterMap<String> counter = new ObjectToCounterMap<String>();
        for (i = 0; i < tokens.length; ++i) {
            counter.increment(tokens[i]);
        }
        for (i = 0; i < tokens.length; ++i) {
            if (counter.getCount(tokens[i]) >= this.mKnownMinTokenCount) continue;
            tokens[i] = this.mTokenCategorizer.categorize(tokens[i]);
        }
    }

    static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = 142720610674437597L;
        final TrainTokenShapeChunker mChunker;

        public Externalizer() {
            this(null);
        }

        public Externalizer(TrainTokenShapeChunker chunker) {
            this.mChunker = chunker;
        }

        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            TokenizerFactory factory = (TokenizerFactory)in.readObject();
            TokenCategorizer categorizer = (TokenCategorizer)in.readObject();
            CompiledEstimator estimator = (CompiledEstimator)in.readObject();
            TokenShapeDecoder decoder = new TokenShapeDecoder(estimator, categorizer, 1000.0);
            return new TokenShapeChunker(factory, decoder);
        }

        public void writeExternal(ObjectOutput objOut) throws IOException {
            int len = this.mChunker.mTagList.size();
            String[] tokens = this.mChunker.mTokenList.toArray(new String[len]);
            String[] tags = this.mChunker.mTagList.toArray(new String[len]);
            this.mChunker.mTrainableEstimator.handle(tokens, tags);
            this.mChunker.replaceUnknownsWithCategories(tokens);
            this.mChunker.mTrainableEstimator.handle(tokens, tags);
            this.mChunker.mTrainableEstimator.prune(this.mChunker.mMinTagCount, this.mChunker.mMinTokenCount);
            this.mChunker.mTrainableEstimator.smoothTags(1);
            ((Compilable)((Object)this.mChunker.mTokenizerFactory)).compileTo(objOut);
            ((Compilable)((Object)this.mChunker.mTokenCategorizer)).compileTo(objOut);
            this.mChunker.mTrainableEstimator.compileTo(objOut);
        }
    }
}

