/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.chunk.Tags;
import com.aliasi.chunk.TokenShapeDecoder;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.Strings;
import java.util.ArrayList;

public class TokenShapeChunker
implements Chunker {
    private final TokenizerFactory mTokenizerFactory;
    private final TokenShapeDecoder mDecoder;

    TokenShapeChunker(TokenizerFactory tf, TokenShapeDecoder decoder) {
        this.mTokenizerFactory = tf;
        this.mDecoder = decoder;
    }

    public Chunking chunk(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.chunk(cs, 0, cs.length);
    }

    public Chunking chunk(char[] cs, int start, int end) {
        ArrayList tokenList = new ArrayList();
        ArrayList whiteList = new ArrayList();
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, end - start);
        tokenizer.tokenize(tokenList, whiteList);
        ChunkingImpl chunking = new ChunkingImpl(cs, start, end);
        if (tokenList.size() == 0) {
            return chunking;
        }
        String[] tokens = new String[tokenList.size()];
        String[] whites = new String[whiteList.size()];
        tokenList.toArray(tokens);
        whiteList.toArray(whites);
        int[] tokenStarts = new int[tokens.length];
        int[] tokenEnds = new int[tokens.length];
        int pos = whites[0].length();
        for (int i = 0; i < tokens.length; ++i) {
            tokenStarts[i] = pos;
            tokenEnds[i] = pos += tokens[i].length();
            pos += whites[i + 1].length();
        }
        String[] tags = this.mDecoder.decodeTags(tokens);
        if (tags.length < 1) {
            return chunking;
        }
        int neStartIdx = -1;
        int neEndIdx = -1;
        String neTag = "O";
        for (int i = 0; i < tags.length; ++i) {
            if (!tags[i].equals(neTag)) {
                if (!Tags.isOutTag(neTag)) {
                    Chunk chunk = ChunkFactory.createChunk(neStartIdx, neEndIdx, Tags.baseTag(neTag));
                    chunking.add(chunk);
                }
                neTag = Tags.toInnerTag(tags[i]);
                neStartIdx = tokenStarts[i];
            }
            neEndIdx = tokenEnds[i];
        }
        if (!Tags.isOutTag(neTag)) {
            Chunk chunk = ChunkFactory.createChunk(neStartIdx, neEndIdx, Tags.baseTag(neTag));
            chunking.add(chunk);
        }
        return chunking;
    }

    public void setLog2Beam(double beamWidth) {
        if (beamWidth <= 0.0 || Double.isNaN(beamWidth)) {
            String msg = "Require beam width to be positive. Found beamWidth=" + beamWidth;
            throw new IllegalArgumentException(msg);
        }
        this.mDecoder.setLog2Beam(beamWidth);
    }
}

