/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExChunker
implements Chunker {
    final Pattern mPattern;
    final String mChunkType;
    final double mChunkScore;

    public RegExChunker(String regex, String chunkType, double chunkScore) {
        this(Pattern.compile(regex), chunkType, chunkScore);
    }

    public RegExChunker(Pattern pattern, String chunkType, double chunkScore) {
        this.mPattern = pattern;
        this.mChunkType = chunkType;
        this.mChunkScore = chunkScore;
    }

    public Chunking chunk(CharSequence cSeq) {
        ChunkingImpl result = new ChunkingImpl(cSeq);
        Matcher matcher = this.mPattern.matcher(cSeq);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            Chunk chunk = ChunkFactory.createChunk(start, end, this.mChunkType, this.mChunkScore);
            result.add(chunk);
        }
        return result;
    }

    public Chunking chunk(char[] cs, int start, int end) {
        return this.chunk(new String(cs, start, end - start));
    }
}

