/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.Chunking;
import com.aliasi.util.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkingImpl
implements Chunking {
    private final String mString;
    private final Set<Chunk> mChunkSet = new LinkedHashSet<Chunk>();

    public ChunkingImpl(CharSequence cSeq) {
        this.mString = ((Object)cSeq).toString();
    }

    public ChunkingImpl(char[] cs, int start, int end) {
        this(new String(cs, start, end - start));
    }

    public void addAll(Collection chunks) {
        Iterator it = chunks.iterator();
        while (it.hasNext()) {
            Object next = null;
            next = it.next();
            if (!(next instanceof Chunk)) {
                String foundClass = next == null ? "null" : next.getClass().toString();
                String msg = "Chunks must implement Chunk interface. Found class=" + foundClass;
                throw new IllegalArgumentException(msg);
            }
            this.add((Chunk)next);
        }
    }

    public void add(Chunk chunk) {
        if (chunk.end() > this.mString.length()) {
            String msg = "End point of chunk beyond end of char sequence.Char sequence length=" + this.mString.length() + " chunk.end()=" + chunk.end();
            throw new IllegalArgumentException(msg);
        }
        this.mChunkSet.add(chunk);
    }

    @Override
    public CharSequence charSequence() {
        return this.mString;
    }

    @Override
    public Set<Chunk> chunkSet() {
        return Collections.unmodifiableSet(this.mChunkSet);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof Chunking ? ChunkingImpl.equal(this, (Chunking)that) : false;
    }

    @Override
    public int hashCode() {
        return ChunkingImpl.hashCode(this);
    }

    public static boolean equal(Chunking chunking1, Chunking chunking2) {
        return Strings.equalCharSequence(chunking1.charSequence(), chunking2.charSequence()) && ((Object)chunking1.chunkSet()).equals(chunking2.chunkSet());
    }

    public static int hashCode(Chunking chunking) {
        return Strings.hashCode(chunking.charSequence()) + 31 * ((Object)chunking.chunkSet()).hashCode();
    }

    public String toString() {
        return this.charSequence() + " : " + this.chunkSet();
    }
}

