/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkAndCharSeq;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.classify.PrecisionRecallEvaluation;
import com.aliasi.util.Strings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkingEvaluation {
    private final Set<Chunking[]> mCases = new HashSet<Chunking[]>();
    private final Set<ChunkAndCharSeq> mTruePositiveSet = new HashSet<ChunkAndCharSeq>();
    private final Set<ChunkAndCharSeq> mFalsePositiveSet = new HashSet<ChunkAndCharSeq>();
    private final Set<ChunkAndCharSeq> mFalseNegativeSet = new HashSet<ChunkAndCharSeq>();
    String mLastCase = null;

    public Set<Chunking[]> cases() {
        return Collections.unmodifiableSet(this.mCases);
    }

    public ChunkingEvaluation perTypeEvaluation(String chunkType) {
        ChunkingEvaluation evaluation = new ChunkingEvaluation();
        Set<Chunking[]> cases = this.cases();
        for (Chunking[] testCase : cases) {
            Chunking referenceChunking = testCase[0];
            Chunking responseChunking = testCase[1];
            Chunking referenceChunkingRestricted = ChunkingEvaluation.restrictTo(referenceChunking, chunkType);
            Chunking responseChunkingRestricted = ChunkingEvaluation.restrictTo(responseChunking, chunkType);
            evaluation.addCase(referenceChunkingRestricted, responseChunkingRestricted);
        }
        return evaluation;
    }

    static Chunking restrictTo(Chunking chunking, String type) {
        CharSequence cs = chunking.charSequence();
        ChunkingImpl chunkingOut = new ChunkingImpl(cs);
        for (Chunk chunk : chunking.chunkSet()) {
            if (!chunk.type().equals(type)) continue;
            chunkingOut.add(chunk);
        }
        return chunkingOut;
    }

    static String formatChunks(Chunking chunking) {
        StringBuffer sb = new StringBuffer();
        Set<Chunk> chunkSet = chunking.chunkSet();
        Iterator<Chunk> it = chunkSet.iterator();
        int pos = 0;
        while (it.hasNext()) {
            char marker;
            Chunk chunk = it.next();
            int start = chunk.start();
            int padLength = start - pos;
            for (int j = 0; j < padLength; ++j) {
                sb.append(" ");
            }
            int end = chunk.end();
            int chunkLength = end - start;
            char c = marker = chunk.type().length() > 0 ? (char)chunk.type().charAt(0) : (char)'!';
            if (chunkLength > 0) {
                sb.append(marker);
            }
            for (int j = 1; j < chunkLength; ++j) {
                sb.append(".");
            }
            pos = end;
        }
        sb.append("\n");
        return sb.toString();
    }

    static String formatHeader(int indent, Chunking chunking) {
        String cs = ((Object)chunking.charSequence()).toString();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        sb.append("CHUNKS= ");
        for (Chunk chunk : chunking.chunkSet()) {
            sb.append("(" + chunk.start() + "," + chunk.end() + "):" + chunk.type() + "   ");
        }
        if (sb.charAt(sb.length() - 1) != '\n') {
            sb.append("\n");
        }
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        sb.append(cs);
        sb.append("\n");
        int length = cs.length();
        ChunkingEvaluation.printMods(1, length, sb, indent);
        ChunkingEvaluation.printMods(10, length, sb, indent);
        ChunkingEvaluation.printMods(100, length, sb, indent);
        if (sb.charAt(sb.length() - 1) != '\n') {
            sb.append("\n");
        }
        return sb.toString();
    }

    static void printMods(int base, int length, StringBuffer sb, int indent) {
        int i;
        if (length <= base) {
            return;
        }
        for (i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        for (i = 0; i < length; ++i) {
            if (base == 1 || i >= base && i % 10 == 0) {
                sb.append(Integer.toString(i / base % 10));
                continue;
            }
            sb.append(" ");
        }
        sb.append("\n");
    }

    public void addCase(Chunking referenceChunking, Chunking responseChunking) {
        StringBuffer sb = new StringBuffer();
        CharSequence cSeq = referenceChunking.charSequence();
        if (!Strings.equalCharSequence(cSeq, responseChunking.charSequence())) {
            String msg = "Char sequences must be same. Reference char seq=" + cSeq + " Response char seq=" + responseChunking.charSequence();
            throw new IllegalArgumentException(msg);
        }
        sb.append("\n");
        sb.append(ChunkingEvaluation.formatHeader(5, referenceChunking));
        sb.append("\n REF ");
        sb.append(ChunkingEvaluation.formatChunks(referenceChunking));
        sb.append("RESP ");
        sb.append(ChunkingEvaluation.formatChunks(responseChunking));
        sb.append("\n");
        this.mLastCase = sb.toString();
        this.mCases.add(new Chunking[]{referenceChunking, responseChunking});
        Set refSet = ChunkingEvaluation.unscoredChunkSet(referenceChunking);
        Set respSet = ChunkingEvaluation.unscoredChunkSet(responseChunking);
        for (Chunk respChunk : respSet) {
            boolean inRef = refSet.remove(respChunk);
            ChunkAndCharSeq ccs = new ChunkAndCharSeq(respChunk, cSeq);
            if (inRef) {
                this.mTruePositiveSet.add(ccs);
                continue;
            }
            this.mFalsePositiveSet.add(ccs);
        }
        for (Chunk refChunk : refSet) {
            this.mFalseNegativeSet.add(new ChunkAndCharSeq(refChunk, cSeq));
        }
    }

    static Set unscoredChunkSet(Chunking chunking) {
        HashSet<Chunk> result = new HashSet<Chunk>();
        for (Chunk chunk : chunking.chunkSet()) {
            result.add(ChunkFactory.createChunk(chunk.start(), chunk.end(), chunk.type()));
        }
        return result;
    }

    public Set<ChunkAndCharSeq> truePositiveSet() {
        return Collections.unmodifiableSet(this.mTruePositiveSet);
    }

    public Set<ChunkAndCharSeq> falsePositiveSet() {
        return Collections.unmodifiableSet(this.mFalsePositiveSet);
    }

    public Set<ChunkAndCharSeq> falseNegativeSet() {
        return Collections.unmodifiableSet(this.mFalseNegativeSet);
    }

    public PrecisionRecallEvaluation precisionRecallEvaluation() {
        int tp = this.truePositiveSet().size();
        int fn = this.falseNegativeSet().size();
        int fp = this.falsePositiveSet().size();
        return new PrecisionRecallEvaluation(tp, fn, fp, 0L);
    }

    public String toString() {
        return this.precisionRecallEvaluation().toString();
    }
}

