/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.util.Scored;
import com.aliasi.util.Strings;

public class ChunkAndCharSeq
implements Scored {
    private final Chunk mChunk;
    private final CharSequence mSeq;
    private final int mHashCode;

    public ChunkAndCharSeq(Chunk chunk, CharSequence cSeq) {
        if (chunk.end() > cSeq.length()) {
            String msg = "Character sequence not long enough for chunk. Chunk end=" + chunk.end() + " Character sequence length=" + cSeq.length();
            throw new IllegalArgumentException(msg);
        }
        this.mChunk = chunk;
        this.mSeq = cSeq;
        this.mHashCode = ((Object)chunk).hashCode() + 31 * Strings.hashCode(cSeq);
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object that) {
        if (!(that instanceof ChunkAndCharSeq)) {
            return false;
        }
        ChunkAndCharSeq thatChunk = (ChunkAndCharSeq)that;
        if (thatChunk.hashCode() != this.hashCode()) {
            return false;
        }
        return ((Object)this.mChunk).equals(thatChunk.mChunk) && this.mSeq.equals(thatChunk.mSeq);
    }

    public String span() {
        return ((Object)this.mSeq.subSequence(this.mChunk.start(), this.mChunk.end())).toString();
    }

    public CharSequence spanStartContext(int contextLength) {
        int len;
        int end;
        if (contextLength < 1) {
            String msg = "Context length must be greater than 0.";
            throw new IllegalArgumentException(msg);
        }
        int start = this.mChunk.start() - contextLength;
        if (start < 0) {
            start = 0;
        }
        if ((end = this.mChunk.start() + contextLength) > this.mSeq.length()) {
            end = this.mSeq.length();
        }
        if ((len = end - start) < contextLength * 2) {
            StringBuffer padded = new StringBuffer();
            for (int i = contextLength * 2; i > len; --i) {
                padded.append(" ");
            }
            padded.append(((Object)this.mSeq.subSequence(start, end)).toString());
            return padded.subSequence(0, padded.length());
        }
        return ((Object)this.mSeq.subSequence(start, end)).toString();
    }

    public CharSequence spanEndContext(int contextLength) {
        int len;
        int end;
        if (contextLength < 1) {
            String msg = "Context length must be greater than 0.";
            throw new IllegalArgumentException(msg);
        }
        int start = this.mChunk.end() - contextLength;
        if (start < 0) {
            start = 0;
        }
        if ((end = this.mChunk.end() + contextLength) > this.mSeq.length()) {
            end = this.mSeq.length();
        }
        if ((len = end - start) < contextLength * 2) {
            StringBuffer padded = new StringBuffer();
            padded.append(((Object)this.mSeq.subSequence(start, end)).toString());
            for (int i = contextLength * 2; i > len; --i) {
                padded.append(" ");
            }
            return padded.subSequence(0, padded.length());
        }
        return ((Object)this.mSeq.subSequence(start, end)).toString();
    }

    public String charSequence() {
        return ((Object)this.mSeq).toString();
    }

    public Chunk chunk() {
        return this.mChunk;
    }

    public double score() {
        return this.chunk().score();
    }

    public String toString() {
        return this.chunk().start() + "-" + this.chunk().end() + "/" + this.span() + ":" + this.chunk().type();
    }
}

