------------------------------
-- CSEE 4840 Embedded System Design 
--
-- SOBA Server
--
--  Team Warriors: Avraham Shinnar  as1619@columbia.edu
--                 Benjamin Dweck  bjd2102@columbia.edu
--                 Oliver Irwin    omi3@columbia.edu
--                 Sean White      sw2061@columbia.edu
--
------------------------------

-- Based on Jaycam ethernet vhdl

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

--  Uncomment the following lines to use the declarations that are
--  provided for instantiating Xilinx primitive components.
--library UNISIM;
--use UNISIM.VComponents.all;

entity memoryctrl is
    Port ( rst : in std_logic;
           clk : in std_logic;
           cs : in std_logic; -- any of my devices selected
           opb_select : in std_logic; -- original select
			  
           rnw : in std_logic;

           eth_io : in std_logic;
           fullword : in std_logic;
 	   read_early : out std_logic;
 	   write_early : out std_logic;
           bus_req : out std_logic;
           
           videocycle : out std_logic;
           hihalf : out std_logic;
           wr_req : out std_logic;
           rd_req : out std_logic;
           xfer : out std_logic;
           ce0 : out std_logic;
           ce1 : out std_logic;
           rres : out std_logic;

	   vreq : in std_logic;
           video_ce : out std_logic
			  );
end memoryctrl;

architecture Behavioral of memoryctrl is

signal r_idle, r_common, r_w32, r_ra, r_rb, r_rc, r_xfer : std_logic;
signal r_weth1, r_weth2, r_weth3 : std_logic;
signal r_v1, r_v0, r_v2 : std_logic;
signal wr_req_i, rd_req_i, videocycle_i : std_logic;

begin

process(rst, clk)
begin
	if rst = '1' then
          r_idle <= '1';
          r_common <= '0';
          r_w32 <= '0';
          r_ra <= '0'; r_rb <= '0'; r_rc <= '0'; r_xfer <= '0'; r_weth1 <= '0';
          r_weth2 <= '0'; r_weth3 <= '0';

	elsif clk'event and clk='1' then

	r_idle <= (r_idle and not cs) or (r_xfer) or (not opb_select);
	r_common <= opb_select and (r_idle and cs);

        r_weth1 <= opb_select and (r_common and not rnw and eth_io);
        r_weth2 <= opb_select and (r_weth1); 
        r_weth3 <= opb_select and (r_weth2); 
	r_w32 <= opb_select and (r_common and not rnw and fullword);

	r_ra <= opb_select and (r_common and rnw);
	r_rb  <= opb_select and (r_ra);
	r_rc <= opb_select and (r_rb and (fullword or eth_io));
        
	r_xfer <= opb_select and ( (r_common and not rnw and not fullword and not eth_io)
                                 
		 or (r_w32) or (r_rb and not fullword and not eth_io)
		 or (r_rc)
                 or (r_weth2));

	end if;

end process;



read_early <= r_ra and eth_io;
write_early <= not ((r_common and not rnw and eth_io) or (r_weth1) or r_weth2);
hihalf <= r_w32 or (r_ra and fullword);

wr_req_i <= (r_common and not rnw and not eth_io) or (r_w32) or (r_weth1) or (r_weth2) or (r_weth3);
rd_req_i <= (r_common and rnw) or (r_ra and (fullword or eth_io));
wr_req <= wr_req_i;
rd_req <= rd_req_i;
bus_req <= rd_req_i or wr_req_i or r_common;

xfer <= r_xfer;
rres <= r_xfer;
ce0 <= r_rb or (r_rc and eth_io);
ce1 <= r_rb or r_rc;


-- the video state machine


-- smw: killed the video state machine and set everything to 0

videocycle_i <= (r_v1 or r_v0) and not (rd_req_i or wr_req_i);
--videocycle <= videocycle_i;
videocycle <= '0';
video_ce <= '0';
r_v0 <='0';
r_v1 <='0';
r_v2 <='0';


end Behavioral;
