/*-----------------------------
# CSEE 4840 Embedded System Design
#
# SOBA Server
#
#  Team Warriors: Avraham Shinnar  as1619@columbia.edu
#                 Benjamin Dweck  bjd2102@columbia.edu
#                 Oliver Irwin    omi3@columbia.edu
#                 Sean White      sw2061@columbia.edu
#
-----------------------------*/

#include "xparameters.h"
#include "xbasic_types.h"
#include "xio.h"
#include "ether.h"
#include "xintc_l.h"

unsigned long uart_out = 0;
BYTE new_data=0;

void audio_sampler_handler(void *callback)
{
  // microblaze_disable_interrupts();
  new_data=1;
  //microblaze_enable_interrupts();
}

int main()
{
  int ret;

   // FIRST: Run diagnostics, init ethernet controller, and stuff packets

   print("\r\n");
   print("Hello World!\r\n") ; 
   print("Running diagnostics\r\n");
   if (ret=diagnostics()) {
     print("Diagnostics failed. internal error number ");
     putnum(ret);
     print("\r\n");
     
   } else {
     print("Diagnostics successful.\r\n");
   }
   
   if(init()) {
     print("Ethernet NIC not present or not initializing correctly\r\n");
     return 1; 
   } 

   /* initializing interrupts */
   XIntc_mEnableIntr(XPAR_INTC_SINGLE_BASEADDR, XPAR_AUDIO_SAMPLER_INTERRUPT_MASK);
   XIntc_mMasterEnable(XPAR_INTC_SINGLE_BASEADDR);
   XIntc_RegisterHandler(XPAR_INTC_SINGLE_BASEADDR, XPAR_INTC_AUDIO_SAMPLER_INTERRUPT_INTR,
			 audio_sampler_handler, (void*)0); 
   
    microblaze_enable_interrupts();
 
    for (;;) { 
      /* new_data is set in the interrupt handler when new data is ready. */
      if(new_data == 1) {
	
	new_data = 0;
	
	/* grab the data from the audio controller*/
	uart_out = XIo_In32(XPAR_AUDIO_SAMPLER_BASEADDR);
	/* the standard audio format is little endian, so we swap the bytes: 
	 we have 4 bytes, they get reordered from 1234 to 2143. */
	uart_out = ((uart_out >> 24 & 0xff) << 16) |
	  ((uart_out >> 16 & 0xff) << 24) |
	  (uart_out >> 8 & 0xff) |
	  ((uart_out & 0xff) << 8);

	/* output the new sample to the ethernet card */
	output_sample((WORD *)(&uart_out));
      }

    }
  return 0;
}

