/*-----------------------------
# CSEE 4840 Embedded System Design
#
# SOBA Server
#
#  Team Warriors: Avraham Shinnar  as1619@columbia.edu
#                 Benjamin Dweck  bjd2102@columbia.edu
#                 Oliver Irwin    omi3@columbia.edu
#                 Sean White      sw2061@columbia.edu
#
-----------------------------*/

#include "xio.h"
#include "xbasic_types.h"

#define dprint print

#ifndef BYTE
#define BYTE unsigned char
#endif
#ifndef WORD
#define WORD unsigned short
#endif

// define the size of a packet

#define MAC_HEADER_SIZE 14
#define IP_HEADER_SIZE 20
#define UDP_HEADER_SIZE 8
#define RTP_HEADER_SIZE 12

#define HEADER_SIZE (MAC_HEADER_SIZE+IP_HEADER_SIZE+UDP_HEADER_SIZE+RTP_HEADER_SIZE)

#define IP_LENGTH (PACKET_SIZE-MAC_HEADER_SIZE)
#define UDP_LENGTH (IP_LENGTH-IP_HEADER_SIZE)

#define IP_CHECKSUM_OFFSET 24
#define UDP_CHECKSUM_OFFSET 40
#define RTP_SEQNUM_OFFSET 44
#define RTP_TIMESTAMP_OFFSET 46

#define DATA_CHUNK_SIZE 16
#define DATA_CHUNKS_IN_PACKET 90

#define PAYLOAD_SIZE (DATA_CHUNKS_IN_PACKET*DATA_CHUNK_SIZE)
#define PACKET_SIZE (PAYLOAD_SIZE+HEADER_SIZE)

#define PACKET_BUFFERS 1


// NE2000 definitions
#define NIC_BASE (0x00A00400) // Base I/O address of the NIC card
#define DATAPORT (0x10*2)
#define NE_RESET (0x1f*2)

// NIC page0 register offsets
#define CMDR    (0x00*2) // command register for read & write
#define PSTART  (0x01*2) // page start register for write
#define PSTOP   (0x02*2) // page stop register for write
#define BNRY    (0x03*2) // boundary reg for rd and wr
#define TPSR    (0x04*2) // tx start page start reg for wr
#define TBCR0   (0x05*2) // tx byte count 0 reg for wr
#define TBCR1   (0x06*2) // tx byte count 1 reg for wr
#define ISR     (0x07*2) // interrupt status reg for rd and wr
#define RSAR0   (0x08*2) // low byte of remote start addr
#define RSAR1   (0x09*2) // hi byte of remote start addr
#define RBCR0   (0x0A*2) // remote byte count reg 0 for wr
#define RBCR1   (0x0B*2) // remote byte count reg 1 for wr
#define RCR     (0x0C*2) // rx configuration reg for wr
#define TCR     (0x0D*2) // tx configuration reg for wr
#define DCR     (0x0E*2) // data configuration reg for wr
#define IMR     (0x0F*2) // interrupt mask reg for wr

// NIC page 1 register offsets
#define PAR0    (0x01*2) // physical addr reg 0 for rd and wr
#define CURR    (0x07*2) // current page reg for rd and wr
#define MAR0    (0x08*2) // multicast addr reg 0 for rd and WR

// Buffer Length and Field Definition Info
#define TXSTART  0x41              // Tx buffer start page
#define TXPAGES  8                 // Pages for Tx buffer
#define RXSTART  (TXSTART+TXPAGES) // Rx buffer start page
#define RXSTOP   0x7e              // Rx buffer end page for word mode


#define BASE_ADDR (XPAR_ETHERNET_PERIPHERAL_BASEADDR+0x400)
// macros for reading and writting registers
#define outnic(addr, data) XIo_Out16(NIC_BASE+addr, data)
#define innic(addr) (XIo_In16(NIC_BASE+addr))

#define PACKET_END_ADDRESS PACKET_START_ADDRESS+PACKET_SIZE
#define PACKET_START_ADDRESS  (TXSTART << 8)

#define PAYLOAD_START_ADDRESS PACKET_START_ADDRESS+HEADER_SIZE;
#define UDP_CHECKSUM_ADDRESS PACKET_START_ADDRESS+UDP_CHECKSUM_OFFSET
#define RTP_SEQNUM_ADDRESS PACKET_START_ADDRESS+RTP_SEQNUM_OFFSET


/* function prototypes, external interface. */
BYTE init();
BYTE output_sample(WORD *sample);
int diagnostics();
void wait(int mult);


/* symbolic names for various register bits */

#define ISR_PTX  0x02 // packet transmitted with no error
#define ISR_RXE  0x04 // recieve error
#define ISR_RDC  0x40 // Remote DMA Successful

#define CR_STOP  0x01
#define CR_START 0x02
#define CR_TXP   0x04
#define CR_READ  0x08
#define CR_WRITE 0x10
#define CR_ABORT 0x20
#define CR_COMPLETE 0x20
#define CR_PAGE0 0x00
#define CR_PAGE1 0x40

