LIBRARY unisim;
USE unisim.vcomponents.ALL;

--------------------------------------------------------------------------------
-- bram_elaborate.vhd
--------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;

-- synthesis translate_off
LIBRARY UNISIM;
USE UNISIM.VCOMPONENTS.ALL;
-- synthesis translate_on

ENTITY bram_elaborate IS
GENERIC (
	C_MEMSIZE : INTEGER := 4096;
	C_PORT_DWIDTH : INTEGER := 32;
	C_PORT_AWIDTH : INTEGER := 32;
	C_NUM_WE : INTEGER := 4;
	C_FAMILY : STRING := "spartan2e");
PORT (
	-- instance GLOBAL
	BRAM_Addr_B : IN STD_LOGIC_VECTOR(0 TO 31);
	BRAM_Dout_A : IN STD_LOGIC_VECTOR(0 TO 31);
	BRAM_EN_A : IN STD_LOGIC;
	BRAM_Dout_B : IN STD_LOGIC_VECTOR(0 TO 31);
	BRAM_EN_B : IN STD_LOGIC;
	BRAM_Din_A : OUT STD_LOGIC_VECTOR(0 TO 31);
	BRAM_Din_B : OUT STD_LOGIC_VECTOR(0 TO 31);
	BRAM_Clk_A : IN STD_LOGIC;
	BRAM_WEN_A : IN STD_LOGIC_VECTOR(0 TO 3);
	BRAM_WEN_B : IN STD_LOGIC_VECTOR(0 TO 3);
	BRAM_Clk_B : IN STD_LOGIC;
	BRAM_Rst_A : IN STD_LOGIC;
	BRAM_Rst_B : IN STD_LOGIC;
	BRAM_Addr_A : IN STD_LOGIC_VECTOR(0 TO 31));
END bram_elaborate;

ARCHITECTURE IMP OF bram_elaborate IS

--------------------------------------------------------------------------------
COMPONENT RAMB4_S4_S4 IS
PORT (
	CLKB : IN STD_LOGIC;
	ADDRA : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
	ADDRB : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
	DOA : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
	DOB : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
	ENA : IN STD_LOGIC;
	RSTA : IN STD_LOGIC;
	ENB : IN STD_LOGIC;
	RSTB : IN STD_LOGIC;
	DIA : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
	DIB : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
	WEA : IN STD_LOGIC;
	WEB : IN STD_LOGIC;
	CLKA : IN STD_LOGIC);
END COMPONENT;

--------------------------------------------------------------------------------
-- internal signals
--------------------------------------------------------------------------------

	SIGNAL dina : STD_LOGIC_VECTOR(31 DOWNTO 0);

	SIGNAL dinb : STD_LOGIC_VECTOR(31 DOWNTO 0);

	SIGNAL douta : STD_LOGIC_VECTOR(31 DOWNTO 0);

	SIGNAL doutb : STD_LOGIC_VECTOR(31 DOWNTO 0);

	SIGNAL net_gnd0 : STD_LOGIC;

BEGIN

--------------------------------------------------------------------------------
-- Power assignments
net_gnd0 <= '0';
--------------------------------------------------------------------------------
-- Constant assignments
--------------------------------------------------------------------------------
-- Top-level port assignments
dina <= BRAM_Dout_A;
dinb <= BRAM_Dout_B;
BRAM_Din_A <= douta;
BRAM_Din_B <= doutb;
--------------------------------------------------------------------------------
-- Lower-level assignments

--------------------------------------------------------------------------------
ramb4_s4_s4_0 : RAMB4_S4_S4
PORT MAP (
	CLKB => BRAM_Clk_B,
	ADDRA => BRAM_Addr_A(20 TO 29),
	ADDRB => BRAM_Addr_B(20 TO 29),
	DOA => douta(31 DOWNTO 28),
	DOB => doutb(31 DOWNTO 28),
	ENA => BRAM_EN_A,
	RSTA => net_gnd0,
	ENB => BRAM_EN_B,
	RSTB => net_gnd0,
	DIA => dina(31 DOWNTO 28),
	DIB => dinb(31 DOWNTO 28),
	WEA => BRAM_WEN_A(0),
	WEB => BRAM_WEN_B(0),
	CLKA => BRAM_Clk_A);

--------------------------------------------------------------------------------
ramb4_s4_s4_1 : RAMB4_S4_S4
PORT MAP (
	CLKB => BRAM_Clk_B,
	ADDRA => BRAM_Addr_A(20 TO 29),
	ADDRB => BRAM_Addr_B(20 TO 29),
	DOA => douta(27 DOWNTO 24),
	DOB => doutb(27 DOWNTO 24),
	ENA => BRAM_EN_A,
	RSTA => net_gnd0,
	ENB => BRAM_EN_B,
	RSTB => net_gnd0,
	DIA => dina(27 DOWNTO 24),
	DIB => dinb(27 DOWNTO 24),
	WEA => BRAM_WEN_A(0),
	WEB => BRAM_WEN_B(0),
	CLKA => BRAM_Clk_A);

--------------------------------------------------------------------------------
ramb4_s4_s4_2 : RAMB4_S4_S4
PORT MAP (
	CLKB => BRAM_Clk_B,
	ADDRA => BRAM_Addr_A(20 TO 29),
	ADDRB => BRAM_Addr_B(20 TO 29),
	DOA => douta(23 DOWNTO 20),
	DOB => doutb(23 DOWNTO 20),
	ENA => BRAM_EN_A,
	RSTA => net_gnd0,
	ENB => BRAM_EN_B,
	RSTB => net_gnd0,
	DIA => dina(23 DOWNTO 20),
	DIB => dinb(23 DOWNTO 20),
	WEA => BRAM_WEN_A(1),
	WEB => BRAM_WEN_B(1),
	CLKA => BRAM_Clk_A);

--------------------------------------------------------------------------------
ramb4_s4_s4_3 : RAMB4_S4_S4
PORT MAP (
	CLKB => BRAM_Clk_B,
	ADDRA => BRAM_Addr_A(20 TO 29),
	ADDRB => BRAM_Addr_B(20 TO 29),
	DOA => douta(19 DOWNTO 16),
	DOB => doutb(19 DOWNTO 16),
	ENA => BRAM_EN_A,
	RSTA => net_gnd0,
	ENB => BRAM_EN_B,
	RSTB => net_gnd0,
	DIA => dina(19 DOWNTO 16),
	DIB => dinb(19 DOWNTO 16),
	WEA => BRAM_WEN_A(1),
	WEB => BRAM_WEN_B(1),
	CLKA => BRAM_Clk_A);

--------------------------------------------------------------------------------
ramb4_s4_s4_4 : RAMB4_S4_S4
PORT MAP (
	CLKB => BRAM_Clk_B,
	ADDRA => BRAM_Addr_A(20 TO 29),
	ADDRB => BRAM_Addr_B(20 TO 29),
	DOA => douta(15 DOWNTO 12),
	DOB => doutb(15 DOWNTO 12),
	ENA => BRAM_EN_A,
	RSTA => net_gnd0,
	ENB => BRAM_EN_B,
	RSTB => net_gnd0,
	DIA => dina(15 DOWNTO 12),
	DIB => dinb(15 DOWNTO 12),
	WEA => BRAM_WEN_A(2),
	WEB => BRAM_WEN_B(2),
	CLKA => BRAM_Clk_A);

--------------------------------------------------------------------------------
ramb4_s4_s4_5 : RAMB4_S4_S4
PORT MAP (
	CLKB => BRAM_Clk_B,
	ADDRA => BRAM_Addr_A(20 TO 29),
	ADDRB => BRAM_Addr_B(20 TO 29),
	DOA => douta(11 DOWNTO 8),
	DOB => doutb(11 DOWNTO 8),
	ENA => BRAM_EN_A,
	RSTA => net_gnd0,
	ENB => BRAM_EN_B,
	RSTB => net_gnd0,
	DIA => dina(11 DOWNTO 8),
	DIB => dinb(11 DOWNTO 8),
	WEA => BRAM_WEN_A(2),
	WEB => BRAM_WEN_B(2),
	CLKA => BRAM_Clk_A);

--------------------------------------------------------------------------------
ramb4_s4_s4_6 : RAMB4_S4_S4
PORT MAP (
	CLKB => BRAM_Clk_B,
	ADDRA => BRAM_Addr_A(20 TO 29),
	ADDRB => BRAM_Addr_B(20 TO 29),
	DOA => douta(7 DOWNTO 4),
	DOB => doutb(7 DOWNTO 4),
	ENA => BRAM_EN_A,
	RSTA => net_gnd0,
	ENB => BRAM_EN_B,
	RSTB => net_gnd0,
	DIA => dina(7 DOWNTO 4),
	DIB => dinb(7 DOWNTO 4),
	WEA => BRAM_WEN_A(3),
	WEB => BRAM_WEN_B(3),
	CLKA => BRAM_Clk_A);

--------------------------------------------------------------------------------
ramb4_s4_s4_7 : RAMB4_S4_S4
PORT MAP (
	CLKB => BRAM_Clk_B,
	ADDRA => BRAM_Addr_A(20 TO 29),
	ADDRB => BRAM_Addr_B(20 TO 29),
	DOA => douta(3 DOWNTO 0),
	DOB => doutb(3 DOWNTO 0),
	ENA => BRAM_EN_A,
	RSTA => net_gnd0,
	ENB => BRAM_EN_B,
	RSTB => net_gnd0,
	DIA => dina(3 DOWNTO 0),
	DIB => dinb(3 DOWNTO 0),
	WEA => BRAM_WEN_A(3),
	WEB => BRAM_WEN_B(3),
	CLKA => BRAM_Clk_A);

END ARCHITECTURE IMP;
