/* $Id: xintc_l.h,v 1.5 2002/08/01 14:24:01 moleres Exp $ */
/******************************************************************************
*
*       XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS"
*       AS A COURTESY TO YOU, SOLELY FOR USE IN DEVELOPING PROGRAMS AND
*       SOLUTIONS FOR XILINX DEVICES.  BY PROVIDING THIS DESIGN, CODE,
*       OR INFORMATION AS ONE POSSIBLE IMPLEMENTATION OF THIS FEATURE,
*       APPLICATION OR STANDARD, XILINX IS MAKING NO REPRESENTATION
*       THAT THIS IMPLEMENTATION IS FREE FROM ANY CLAIMS OF INFRINGEMENT,
*       AND YOU ARE RESPONSIBLE FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE
*       FOR YOUR IMPLEMENTATION.  XILINX EXPRESSLY DISCLAIMS ANY
*       WARRANTY WHATSOEVER WITH RESPECT TO THE ADEQUACY OF THE
*       IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OR
*       REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE FROM CLAIMS OF
*       INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*       FOR A PARTICULAR PURPOSE.
*
*       (c) Copyright 2002 Xilinx Inc.
*       All rights reserved.
*
******************************************************************************/
/*****************************************************************************/
/**
*
* @file xintc_l.h
*
* This header file contains identifiers and low-level driver functions (or
* macros) that can be used to access the device.  The user should refer to the
* hardware device specification for more details of the device operation.
* High-level driver functions are defined in xintc.h.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who  Date     Changes
* ----- ---- -------- -----------------------------------------------
* 1.00b jhl  04/24/02 First release
* </pre>
*
******************************************************************************/

#ifndef XINTC_L_H /* prevent circular inclusions */
#define XINTC_L_H /* by using protection macros */

/***************************** Include Files *********************************/

#include "xbasic_types.h"
#include "xparameters.h"
#include "xio.h"

/*      uncomment when the libgen functionality arrives
#ifndef XPAR_XINTC_USE_DCR
#error "XPAR_XINTC_USE_DCR not defined"
#endif
*/

#if (XPAR_XINTC_USE_DCR != 0)
#include "xio_dcr.h"
#endif

/************************** Constant Definitions *****************************/

/* define the offsets from the base address for all the registers of the
 * interrupt controller, some registers may be optional in the hardware device
 */
#if (XPAR_XINTC_USE_DCR != 0)

#define XIN_ISR_OFFSET      0       /* Interrupt Status Register */
#define XIN_IPR_OFFSET      1       /* Interrupt Pending Register */
#define XIN_IER_OFFSET      2       /* Interrupt Enable Register */
#define XIN_IAR_OFFSET      3       /* Interrupt Acknowledge Register */
#define XIN_SIE_OFFSET      4       /* Set Interrupt Enable Register */
#define XIN_CIE_OFFSET      5       /* Clear Interrupt Enable Register */
#define XIN_IVR_OFFSET      6       /* Interrupt Vector Register */
#define XIN_MER_OFFSET      7       /* Master Enable Register */

#else /*(XPAR_XINTC_USE_DCR != 0)*/

#define XIN_ISR_OFFSET      0       /* Interrupt Status Register */
#define XIN_IPR_OFFSET      4       /* Interrupt Pending Register */
#define XIN_IER_OFFSET      8       /* Interrupt Enable Register */
#define XIN_IAR_OFFSET      12      /* Interrupt Acknowledge Register */
#define XIN_SIE_OFFSET      16      /* Set Interrupt Enable Register */
#define XIN_CIE_OFFSET      20      /* Clear Interrupt Enable Register */
#define XIN_IVR_OFFSET      24      /* Interrupt Vector Register */
#define XIN_MER_OFFSET      28      /* Master Enable Register */

#endif /*(XPAR_XINTC_USE_DCR != 0)*/

/* Bit definitions for the bits of the MER register */

#define XIN_INT_MASTER_ENABLE_MASK      0x1UL
#define XIN_INT_HARDWARE_ENABLE_MASK    0x2UL /* once set cannot be cleared */

/**************************** Type Definitions *******************************/

/* The following data type defines each entry in an interrupt vector table,
 * the callback reference is the base address of the interrupting device
 * for the low level driver and an instance pointer for the high level driver
 */
typedef struct
{
    XInterruptHandler Handler;
    void *CallBackRef;
} XIntc_VectorTableEntry;

/***************** Macros (Inline Functions) Definitions *********************/

/*
 * Define the appropriate I/O access method to memory mapped I/O or DCR.
 */
#if (XPAR_XINTC_USE_DCR != 0)

#define XIntc_In32  XIo_DcrIn
#define XIntc_Out32 XIo_DcrOut

#else

#define XIntc_In32  XIo_In32
#define XIntc_Out32 XIo_Out32

#endif

/*****************************************************************************
*
* Low-level driver macros.  The list below provides signatures to help the
* user use the macros.
*
* void XIntc_mMasterEnable(BaseAddress)
* void XIntc_mMasterDisable(BaseAddress)
*
* void XIntc_mEnableIntr(BaseAddress, EnableMask)
* void XIntc_mDisableIntr(BaseAddress, DisableMask)
* void XIntc_mAckIntr(BaseAddress, AckMask)
* Xuint32 XIntc_mGetIntrStatus(BaseAddress)
*
*****************************************************************************/

/****************************************************************************/
/**
*
* Enable all interrupts in the Master Enable register of the interrupt
* controller.  The interrupt controller defaults to all interrupts disabled
* from reset such that this macro must be used to enable interrupts.
*
* @param    BaseAddress is the base address of the device.
*
* @return   None.
*
*****************************************************************************/
#define XIntc_mMasterEnable(BaseAddress) \
    XIntc_Out32((BaseAddress) + XIN_MER_OFFSET, \
              XIN_INT_MASTER_ENABLE_MASK | XIN_INT_HARDWARE_ENABLE_MASK)

/****************************************************************************/
/**
*
* Disable all interrupts in the Master Enable register of the interrupt
* controller.
*
* @param    BaseAddress is the base address of the device.
*
* @return   None.
*
*****************************************************************************/
#define XIntc_mMasterDisable(BaseAddress) \
    XIntc_Out32((BaseAddress) + XIN_MER_OFFSET, 0)

/****************************************************************************/
/**
*
* Enable specific interrupt(s) in the interrupt controller.
*
* @param    BaseAddress is the base address of the device
* @param    EnableMask is the 32-bit value to write to the enable register.
*           Each bit of the mask corresponds to an interrupt input signal that
*           is connected to the interrupt controller (INT0 = LSB). Only the
*           bits which are set in the mask will enable interrupts.
*
* @return   None.
*
*****************************************************************************/
#define XIntc_mEnableIntr(BaseAddress, EnableMask) \
    XIntc_Out32((BaseAddress) + XIN_IER_OFFSET, (EnableMask))

/****************************************************************************/
/**
*
* Disable specific interrupt(s) in the interrupt controller.
*
* @param    BaseAddress is the base address of the device
* @param    DisableMask is the 32-bit value to write to the enable register.
*           Each bit of the mask corresponds to an interrupt input signal that
*           is connected to the interrupt controller (INT0 = LSB).  Only the
*           bits which are set in the mask will disable interrupts.
*
* @return   None.
*
*****************************************************************************/
#define XIntc_mDisableIntr(BaseAddress, DisableMask) \
    XIntc_Out32((BaseAddress) + XIN_IER_OFFSET, ~(DisableMask))

/****************************************************************************/
/**
*
* Acknowledge specific interrupt(s) in the interrupt controller.
*
* @param    BaseAddress is the base address of the device
* @param    AckMask is the 32-bit value to write to the acknowledge register.
*           Each bit of the mask corresponds to an interrupt input signal that
*           is connected to the interrupt controller (INT0 = LSB).  Only the
*           bits which are set in the mask will acknowledge interrupts.
*
* @return   None.
*
*****************************************************************************/
#define XIntc_mAckIntr(BaseAddress, AckMask) \
    XIntc_Out32((BaseAddress) + XIN_IAR_OFFSET, (AckMask))

/****************************************************************************/
/**
*
* Get the interrupt status from the interrupt controller which indicates
* which interrupts are active and enabled.
*
* @param    BaseAddress is the base address of the device
*
* @return   The 32-bit contents of the interrupt status register. Each bit
*           corresponds to an interrupt input signal that is connected to the
*           interrupt controller (INT0 = LSB). Bits which are set indicate an
*           active interrupt which is also enabled.
*
*****************************************************************************/
#define XIntc_mGetIntrStatus(BaseAddress) \
    (XIntc_In32((BaseAddress) + XIN_ISR_OFFSET) & \
     XIntc_In32((BaseAddress) + XIN_IER_OFFSET))

/************************** Function Prototypes ******************************/

void XIntc_DefaultHandler(void *Input);

void XIntc_LowLevelInterruptHandler(void);

/************************** Variable Definitions *****************************/

extern XIntc_VectorTableEntry XIntc_InterruptVectorTable[];

extern Xuint32 XIntc_AckBeforeService;

#endif            /* end of protection macro */

