/////////////////////////////////////////////////////////////////////////-*-C-*- 
//
// Copyright (c) 2002 Xilinx, Inc.  All rights reserved.
//
// Xilinx, Inc.
// XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A 
// COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
// ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR 
// STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION
// IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE 
// FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION.  
// XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO 
// THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO 
// ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE 
// FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY 
// AND FITNESS FOR A PARTICULAR PURPOSE.
// 
// File   : mb_interface.h
// Date   : 2002, March 20.
// Company: Xilinx
// Group  : Emerging Software Technologies
//
// Summary:
// Header file for mb_interface
//
// $Id: mb_interface.h,v 1.3 2003/01/30 01:35:45 satish Exp $
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _MICROBLAZE_INTERFACE_H_
#define _MICROBLAZE_INTERFACE_H_

extern void microblaze_enable_interrupts(void); // Enable Interrupts
extern void microblaze_disable_interrupts(void); // Disble Interrupts
extern void microblaze_enable_icache(void);  // Enable Instruction Cache
extern void microblaze_disable_icache(void); // Disable Instruction Cache


// FSL Access Macros
static volatile int rfsl0, rfsl1, rfsl2, rfsl3, rfsl4, rfsl5, rfsl6, rfsl7;

// Blocking Data Read and Write to FSL no. id
#define microblaze_bread_datafsl(val, id) asm("get %0, %1" : "=d" (##val##) : "m" (rfsl##id##))
#define microblaze_bwrite_datafsl(val, id) asm("put %1, %0" : "=m" (rfsl##id##) : "d" (##val##))

// Non-blocking Data Read and Write to FSL no. id
#define microblaze_nbread_datafsl(val, id) asm("nget %0, %1" : "=d" (##val##) : "m" (rfsl##id##))
#define microblaze_nbwrite_datafsl(val, id) asm("nput %1, %0" : "=m" (rfsl##id##) : "d" (##val##))

// Blocking Control Read and Write to FSL no. id
#define microblaze_bread_cntlfsl(val, id) asm("cget %0, %1" : "=d" (##val##) : "m" (rfsl##id##))
#define microblaze_bwrite_cntlfsl(val, id) asm("cput %1, %0" : "=m" (rfsl##id##) : "d" (##val##))

// Non-blocking Control Read and Write to FSL no. id
#define microblaze_nbread_cntlfsl(val, id) asm("ncget %0, %1" : "=d" (##val##) : "m" (rfsl##id##))
#define microblaze_nbwrite_cntlfsl(val, id) asm("ncput %1, %0" : "=m" (rfsl##id##) : "d" (##val##))


#endif // _MICROBLAZE_INTERFACE_H_
