library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;

--library UNISIM;
--use UNISIM.VComponents.all;

entity opb_xsb300_nortsam is
  generic (
    C_OPB_AWIDTH    : integer := 32;
    C_OPB_DWIDTH    : integer := 32;
    C_BASEADDR      : std_logic_vector(31 downto 0) := X"0FEF_0000";
    C_HIGHADDR      : std_logic_vector(31 downto 0) := X"0FEF_FFFF"
    );

    Port (
      OPB_Clk : in std_logic;
      OPB_Rst : in std_logic;
      OPB_ABus : in std_logic_vector (31 downto 0);
      OPB_BE : in std_logic_vector (3 downto 0);
      OPB_DBus : in std_logic_vector (31 downto 0);
      OPB_RNW : in std_logic;
      OPB_select : in std_logic;
      OPB_seqAddr : in std_logic;
      
      UIO_DBus : out std_logic_vector (31 downto 0);
      UIO_errAck : out std_logic;
      UIO_retry : out std_logic;
      UIO_toutSup : out std_logic;
      UIO_xferAck : out std_logic;
      Interrupt : out std_logic
      );
end opb_xsb300_nortsam;

architecture Behavioral of opb_xsb300_nortsam is

component nortsam_coprocessor
  port	(
    CLK : in std_logic;
    RST : in std_logic;
    done : out std_logic;
    interrupt : out std_logic;
    rdy : in std_logic;
    mode : in std_logic_vector(1 downto 0);
    rA, rB, rC, rD, rE, rF, rG, rH : in std_logic_vector(15 downto 0);
    resultA, resultB : out std_logic_vector(15 downto 0)
    );
end component;

signal cs,cs_1, xfer, xfer_1, xfer_2 : std_logic;

signal rnw : std_logic;
signal addr : std_logic_vector (15 downto 0); 	
signal wdata : std_logic_vector (31 downto 0);

signal rdata : std_logic_vector (31 downto 0);
signal opb_ad_ce : std_logic;

signal we : std_logic;

signal rA, rB, rC, rD, rE, rF, rG, rH : std_logic_vector(15 downto 0);
signal resA, resB : std_logic_vector(15 downto 0);
signal res_rdy : std_logic;
signal res_rdy_1 : std_logic := '0';
signal rdy : std_logic := '0';
signal mode : std_logic_vector(1 downto 0) := "00";
begin

process(OPB_Rst, OPB_Clk)
begin  
        
-- register adresses, data write, rnw
   if OPB_Rst = '1' then
          addr <=  X"0000";
          wdata <= X"0000_0000";
          rnw <= '0';
	elsif OPB_Clk'event and OPB_Clk ='1' then
          if opb_ad_ce = '1' then
			 	 wdata <= OPB_DBus;
				 addr <= OPB_ABus(15 downto 0);
                                 rnw <= OPB_RNW;
			 end if;
	end if;

-- register data read
   if OPB_Rst = '1' then
			rdata <= X"0000_0000";
	elsif OPB_Clk'event and OPB_Clk ='1' then
			 if res_rdy  = '1' then
                           rdata(31 downto 16) <= resA;
                           rdata(15 downto 0) <= resB;
                        end if;

	end if;

end process;

-- very important	
-- TO DO
-- when writing, the read data can corrupt the DBus
UIO_DBus <= rdata when (xfer or xfer_1 or xfer_2) = '1' and rnw = '1' else X"0000_0000";

cs <= OPB_Select when OPB_ABus(31 downto 16)=X"0FEF" else '0';

-- combinational logic for BRAM
we <= (xfer or xfer_1) and not rnw;


opb_ad_ce <= not xfer;

mode <= "01" when OPB_ABus(7 downto 0) = X"14" else "00" when OPB_ABus(7 downto 0) = X"08" or OPB_ABus(7 downto 0) = X"0C";

-- the 1st ff -- FDR
process(OPB_Clk)
begin
	if OPB_Clk'event and OPB_Clk ='1' then
        
          if (xfer or xfer_1) = '1' then xfer <='0';
                elsif OPB_RNW = '0' then
                  xfer <= cs;
                else
                  xfer <= res_rdy and cs;
                end if;

	end if;
end process;

process (OPB_Rst, OPB_Clk)
begin
	if OPB_Rst = '1' then
                 xfer_1 <= '0';
                 xfer_2 <= '0';
                 cs_1 <= '0';
        elsif OPB_Clk'event and OPB_Clk ='1' then
		 xfer_1 <= xfer;
		 xfer_2 <= xfer_1;
                 cs_1 <= cs;
        end if;
end process;

-- write to registers
process (OPB_Rst, OPB_Clk)
begin
  if OPB_Rst = '1' then
    rA <= "0000000000000000";
    rB <= "0000000000000000";
    rC <= "0000000000000000";
    rD <= "0000000000000000";
    rE <= "0000000000000000";
    rF <= "0000000000000000";
    rG <= "0000000000000000";
    rH <= "0000000000000000";
  elsif OPB_Clk'event and OPB_Clk='1' then
    if rdy = '1' then
      rdy <= '0';
    end if;
    if (xfer and we) = '1' then

      case addr(7 downto 0) is
        when X"08" =>
          -- FFT: writing Jr & Ji
          rA <= wdata(31 downto 16);
          rE <= wdata(31 downto 16);
          rC <= wdata(15 downto 0);
          rG <= wdata(15 downto 0);
         -- mode <= "00";
        when X"0C" =>
          -- FFT: writing Cr & Ci
          rB <= wdata(31 downto 16);
          rH <= wdata(31 downto 16);
          rD <= wdata(15 downto 0);
          rF <= wdata(15 downto 0);
          rdy <= '1';
        when X"14" =>
          rA <= wdata(31 downto 16);
          rB <= wdata(31 downto 16);
          rC <= wdata(15 downto 0);
          rD <= wdata(15 downto 0);
          rdy <= '1';
          -- mode <= "01";
        when others => null;
      end case;
    end if;
  end if;
end process;

--rdy <= all4 when mode = "00" else '1' when mode = "01" else '0';

-- tie unused to ground
UIO_errAck <= '0';
UIO_retry <= '0';
UIO_toutSup <= '0';
UIO_xferAck <= xfer;

-- the sound stuff
nortsam : nortsam_coprocessor port map(
	CLK => OPB_Clk,
        RST => OPB_Rst,
        mode => mode,
	interrupt => interrupt,
        rdy => rdy,
        rA => rA,
        rB => rB,
        rC => rC,
        rD => rD,
        rE => rE,
        rF => rF,
        rG => rG,
        rH => rH,

        resultA => resA,
        resultB => resB,
        done => res_rdy
);

end Behavioral;
