library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

--library UNISIM;
--use UNISIM.VComponents.all;


entity nortsam_coprocessor is
  port	(
    CLK : in std_logic;
    RST : in std_logic;
    
    interrupt : out std_logic;
    rdy : in std_logic;
    mode : in std_logic_vector(1 downto 0);
    rA, rB, rC, rD, rE, rF, rG, rH : in std_logic_vector(15 downto 0);
    resultA, resultB : out std_logic_vector(15 downto 0);
    
    done : out std_logic
    
    );
end nortsam_coprocessor;


architecture Behavioral of nortsam_coprocessor is
component fixed_16x16_multi is
 port (
    data    : in  std_logic_vector(15 downto 0);
    coeff   : in  std_logic_vector(15 downto 0);
    rdy     : out std_logic;
    product : out std_logic_vector(15 downto 0);
    clk     : in std_logic;
    rst     : in std_logic;
    mode    : in std_logic_vector(1 downto 0));
end component;


signal resA, resB, resC, resD : std_logic_vector(15 downto 0);
signal done1 :std_logic := '0';
signal done2 :std_logic := '0';
signal done3 :std_logic := '0';
signal done4 :std_logic := '0';
signal not_mag : std_logic;
signal reel, im : std_logic_vector(15 downto 0);
signal re_rdy : std_logic := '0';
signal im_rdy : std_logic := '0';
begin

mul1 : fixed_16x16_multi port map(
  clk => CLK,
  data => rA,
  coeff => rB,
  rdy => done1,
  product => resA,
  rst => rdy,
  mode => mode
  );
  
mul2 : fixed_16x16_multi port map(
  clk => CLK,
  data => rC,
  coeff => rD,
  rdy => done2,
  product => resB,
  rst => rdy,
  mode => mode
  );

  
mul3 : fixed_16x16_multi port map(
  clk => CLK,
  data => rE,
  coeff => rF,
  rdy => done3,
  product => resC,
  rst => not_mag,
  mode => mode
  );

mul4 : fixed_16x16_multi port map(
  clk => CLK,
  data => rG,
  coeff => rH,
  rdy => done4,
  product => resD,
  rst => not_mag,
  mode => mode
  );
  

  
-- generate the 3 clocks: master, serial, frame

 process(CLK, RST)
 begin
   if clk'event and clk='1' then
     if rdy = '1' then 
       im_rdy <= '0';
       re_rdy <= '0';
     else
       if (done1 and done2) = '1' and mode = "00" then
         reel <= resA - resB;
         re_rdy <= '1';
       elsif (done1 = '1' and mode ="01") then
         reel <= resA;
         re_rdy <= '1';
       end if;
       if (done3 and done4) = '1' and mode = "00" then
         im <= resC + resD;
         im_rdy <= '1';
       elsif (done2='1' and mode ="01") then
         im <= resB;
         im_rdy <= '1';
       end if;
     end if;
   end if;
 end process;

not_mag <= rdy when mode = "00" else '0';

interrupt <= '0';

resultA <= reel;
resultB <= im;

done <= im_rdy and re_rdy;

end Behavioral;


