-------------------------------------------------------------------------------
-- Fixed Point Multiplier
--
-- 16 bit data contains 9 bits to left of decimal and 7 to the right
-- 16 bit coeff contains all 16 bits to right of decimal
-- output has fixed point same as data
--
-- Josh Mackler
--
-------------------------------------------------------------------------------



library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity fixed_16x16_multi is
  port (
    data    : in  std_logic_vector(15 downto 0);
    coeff   : in  std_logic_vector(15 downto 0);
    rdy     : out std_logic;
    product : out std_logic_vector(15 downto 0);
    clk     : in std_logic;
    rst     : in std_logic;
    mode    : in std_logic_vector(1 downto 0));

end fixed_16x16_multi;

architecture archy of fixed_16x16_multi is

  signal tmp : std_logic_vector(15 downto 0);  -- shift amt of data
  signal multip : std_logic_vector(15 downto 0) := X"0000";
  signal inter1 : std_logic_vector(15 downto 0);
  signal inter2 : std_logic_vector(15 downto 0);
  signal inter3 : std_logic_vector(15 downto 0);
  signal inter4 : std_logic_vector(15 downto 0);       
  signal inter5 : std_logic_vector(15 downto 0);
  signal inter6 : std_logic_vector(15 downto 0);
  signal inter7 : std_logic_vector(15 downto 0);
  signal inter8 : std_logic_vector(15 downto 0);
  signal inter9 : std_logic_vector(15 downto 0);
  signal inter10 : std_logic_vector(15 downto 0);
  signal inter11 : std_logic_vector(15 downto 0);
  signal inter12 : std_logic_vector(15 downto 0);
  signal inter13 : std_logic_vector(15 downto 0);
  signal inter14 : std_logic_vector(15 downto 0);
  signal inter15 : std_logic_vector(15 downto 0);
  signal second1, second2, second3, second4, second5 : std_logic_vector(15 downto 0);
  signal res1 : std_logic_vector(15 downto 0);
  signal res2 : std_logic_vector(15 downto 0);
  signal res3 : std_logic_vector(15 downto 0);
  signal res4 : std_logic_vector(15 downto 0);       
  signal res5 : std_logic_vector(15 downto 0);
  signal res6 : std_logic_vector(15 downto 0);
  signal res7 : std_logic_vector(15 downto 0);
  signal twos_coeff : std_logic_vector(15 downto 0);
 -- signal fm_count : std_logic_vector(0 to 3) := "0000";
  signal mul_pipe : std_logic_vector(1 downto 0);
  signal negative : std_logic := '0';
  signal neg1 : std_logic := '0';
  signal neg2 : std_logic := '0';
  signal go : std_logic := '0';
  signal tmp2 : std_logic_vector(15 downto 0);
  signal ready : std_logic := '0';
begin  -- archy


   inter1 <= '0' & tmp(15 downto 1) when twos_coeff(14)='1' and mode="00" else
             "0000000" & tmp(15 downto 7) when twos_coeff(7)='1' and mode="01" else X"0000";

   inter2 <= "00" & tmp(15 downto 2) when twos_coeff(13)='1' and mode="00" else
              "000000" & tmp(15 downto 7) & '0' when twos_coeff(8)='1'
             and mode = "01" else X"0000";
  
   inter3 <= "000" & tmp(15 downto 3) when twos_coeff(12)='1' and mode="00" else
              "00000" & tmp(15 downto 7) & "00" when twos_coeff(9)='1'
             and mode = "01" else X"0000";
  
   inter4 <= "0000" &  tmp(15 downto 4) when twos_coeff(11)='1' and mode="00" else
              "0000" & tmp(15 downto 7) & "000" when twos_coeff(10)='1' and mode="01"
             else X"0000";
  
   inter5 <=  "00000" & tmp(15 downto 5) when twos_coeff(10)='1' and mode="00" else
               "000" & tmp(15 downto 7) & "0000" when twos_coeff(11)='1' and mode="01"
              else X"0000";
  
   inter6 <=  "000000" & tmp(15 downto 6) when twos_coeff(9)='1' and mode="00" else
              "00" & tmp(15 downto 7) & "00000" when twos_coeff(12)='1' and mode="01"
              else X"0000";
  
   inter7 <=  "0000000" & tmp(15 downto 7) when twos_coeff(8)='1' and mode="00" else
               "0" & tmp(15 downto 7) & "000000" when twos_coeff(13)='1' and mode="01"
              else X"0000";
  
  inter8 <=  "00000000" & tmp(15 downto 8) when twos_coeff(7)='1' and mode="00" else
              tmp(15 downto 7) & "0000000" when twos_coeff(14)='1' and mode="01"
             else X"0000";
   inter9 <=  "000000000" & tmp(15 downto 9) when twos_coeff(6)='1' and mode="00" else X"0000";
   inter10 <=  "0000000000" & tmp(15 downto 10) when twos_coeff(5)='1' and mode="00" else X"0000";
   inter11 <=  "00000000000" & tmp(15 downto 11) when twos_coeff(4)='1' and mode="00" else X"0000";
   inter12 <=  "000000000000" & tmp(15 downto 12) when twos_coeff(3)='1' and mode="00" else X"0000";
   inter13 <=  "0000000000000" & tmp(15 downto 13) when twos_coeff(2)='1' and mode="00" else X"0000";
   inter14 <=  "00000000000000" & tmp(15 downto 14) when twos_coeff(1)='1' and mode="00" else X"0000";
   inter15 <=  "000000000000000" & tmp(15) when twos_coeff(0)='1' and mode="00" else X"0000";
   
  process (clk, rst)
  begin  -- process
    if clk'event and clk='1' then
      if rst = '1' then
        if data(15) = '1' then
          tmp <= not(data) + 1;
          neg1 <= '1';
        else tmp <= data;
             neg1 <= '0';
        end if;
        if coeff(15) = '1' then
          neg2 <= '1';
          twos_coeff <= not(coeff) + 1;
        else
          twos_coeff <= coeff;
          neg2 <= '0';
        end if;
        multip <= X"0000";
        mul_pipe <= "00";
        ready <= '0';
        go <= '1';      
      else
        if go = '1' then
          if mul_pipe = "00" then
            res1 <= inter1 + inter2;
            res2 <= inter3 + inter4;
            res3 <= inter5 + inter6;
            res4 <= inter7 + inter8;
           
           res5 <= inter9 + inter10;
            res6 <= inter11 + inter12;
            res7 <= inter13 + inter14;
            mul_pipe <= "01";
          elsif mul_pipe = "01" then       -- second clock
            second1 <= res1 + res2 + res3 + res4;
            second2 <= res5 + res6 + res7 + inter15;
            mul_pipe <= "11";
          elsif mul_pipe = "11" then       -- third clock
              if negative = '1' then product <= not(second1 + second2) + 1;
            else
              product <= second1 + second2;
            end if;
            go <= '0';
              ready <= '1';
          end if;
        end if;               


      end if;
    end if;   
  end process;

   rdy <= ready;
   negative <= neg1 xor neg2;
end archy;







