/***  FFT size is defined by the following preprocessor defines/includes:
 *  main.c: 
 *     #define FFT_SIZE
 *     #define BUFFER_SHIFT_OFFSET [=log2(FFT_SIZE)]
 *  isr.c:  
 *     #define FFT_SIZE
 *  fft.c:  
 *     #define FFT_SIZE
 *     #include "coeff(FFT_SIZE).c"
 *     Xuint16 nonswaps[] - must correspond to correct fft size
 *  graphics.c:
 *     Xuint16 correspond[] - must to bin correlations for correct fft size  
 ***/

#include "xbasic_types.h"
#include "xio.h"

#include "xintc_l.h"
#include "xuartlite_l.h"


#define W 640
#define H 480
#define VGA_START 0x00800000
#define AUDIO_START 0xFEFE0000
#define RED 0xE0
#define GREEN 0x1C
#define BLUE 0x03

#define FFT_SIZE 2048
#define BUFFER_SHIFT_OFFSET 11  // must =log2(FFT_SIZE), used for double buffer

// defined in isr.c
extern void audio_intr_handler(void *callback);
extern volatile Xuint16 bufInUse[];
extern volatile Xuint16 bufReady[];
//extern Xuint32 droppedPackets, grabbedPackets, midFrameDrops;

Xuint32 audioBuffer[ FFT_SIZE*2 ];
Xuint32 audioBufferRIGHT[ FFT_SIZE ];
Xint16 *startLPtr, *startRPtr;

/*
 * setup_interrupts: Initialize the interrupt sources and handlers
 */
void setup_interrupts()
{
  /*
   * Reset the interrupt controller peripheral
   */

  /* Disable the interrupt signal */
  XIntc_mMasterDisable(XPAR_INTC_SINGLE_BASEADDR);
  /* Disable all interrupt sources */
  XIntc_mEnableIntr(XPAR_INTC_SINGLE_BASEADDR,0);
  /* Acknowledge all possible interrupt sources
     to make sure none are pending */
  XIntc_mAckIntr(XPAR_INTC_SINGLE_BASEADDR, 0xffffffff);

  /*
   * Install the codec interrupt handler
   */
  XIntc_InterruptVectorTable[XPAR_INTC_AK4565_INTERRUPT_INTR].Handler =
    audio_intr_handler;

  // enable interrupt sources
  /* Enable CPU interrupts */
  microblaze_enable_interrupts();
  /* Enable interrupts from the interrupt controller */
  XIntc_mMasterEnable(XPAR_INTC_SINGLE_BASEADDR);
  /* Tell the interrupt controller to accept interrupts from the codec */
  XIntc_mEnableIntr(XPAR_INTC_SINGLE_BASEADDR, XPAR_AK4565_INTERRUPT_MASK);
}



int main()
{
  Xuint16 i, j, k, z;
  Xint32 x;

  print("[number one realtime spectrum analyzer max].\n\r");

  // Enable the instruction cache: makes the code run 6 times faster
  microblaze_enable_icache();

  setup_interrupts();

  //  clear screen
  for(x=0 ; x<H*W ; x++)
    XIo_Out8(VGA_START + x, 0);

  // this never changes, define outside loop.  
  startRPtr = (Xint16*)(audioBufferRIGHT) - 1;

  i=0;
  for ( ;; ) {
    // *******************************
    // double buffer logistics
    while (bufReady[i] == 0) 
      print("."); // need this delay, a busy-wait loop prevents isr context switch?!
    bufInUse[(i+1) % 2] = 0;
    bufInUse[i] = 1;
    // *******************************


    // fudge starting pointers to account for FFT starting
    //  with index 1.
    startLPtr = (Xint16*)(&(audioBuffer[ (i<<BUFFER_SHIFT_OFFSET) ])) - 1;

    bitReverseAndLRSeparate( startLPtr, startRPtr );
    // after this point:
    //   audioBuffer[] holds bit-rearranged LEFT samples, MSB=real/LSB=imag
    //   audioBufferRIGHT[] holds bit-rearranged RIGHT samples, MSB=real/LSB=imag

    doFFT( startLPtr );
    doFFT( startRPtr );

    visualize( &(audioBuffer[ (i<<BUFFER_SHIFT_OFFSET) ]), 0 );
    visualize( audioBufferRIGHT, 1 );

    if (i==0) i++;
    else
      i=0;
  }

  return 0;
}
