#include "xbasic_types.h"
#include "xio.h"
#include "xparameters.h"
#include "xuartlite_l.h"

extern Xuint32 audioBuffer[];
extern Xuint32 audioBufferRIGHT[];
Xint32 bufPos = 0;
Xuint16 volatile bufInUse[] = {0, 0};
Xuint16 volatile bufReady[] = {0, 0};

// define: packet = set of 64 samples; frame= set of FFT_SIZE samples

/*
Xuint32 droppedPackets=0;
Xuint32 grabbedPackets=0;
Xuint32 midFrameDrops=0;
*/

#define FFT_SIZE 2048

/*
 * Interrupt service routine for the AK4565 CODEC
 */

void audio_intr_handler( void *callback ) {
  Xint16 i;

  // if the FFT isn't done yet, drop these samples.
  if (bufPos < FFT_SIZE) {
    if (bufInUse[0] == 1) {
      /*
      droppedPackets++;
      if (bufPos != 0)
	midFrameDrops++;
      */
      return;
    }
  }
  else if (bufInUse[1] == 1) {

    //    droppedPackets++;
    if (bufPos != FFT_SIZE)
      //      midFrameDrops++;
    return;
  }

  for (i=0; i < 64; i++) {
    XIo_Out32( XPAR_AK4565_BASEADDR + (i<<2), 0 );
    audioBuffer[bufPos++] = (XIo_In32( XPAR_AK4565_BASEADDR )); // 0xLLLLRRRR
  }

  if (bufPos == FFT_SIZE) {
    bufReady[0] = 1;
    bufReady[1] = 0;
  }
  else if (bufPos >= (FFT_SIZE * 2)) { // multiply here OK -- should optimize to constant value
    bufReady[1] = 1;
    bufReady[0] = 0;
    bufPos = 0;
  }

  //  grabbedPackets++;
}
