#include "xbasic_types.h"
#include "xio.h"

#include "xintc_l.h"
#include "xuartlite_l.h"

#define W 640
#define H 480
#define VGA_START 0x00800000
#define X_START 40
#define Y_START 240

#define RED 0xE0
#define GREEN 0x1C
#define BLUE 0x03
#define WHITE RED | GREEN | BLUE
#define BLACK 0x00

#define MAX_PIX 200

#define TRUE 1
#define FALSE 0

/********************************************************************/
//correspond2048:

/*  [0]   [1]   [2]   [3]   [4]   [5]   [6]   [7]   [8]   [9]*/

Xuint16 correspond[] = {
     0,    1,    2,    3,    4,    5,    6,    7,    8,    9, 
    10,   11,   13,   16,   20,   25,   31,   39,   49,   61, 
    77,   97,  122,  153,  194,  244,  306,  387,  487,  612, 
   773,  973};
/********************************************************************/


static Xuint16 logScale[] = { 
 0, 1, 4, 9, 16, 25, 36, 49, 64, 81, 100, 121, 144, 169, 196, 225, 256, 289, 324, 361, 400, 441, 484, 529, 576, 625, 676, 729, 784, 841, 900, 961, 1024, 1089, 1156, 1225, 1296, 1369, 1444, 1521, 1600, 1681, 1764, 1849, 1936, 2025, 2116, 2209, 2304, 2401, 2500, 2601, 2704, 2809, 2916, 3025, 3136, 3249, 3364, 3481, 3600, 3721, 3844, 3969, 4096, 4225, 4356, 4489, 4624, 4761, 4900, 5041, 5184, 5329, 5476, 5625, 5776, 5929, 6084, 6241, 6400, 6561, 6724, 6889, 7056, 7225, 7396, 7569, 7744, 7921, 8100, 8281, 8464, 8649, 8836, 9025, 9216, 9409, 9604, 9801, 10000, 10201, 10404, 10609, 10816, 11025, 11236, 11449, 11664, 11881, 12100, 12321, 12544, 12769, 12996, 13225, 13456, 13689, 13924, 14161, 14400, 14641, 14884, 15129, 15376, 15625, 15876, 16129, 16384, 16641, 16900, 17161, 17424, 17689, 17956, 18225, 18496, 18769, 19044, 19321, 19600, 19881, 20164, 20449, 20736, 21025, 21316, 21609, 21904, 22201, 22500, 22801, 23104, 23409, 23716, 24025, 24336, 24649, 24964, 25281, 25600, 25921, 26244, 26569, 26896, 27225, 27556, 27889, 28224, 28561, 28900, 29241, 29584, 29929, 30276, 30625, 30976, 31329, 31684, 32041, 32400, 32761  };

Xuint16 history[] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

Xuint16 barHistory[] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

/* Method for drawing the Magnitude bar for each frequency band */
void drawBar(Xuint16 bin, int mag,  unsigned char direction) {
  Xuint32 vgaMem;
  Xint32 i;
  Xuint16 color= 0xffff, middle=0x49;
  Xint32 offset =0;
  unsigned char higher=0;
  unsigned int fourPixel = 0; //0xFF; //f0ffff;

  if (direction ==1)
    offset =30+bin;
  else 
    offset = bin;
  
  /* Zero Out Noise */
  if (mag < 15) mag = 0;
  
  /* Update History if mag is higher */
  if(((history[offset]-6) < mag)) {
    //history[direction][bin] = 
    barHistory[((offset))] = mag;
    history[(offset)] = mag;
    higher =1;
  } else {
    if((history[(offset)]) >6)
      history[(offset)]-= 6;  // comment this line and uncomment next line
    //history[offset] = mag;  //    to disable slowed decay of bars
    else 
      history[(offset)] =0;
    mag = history[(offset)];
  }
  
  /* draw black above color so screen refreshes */
  for (i=mag; i < MAX_PIX; i++) {
    if (direction) 
      vgaMem = VGA_START + bin*16 + X_START + (Y_START - i-2)*640;   
    else 
      vgaMem = VGA_START + bin*16 + X_START + (Y_START + i+2)*640;   
    
    XIo_Out32(vgaMem, 0x0);
    XIo_Out32(vgaMem+4, 0x0);      
  }
  
  /* Print Middle Spacer Bar */
  for(i=0; i < 32; i++){
    
    fourPixel = (middle<<24); 
    fourPixel = fourPixel | (middle<<16);
    fourPixel = fourPixel | (middle<<8); 
    fourPixel = fourPixel | middle; 
        
    /* Draw 3 pixel thick bar to separate Left and Right Results */  
    vgaMem = VGA_START + (bin<<4) + X_START + (Y_START -1)*640 + i;   
    XIo_Out32(vgaMem, fourPixel);
    XIo_Out32(vgaMem+4, fourPixel);    

    vgaMem = VGA_START + (bin<<4) + X_START + (Y_START)*640 + i;   
    XIo_Out32(vgaMem, fourPixel);
    XIo_Out32(vgaMem+4, fourPixel);    

    vgaMem = VGA_START + (bin<<4) + X_START + (Y_START+1)*640 + i;   
    XIo_Out32(vgaMem, fourPixel);
    XIo_Out32(vgaMem+4, fourPixel);    
  }
  
  // If the Bar is Magnitude is smaller than History //
    if ( (higher==0) && (mag-6) > 0 ) {
      
      for (i=0 ; i < (mag-6); i++) {
	
	if (direction) 
	  vgaMem = VGA_START + (bin<<4) + X_START + (Y_START - i - 2)*640;   
	else 
	  vgaMem = VGA_START + (bin<<4) + X_START + (Y_START + i + 2)*640;   
	
	// If higher than 160, print RED //
	if(i > 160) { 
	  color = 224;
	}
	else { // ELSE, get color based on Magnitude //
	  
	  if((i&0x000000FF) == 4)
	    color = 252;
	  else if ((i&0x001f) == 16) 
	    color-=4;
	}
	
	// Set Color and Print Bar //
	fourPixel = (color<<24); 
	fourPixel = fourPixel | (color<<16);
	fourPixel = fourPixel | (color<<8); 
	fourPixel = fourPixel | color; 
	XIo_Out32(vgaMem, fourPixel);
	XIo_Out32(vgaMem+4, fourPixel);      
      }
      
    } else  if (higher == 1) {
      
      for (i=0; i < mag; i++) {
	
	if (direction) 
	  vgaMem = VGA_START + (bin<<4) + X_START + (Y_START - i - 2)*640;   
	else 
	  vgaMem = VGA_START + (bin<<4) + X_START + (Y_START + i + 2)*640;   
	/* If higher than 160, print RED */
	if(i > 160) { 
	  color = 224;
	}
	else { /* ELSE, get color based on Magnitude */
	  if((i&0x000000FF) == 4)
	    color = 252;
	  else if ((i&0x001f) == 16) 
	    color-=4;
	}
	
	/* Set Color and Print Bar */
	fourPixel = (color<<24); 
	fourPixel = fourPixel | (color<<16);
	fourPixel = fourPixel | (color<<8); 
	fourPixel = fourPixel | color; 
	XIo_Out32(vgaMem, fourPixel);
	XIo_Out32(vgaMem+4, fourPixel);      
      }
    }
    
    mag = barHistory[(offset)];
    
    if ( (mag > 3 ) && (higher ==0) ){ 
      mag -= 3;
      barHistory[(offset)] = mag;
      
      if ( direction ==0 )
	vgaMem = VGA_START + (bin<<4) + X_START + (Y_START + mag )*640; 
      else 
	vgaMem = VGA_START + (bin<<4) + X_START + (Y_START - mag )*640;    
      
      fourPixel = (middle<<24); 
      fourPixel = fourPixel | (middle<<16);
      fourPixel = fourPixel | (middle<<8); 
      fourPixel = fourPixel | middle; 
      
      XIo_Out32(vgaMem, fourPixel);
      XIo_Out32(vgaMem+4, fourPixel);
      }
}

Xuint16 calcMagnitude( Xuint32 data ) {
  Xint16 *tempRI;
  Xuint32 result;
  short high = 182, low = 0, middle;
  unsigned char less = 0;
  short temp;

  // calculate magnitudes of buckets corresponding to positive frequencies
  // hw address 0x0fef_0014 squares real and imag.
  
  XIo_Out32( 0x0FEF0014, data );
  result = XIo_In32( 0x0FEF0000 );
  
  tempRI = (Xuint16*)(&result);
  result = (Xuint32)(tempRI[0]) + (Xuint32)(tempRI[1]);

  // saturate, don't overflow
  if (result > 32767)
    result = 32750;

  while( low <= high )
    {
      middle = ( low  + high ) / 2;
      if( result == logScale[  middle ] ) //match
	return middle;
      else if( result < logScale[ middle ] ) {
	high = middle - 1;     //search low end of array
	less =1;
      }
      else {
	low = middle + 1;      //search high end of array
	less = 0;
      }
    }
  if(less == 0) {
    if (middle > 180)
      return 180;
    else
      return middle;
  }
  else
    return middle-1;
}


void visualize( const Xuint32* fftData, const unsigned char direction ) {
  Xint32 i;
  Xint32 currBin, endBin;
  Xuint16 secondHighest;
  Xuint16 tempo;
  Xuint16 binMagnitude;

  // figure out which bin magnitudes pair up with which bands

  /*[0]   [1]   [2]   [3]   [4]   [5]   [6]   [7]   [8]   [9]
     0,  0/1,    1,  1/2,    2,  2/3,    3,    4,    5,    7, 
     8,   10,   13,   16,   20,   25,   31,   39,   49,   61, 
    77,   97,  122,  153,  194,  244,  306,  387,  487,  612, 
   773, [973] */

  // fill upper bands (bin resolution >= 1) with peak from range
  for (i=0; i<31; i++) {
    binMagnitude = 0;
    secondHighest = 0;
    endBin = correspond[i+1];
    
    for (currBin = correspond[i]; currBin < endBin; currBin++) {
      tempo = calcMagnitude( fftData[currBin] );
      if (tempo > secondHighest) {
	if (tempo >= binMagnitude) {
	  secondHighest = binMagnitude;
	  binMagnitude = tempo;
	}
	else {
	  secondHighest = tempo;
	}
      }
    }

    if (i < 15)
      drawBar(i, binMagnitude, direction);
    else
      drawBar(i, secondHighest, direction);
  }

}
