import java.io.PrintWriter;

/**
 * The wrapper class for unsigned variables 
 *
 * @author Hanhua Feng - hf2048@columbia.edu
 * @version $Id: MxVariable.java,v 1.3 2003/05/12 23:44:34 hanhua Exp $
 */
class MxVariable extends MxDataType {
    public MxVariable( String name ) {
        super( name );
    }

    public String typename() {
        return "undefined-variable";
    }

    public MxDataType copy() {
        throw new MxException( "Variable " + name + " has not been defined" );
    }

    public void print( PrintWriter w ) {
        w.println( name + " = <undefined>" );
    }
}

