import java.io.PrintWriter;

/**
 * The base data type class (also a meta class)
 *
 * Error messages are generated here.
 *
 * @author Hanhua Feng - hf2048@columbia.edu
 * @version $Id: MxDataType.java,v 1.17 2003/05/12 23:44:34 hanhua Exp $
 */
public class MxDataType 
{
    String name;   // used in hash table

    public MxDataType() {
        name = null;
    }

    public MxDataType( String name ) {
        this.name = name;
    }

    public String typename() {
        return "unknown";
    }

    public MxDataType copy() {
        return new MxDataType();
    }

    public void setName( String name ) {
        this.name = name;
    }

    public MxDataType error( String msg ) {
        throw new MxException( "illegal operation: " + msg 
                               + "( <" + typename() + "> "
                               + ( name != null ? name : "<?>" )
                               + " )" );
    }

    public MxDataType error( MxDataType b, String msg ) {
        if ( null == b )
            return error( msg );
        throw new MxException( 
            "illegal operation: " + msg
            + "( <" + typename() + "> "
            + ( name != null ? name : "<?>" )
            + " and " 
            + "<" + typename() + "> "
            + ( name != null ? name : "<?>" )
            + " )" );
    }

    public void print( PrintWriter w ) {
        if ( name != null )
            w.print( name + " = " );
        w.println( "<undefined>" );
    }

    public void print() {
        print( new PrintWriter( System.out, true ) );
    }

    public void what( PrintWriter w ) {
        w.print( "<" + typename() + ">  " );
        print( w );
    }

    public void what() {
        what( new PrintWriter( System.out, true ) );
    }

    public MxDataType assign( MxDataType b ) { 
        return error( b, "=" ); 
    }

    public MxDataType transpose() {
        return error( "\'" );
    }

    public MxDataType uminus() { 
        return error( "-" ); 
    }

    public MxDataType plus( MxDataType b ) { 
        return error( b, "+" ); 
    }

    public MxDataType add( MxDataType b ) { 
        return error( b, "+=" ); 
    }

    public MxDataType minus( MxDataType b ) { 
        return error( b, "-" ); 
    }
    
    public MxDataType sub( MxDataType b ) { 
        return error( b, "-=" ); 
    }

    public MxDataType times( MxDataType b ) { 
        return error( b, "*" ); 
    }

    public MxDataType mul( MxDataType b ) { 
        return error( b, "*=" ); 
    }

    public MxDataType lfracts( MxDataType b ) { 
        return error( b, "/" ); 
    }

    public MxDataType rfracts( MxDataType b ) { 
        return error( b, "/\'" ); 
    }

    public MxDataType ldiv( MxDataType b ) { 
        return error( b, "/=" ); 
    }

    public MxDataType rdiv( MxDataType b ) { 
        return error( b, "/\'=" ); 
    }

    public MxDataType modulus( MxDataType b ) {
        return error( b, "%" );
    }

    public MxDataType rem( MxDataType b ) {
        return error( b, "%=" );
    }

    public MxDataType gt( MxDataType b ) { 
        return error( b, ">" ); 
    }

    public MxDataType ge( MxDataType b ) { 
        return error( b, ">=" ); 
    }

    public MxDataType lt( MxDataType b ) { 
        return error( b, "<" ); 
    }

    public MxDataType le( MxDataType b ) { 
        return error( b, "<=" ); 
    }

    public MxDataType eq( MxDataType b ) { 
        return error( b, "==" ); 
    }

    public MxDataType ne( MxDataType b ) { 
        return error( b, "!=" ); 
    }

    public MxDataType and( MxDataType b ) { 
        return error( b, "and" ); 
    }
    
    public MxDataType or( MxDataType b ) { 
        return error( b, "or" ); 
    }

    public MxDataType not() { 
        return error( "not" ); 
    }
}
