import java.io.PrintWriter;

/**
 * the wrapper class for boolean
 *
 *
 * @author Hanhua Feng - hf2048@columbia.edu
 * @version $Id: MxBool.java,v 1.9 2003/05/12 23:44:34 hanhua Exp $
 */
class MxBool extends MxDataType {
    boolean var;

    MxBool( boolean var ) {
        this.var = var;
    }

    public String typename() {
        return "bool";
    }

    public MxDataType copy() {
        return new MxBool( var );
    }

    public void print( PrintWriter w ) {
        if ( name != null )
            w.print( name + " = " );
        w.println( var ? "true" : "false" );
    }


    public MxDataType and( MxDataType b ) {
        if ( b instanceof MxBool )
            return new MxBool( var && ((MxBool)b).var );
        return error( b, "and" );
    }

    public MxDataType or( MxDataType b ) {
        if ( b instanceof MxBool )
            return new MxBool( var || ((MxBool)b).var );
        return error( b, "or" );
    }

    public MxDataType not() {
        return new MxBool( !var );
    }

    public MxDataType eq( MxDataType b ) {
        // not exclusive or
        if ( b instanceof MxBool )
            return new MxBool( ( var && ((MxBool)b).var ) 
                               || ( !var && !((MxBool)b).var ) );
        return error( b, "==" );
    }

    public MxDataType ne( MxDataType b ) {
        // exclusive or
        if ( b instanceof MxBool )
            return new MxBool( ( var && !((MxBool)b).var ) 
                               || ( !var && ((MxBool)b).var ) );
        return error( b, "!=" );
    }
}
