#include "usbmidi.h"

#include <stdio.h>
#include <stdlib.h> 

/* References on libusb 1.0 and the USB HID/keyboard protocol
 *
 * http://libusb.org
 * https://web.archive.org/web/20210302095553/https://www.dreamincode.net/forums/topic/148707-introduction-to-using-libusb-10/
 *
 * https://www.usb.org/sites/default/files/documents/hid1_11.pdf
 *
 * https://usb.org/sites/default/files/hut1_5.pdf
 */

/*
 * Find and return a USB keyboard device or NULL if not found
 * The argument con
 * 
 */
struct libusb_device_handle *openmidi(uint8_t *endpoint_address) {
  libusb_device **devs;
  struct libusb_device_handle *midi = NULL;
  struct libusb_device_descriptor desc;
  ssize_t num_devs, d;
  uint8_t i, k;
  
  /* Start the library */
  if ( libusb_init(NULL) < 0 ) {
    fprintf(stderr, "Error: libusb_init failed\n");
    exit(1);
  }

  /* Enumerate all the attached USB devices */
  if ( (num_devs = libusb_get_device_list(NULL, &devs)) < 0 ) {
    fprintf(stderr, "Error: libusb_get_device_list failed\n");
    exit(1);
  }

  /* Look at each device, remembering the first HID device that speaks
     the keyboard protocol */

  for (d = 0 ; d < num_devs ; d++) {
    libusb_device *dev = devs[d];
    if ( libusb_get_device_descriptor(dev, &desc) < 0 ) {
      fprintf(stderr, "Error: libusb_get_device_descriptor failed\n");
      exit(1);
    }
	
    printf("Device speed %d \n", libusb_get_device_speed(dev));

    if (desc.bDeviceClass == 0){ // &&  desc.bDeviceSubClass == 0x03 &&  desc.bDeviceProtocol == 0x00 ) {

	

      struct libusb_config_descriptor *config;
     
      libusb_get_config_descriptor(dev, 0, &config);
      for (i = 0 ; i < config->bNumInterfaces ; i++){
	printf("Device no. %d, interface no. %d \n", d, i);


	for ( k = 0 ; k < config->interface[i].num_altsetting ; k++ ) {
	
	    const struct libusb_interface_descriptor *inter =
	    config->interface[i].altsetting + k ;
	
	    if ( inter->bInterfaceClass == 1 &&
	       inter->bInterfaceProtocol == 0 && 
		inter->bInterfaceSubClass == 3) {
	    int r;
		printf("selected interface = %d \n", i);
	  
	    if ((r = libusb_open(dev, &midi)) != 0) {
	      fprintf(stderr, "Error: libusb_open failed: %d\n", r);
	      exit(1);
	    }

	    if (libusb_kernel_driver_active(midi,i))
	      libusb_detach_kernel_driver(midi, i);
	   
	    libusb_set_auto_detach_kernel_driver(midi, i);
	   
	    if ((r = libusb_claim_interface(midi, i)) != 0) {
	      fprintf(stderr, "Error: libusb_claim_interface failed: %d\n", r);
	      exit(1);
	   
	    }
	    printf("bmAttributes, %d \n ",inter->endpoint[1].bmAttributes);
	    
	    *endpoint_address = inter->endpoint[1].bEndpointAddress;
	    goto found;
	  }
	}
	}	
    }
  }

 found:
  libusb_free_device_list(devs, 1);

  return midi;
}
