#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <stddef.h>
#include <math.h>
#include "usbmidi.h"
#include "user_interface.h"
#include "wav_handler.h"
#include "audio_driver.h"

int audio_driver_fd;
int user_interface_fd;
int MIN_KEY_CODE = 18;
int MAX_KEYCODE = 60;
struct libusb_device_handle *midi;
uint8_t endpoint_address;

void read_props(user_interface_props_t *props)
{
  user_interface_arg_t vla;

  if (ioctl(user_interface_fd, USER_INTERFACE_READ_PROPS, props)) {
        perror("ioctl(USER_INTERFACE_READ_PROPS) failed");
        return;
  }

// props->props.bpm = vla.props.bpm;
// props->props.step = vla.props.step;
// props->props.track = vla.props.track;
// props->props.playback = vla.props.playback;
}


typedef struct NoteInfo {
        int noteVal;
        int octave;
        int noteIndex;
} NoteInfo;



NoteInfo mapCodeToNote(int num) {
   NoteInfo result;
   if(num != 0){
       num = num-6; //bias
       int note[12] = {1,2,3,4,5,6,7,8,9,10,11,12};
       int index = (num - MIN_KEY_CODE) % 12;
       int octave = (num - MIN_KEY_CODE) / 12;
       int noteVal = note[index] +( octave * 12);

       result.noteVal = index;
       result.octave = octave;
       result.noteIndex = noteVal;


       }
   else{
        result.noteVal = 0;
        result.octave = 0;
        result.noteIndex = 0;
     }
   return result;
 };



// #playback mode or live mode: 1 bit (live 0 , playbak 1)
// #active channels: 4 bits (channel 3  on/off, channel 2 on/off, channel 1  on/off, channel 0 on/off)
// shift: 4 bits #0 -11 
// velocty: 3 bits
// channel: 2 bits (channel we are writing on)
// sample: 16 bits
// TOTAL: 30 bits / 32 available
//
//
// writedata[15:0] - audio data
// writedata[18:16] - ram channel 
// writedata[21:19] - velocity
// writedata[25:22] - shift amount
// writedata[29:26] -active channels 
// writedata[31:30] - live/playback mode
// 

void write_single_sample(const int sample, int channel, int velocity, int shift, int active_channels, int playback ){
  const int combo = (playback & 0x1) << 30 |(active_channels & 0x4) << 29 |(shift & 0x4) << 25 | (velocity & 0x3) << 19 | (channel &&
 0x3) << 16 | (sample & 0xFFFF);

//  printf("%u\n ", (combo &00000000000001110000000000000000 ) >> 16 );
  audio_arg_t vla;
  vla.audio_sample = combo;
  if (ioctl(audio_driver_fd, AUDIO_WRITE, &vla)) {
      perror("ioctl(AUDIO_WRITE) failed");
      return;
  }
}



void write_full_sample(int num_samples, int* data, int channel, int velocity, int shift, int active_channels, int playback){
 //prepares velocity
 unsigned int vel_adj = (velocity & 0b1110000) >> 4 ;
  // TODO: samples are 16 bits, so you could fit 2 samples in 1 write operation
  for(int i = 0; i < num_samples; i++){
    write_single_sample(data[i], channel, vel_adj, shift, active_channels, playback);
  }
//  printf("%d samples written to the driver", i);
};

int get_octave(int noteIndex){
        int octave_index = 0;

        if(noteIndex <= 31) octave_index = 0;
        else if(noteIndex <= 55) octave_index = 1;
        else octave_index = 2;

  return octave_index;
}


int main(){

  //set file names:
        char* sample_name[4][3] = {

          {"bassoonC2.wav","bassoonC3.wav","bassoonC4.wav"} ,
          {"cello2C2.wav","cello2C3.wav","cello2C4.wav" } ,
          {"pianoC2.wav","pianoC3.wav", "pianoC4.wav" } ,
          {"synthbrassC2.wav","synthbrassC3.wav","synthbrassC4.wav"}

        };




//MIDI decoding info
  int c_note = 7;      //TODO: adjust so that this is the note for c
  int shift_amount = 0; //number of half steps
  int octave_index = 0; //min of 2 max of 4
  struct usb_midi_packet packet;
  int transferred;
  char keystate[12];

   //for getting audio sample
  char* prefix = "../../res/samples_cut/";
  size_t prefix_len = strlen(prefix);

//user interface
  user_interface_arg_t vla;
  user_interface_props_t props = {(unsigned short) 100, (unsigned char)1, (unsigned char)1, (unsigned char)1 };
  static const char filename[] = "/dev/user_interface";


//Sequencer controllers
  int* wav_data;
  int num_samples = 0 ;
  int active_chan[16] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
  int control_velocity[4][16] = {
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  };


  int control_notes[4][16] = {
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
  };
  int usleep_interval;
  double beat_duration;
  NoteInfo note;

printf("Sequencer Interface Userspace program started\n");

  // find audio driver
  static const char fname[] = "/dev/audio_driver";
  if ( (audio_driver_fd = open(fname, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", fname);
    return -1;
  }


// find user interface driver
  if ( (user_interface_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  /* Open the keyboard */
  if ( (midi = openmidi(&endpoint_address)) == NULL ) {
    fprintf(stderr, "Did not find a keyboard\n");
    exit(1);
  }


  //Initalize sequencer settings
  read_props(&props);



  //escape loop by playing highest note
  while(note.noteIndex != 73 ) {
        if(props.playback == 1){ //playback mode
	 //calculate wait interval based on bpm
          beat_duration = 60.0 / props.bpm;
          usleep_interval = (int)((beat_duration) * 1000000);
          int cur_octave = 0 ;

        printf("BPM %u \n", props.bpm);
  for (int i = 0 ; i<16; i++){
                printf("%u\d" , i);
                for(int j = 0; j<4;j++){
                        int cur = control_notes[j][i];
                        int cur_velocity = control_velocity[j][i];
                        int cur_active = active_chan[i];

                        if(cur = !0) {
                        cur_octave = get_octave(cur);


                          //get file name
                          char* selectedTrack = sample_name[j][octave_index];
                          size_t selectedTrack_len = strlen(selectedTrack);
                          size_t total_len = prefix_len + selectedTrack_len + 1; // +1 for the null terminator

                         //assemble file path
                          char* desiredPath = malloc(total_len);
                          strcpy(desiredPath, prefix);
                          strcat(desiredPath, selectedTrack);


                          //Get info for write operation
                          num_samples = read_wav(&wav_data, desiredPath, 0);
                          shift_amount = (cur % 12) - c_note;

                         //num_samples, sample, channel, velocity, shfit, active_chan, playback
                         write_full_sample(num_samples, wav_data, j, cur_velocity, shift_amount, active_chan[i] , 1);
                         free(wav_data);
                         free(desiredPath);
                        }



			                  //write the original value back to the arrays
                  control_notes[j][i] = cur;
                  control_velocity[j][i] = cur_velocity;
                  active_chan[i] = cur_active;





                } // end of track loop

                usleep(usleep_interval);
        } //end of step loop


        read_props(&props);
        }//end of props.playback ==1

   else { //record mode    

     libusb_bulk_transfer(midi , endpoint_address, (unsigned char*) &packet, sizeof(packet), &transferred , 0);
        if (transferred == sizeof(packet)) {

        //Get UI info and decode MIDI 
        read_props(&props);
        note = mapCodeToNote(packet.keycode[1]);


        //Todo: figure out if shift amount is right and adjust for writing to hw 
        shift_amount = note.noteVal - c_note;

        //adjust octave
        octave_index = get_octave(note.noteIndex);

// printf("BPM: %u, Step: %u, Track: %u, Playback; %u, Note: %d, Speed: %d\n", props.bpm, props.step, props.track, props.playback, note, packet.keycode[2]);

//printf("status: %u, kc1: %u, kc2: %u, kc3: %u \n" ,packet.status, packet.keycode[0],packet.keycode[1],packet.keycodee[2]);


	        //get the track and file name
        int track = props.track - 1;
        char* selectedTrack = sample_name[track][octave_index];
        size_t selectedTrack_len = strlen(selectedTrack);
        size_t total_len = prefix_len + selectedTrack_len + 1; // +1 for the null terminator
        char* desiredPath = malloc(total_len);
        strcpy(desiredPath, prefix);
        strcat(desiredPath, selectedTrack);


        //printf("file to be opened: %s\n",desiredPath);

        int step_on = props.step;

        // write audio file
         num_samples = read_wav(&wav_data, desiredPath, 0);



         if( note.noteIndex != 0 && packet.status != 8){
		//calculate active channels 
                int curr_active = 1;
                for (int i = 0; i < track ; i++){
                        curr_active *= 2;
                }
	   //write sample
           write_full_sample(num_samples,wav_data, track, packet.keycode[2], shift_amount, curr_active, 0);
           control_notes[track][step_on] = note.noteIndex;
           control_velocity[track][step_on] = packet.keycode[2];

           active_chan[step_on] += curr_active;

        }
         else {
         num_samples = 0;

        } //end of if else 

         free(wav_data);
         free(desiredPath);


         } // end of if(transferred == sizeof)
       
       	usleep(20000);

     } //end of props.playbacj


 } //end of for(;;;)



  printf("Audio Userspace program terminating\n");
  return 0;
}
                                                                                                                  363,1         Bot


