"""

* Script used to preprocess audio samples and cut them to 2 seconds
* Team EmbeddedSequencer - Columbia University


"""

import scipy.io
import scipy.signal
from os import listdir
import numpy as np

dir_original = './samples_original/'
dir_processed = './samples_cut/'

len_procesed = 44100 * 1 # cut lenght of audio samples to 1s
sr_new = 48000

if __name__ == "__main__":
   path_original_list = listdir(dir_original)
   print(path_original_list)

   for f in path_original_list:
      sr, data = scipy.io.wavfile.read(dir_original + f)
      if sr != 44100:
         print("Sample rate != 44.1kHz, exiting program...")
         raise Exception
      
      if len(data) < len_procesed:
         print("Samples shorter than desired length detected, exiting program...")
         raise Exception

      # cut to prespecified length
      data_processed = data[:len_procesed]

      # resample audio
      data_processed = scipy.signal.resample(data_processed, sr_new)
      data_processed = data_processed.astype(np.int16)

      # todo: use a tapering envelope to avoid clicking noise

      # write
      scipy.io.wavfile.write(dir_processed + f, sr_new, data_processed)