import os

def parse_mif(file_path):
    with open(file_path, 'r') as file:
        content = file.read()
    lines = content.strip().split("\n")
    data_lines = lines[lines.index("BEGIN") + 1 : lines.index("END;")]
    data = {int(line.split(":")[0].strip(), 16): line.split(":")[1].strip() for line in data_lines if line.strip()}
    return data

def merge_specific_mif_files(folder_path, filenames):
    try:
        merged_data = {}
        max_address = 0
        file_line_mapping = {}  

        for filename in filenames:
            file_path = os.path.join(folder_path, filename)
            if os.path.exists(file_path):
                data = parse_mif(file_path)
                if data:
                    start_address = max_address
                    for k, v in data.items():
                        new_address = k + max_address
                        merged_data[new_address] = v
                    end_address = max_address + max(data.keys())
                    max_address += max(data.keys()) + 1
                    file_line_mapping[filename] = (start_address, end_address)

        # Generate merged MIF content
        merged_mif_content = "DEPTH =  {};\nWIDTH = 16;\nADDRESS_RADIX = HEX;\nDATA_RADIX = HEX;\nCONTENT\nBEGIN\n".format(max(merged_data.keys()) + 1)
        for k in sorted(merged_data.keys()):
            data_value = merged_data[k].rstrip(';')  
            merged_mif_content += "{}: {};\n".format(format(k, 'X'), data_value)
        merged_mif_content += "END;"

        # Write address mapping
        with open('Address_audio_catdog.txt', 'w') as map_file:
            for file, (start, end) in file_line_mapping.items():
                map_file.write(f"{file}: {start:04X} to {end:04X}\n")

        return merged_mif_content
    
    except Exception as e:
        print(f"An error occurred during merging: {e}")
        return None

# Set the folder path and the specific filenames to merge
folder_path = '.'
filenames = ['cat_meow.mif', 'dog_bark.mif']
ROM_audio = merge_specific_mif_files(folder_path, filenames)

# Print or save the merged MIF content
if ROM_audio:
    print("MIF content generated.")
    with open('ROM_audio_catdog.mif', 'w') as file:
        file.write(ROM_audio)
else:
    print("MIF content generation failed.")
