module ctrl_regs(
    input logic            clk,
	input logic 	   reset,
	input logic [15:0] writedata,
	input logic 	   write,
	input 		   chipselect,
	input logic [7:0]  address,

/********************************************
   Register Group #0
   Dog position, and projectile position and visibility
*********************************************/
    output logic [3:0] cat_bullet,              //cat bullet in flight?
    output logic       dog_bullet,              //dog bullet in flight?
    output logic [9:0] dog_pos_x,               //dog position x           
    output logic [9:0] dog_project_x,           //dog bullet position x
    output logic [9:0] dog_project_y,           //dog bullet position y
    output logic [9:0] cat_project_x[3:0],      //cat 0~3 bullet position x   
    output logic [9:0] cat_project_y[3:0],      //cat 0~3 bullet position y
    output logic [9:0] cat_array_pos_x,         //cat upper west corner position x
    output logic [9:0] cat_array_pos_y,         //cat upper west corner position y
    output logic [9:0] mystery_pos_x,           //mystery position
    output logic       mystery_vis,

/********************************************
   Register Group #1
   Miscellaneous 
*********************************************/
    output logic [3:0]  level,           //game difficulty level 0~7
    output logic [1:0]  game_status,     //game status (start, in process, game over)
    output logic [1:0]  life,            //lives remaining 0~3
    output logic [15:0] score,          //score
    output logic [3:0]  dog_ani_state,
    output logic        cat_ani_state
);

logic [15:0] control_regs[17:0];     //all control registers

//update values from avalon bus
genvar i, j;
generate
    for(i=0; i<=17; i=i+1)begin:loop
        always_ff @(posedge clk)begin
            if(reset) control_regs[i] <= 16'd0;
            else control_regs[i] <= (write && chipselect && (address == i))? writedata : control_regs[i];
        end
    end
endgenerate


//output decode & data alignment
assign cat_bullet = {control_regs[10][15], control_regs[8][15], control_regs[6][15], control_regs[4][15]};
assign dog_bullet = control_regs[2][15];
assign dog_pos_x = control_regs[0][9:0];
assign dog_project_x = control_regs[1][9:0]; 
assign dog_project_y = control_regs[2][9:0]; 
assign cat_project_x[0] = control_regs[3][9:0];
assign cat_project_y[0] = control_regs[4][9:0];
assign cat_project_x[1] = control_regs[5][9:0];
assign cat_project_y[1] = control_regs[6][9:0];
assign cat_project_x[2] = control_regs[7][9:0];
assign cat_project_y[2] = control_regs[8][9:0];
assign cat_project_x[3] = control_regs[9][9:0];
assign cat_project_y[3] = control_regs[10][9:0];
assign cat_array_pos_x = control_regs[11][9:0];
assign cat_array_pos_y = control_regs[12][9:0];
assign mystery_pos_x = control_regs[13][9:0];
assign mystery_vis = control_regs[13][15];

assign level = control_regs[14][7:4];
assign game_status = control_regs[14][3:2];
assign life = control_regs[14][1:0];
assign score = control_regs[15];
assign dog_ani_state = control_regs[16][3:0];
assign cat_ani_state = control_regs[17][0];


// generate
//     for(i=0; i<=2; i=i+1)begin:outer_loop_0
//         for(j=0; j<=3; j=j+1)begin:inner_loop_0
//             assign barrier_0[4*i+j] = control_regs[28+i][(2*j+1):(2*j)];
//         end
//     end
// endgenerate

// generate
//     for(i=0; i<=2; i=i+1)begin:outer_loop_1
//         for(j=0; j<=3; j=j+1)begin:inner_loop_1
//             assign barrier_1[4*i+j] = control_regs[31+i][(2*j+1):(2*j)];
//         end
//     end
// endgenerate

// generate
//     for(i=0; i<=2; i=i+1)begin:outer_loop_2
//         for(j=0; j<=3; j=j+1)begin:inner_loop_2
//             assign barrier_2[4*i+j] = control_regs[34+i][(2*j+1):(2*j)];
//         end
//     end
// endgenerate

// generate
//     for(i=0; i<=2; i=i+1)begin:outer_loop_3
//         for(j=0; j<=3; j=j+1)begin:inner_loop_3
//             assign barrier_3[4*i+j] = control_regs[37+i][(2*j+1):(2*j)];
//         end
//     end
// endgenerate

endmodule
