
module audio_player(
                input logic 	   clk50, reset,
		input logic        left_channel_ready,
		input logic        right_channel_ready,
                input logic        play,
                input logic        play_cat,
                input logic        play_dog,

                input logic [3:0]  vol,
                input logic [3:0] vol_cat,
                input logic [3:0] vol_dog,
                input logic [3:0] delay,
          
		output logic        left_channel_valid,
		output logic        right_channel_valid,

		output logic [15:0] left_channel_data,
		output logic [15:0] right_channel_data
);

    parameter MAX_BG  = 17'd 34680, MAX_CAT = 15'd 6170, MAX_DOG = 15'd 4090;


    logic [3:0] counter;
    //logic [3:0] slowdown;


   logic[17:0] addr;
   logic[17:0] cat_addr;
   logic[17:0] dog_addr;

   logic[15:0] data;
   logic[15:0] cat_data;
   logic[15:0] dog_data;

   soc_system_background_music music(.address(addr), .clk(clk50), .clken(1), .reset(reset), .reset_req(0), .readdata(data));
   soc_system_ROM_cat_meow cat(.address(cat_addr), .clk(clk50), .clken(1), .reset(reset), .reset_req(0), .readdata(cat_data)); 
   soc_system_ROM_dog_bark dog(.address(dog_addr), .clk(clk50), .clken(1), .reset(reset), .reset_req(0), .readdata(dog_data));  

   always_ff @(posedge clk50 or posedge reset) begin
     if (reset) begin
         counter <= 0;
        // slowdown <= 6;
         left_channel_data <= 15'b0;
         right_channel_data <= 15'b0;
         left_channel_valid <= 0;
         right_channel_valid <= 0;
         addr <= 16'b0;
         cat_addr <= 16'b0;
         dog_addr <= 16'b0;
     end else begin


         /*if(left_channel_ready == 1 && counter < 6250) begin
             counter = counter + 1;
            left_channel_valid <= 0;
            right_channel_valid <= 0;
         end else */
         if(left_channel_ready == 1 && right_channel_ready == 1 ) begin //&& counter >= 6250) begin
            //counter <= 0;
            left_channel_valid <= 1;
            right_channel_valid <= 1;

            if(counter == delay)
              counter <= 0;
            else
              counter <= counter + 1;

	    case ({play, play_cat, play_dog})
	      3'b001  : begin
                          left_channel_data <= dog_data;
                          right_channel_data <= dog_data;

                          if(counter == delay) dog_addr <= (dog_addr > MAX_DOG) ? MAX_DOG : dog_addr + 1; 
 
                        end
	      3'b010  : begin
                          left_channel_data <= cat_data;
                          right_channel_data <= cat_data;

                          if(counter == delay) cat_addr <= (cat_addr > MAX_CAT) ? MAX_CAT : cat_addr + 1;
                          
                        end
	      3'b011  : begin
                          left_channel_data <= (cat_data >>> vol_cat) + (dog_data >>> vol_dog);
                          right_channel_data <= (cat_data >>> vol_cat) + (dog_data >>> vol_dog);
			
	                  if(counter == delay)  begin
                             cat_addr <= (cat_addr > MAX_CAT) ? MAX_CAT : cat_addr + 1;
                             dog_addr <= (dog_addr > MAX_DOG) ? MAX_DOG : dog_addr + 1;  
                          end
                        end
	      3'b100  : begin
                          left_channel_data <= data;
                          right_channel_data <= data;

	                  if(counter == delay) addr <= addr + 1;

                          
                        end
	      3'b101  : begin
                          left_channel_data <= (data >>> vol) + (dog_data >>> vol_dog);
                          right_channel_data <= (data >>> vol) + (dog_data >>> vol_dog);

	                  if(counter == delay)  begin
                             addr <= addr + 1;
                             dog_addr <= (dog_addr > MAX_DOG) ? MAX_DOG : dog_addr + 1; 
                          end                           
                        end
	      3'b110  : begin
                          left_channel_data <= (data >>> vol) + (cat_data >>> vol_cat);
                          right_channel_data <= (data >>> vol) + (cat_data >>> vol_cat);

	                  if(counter == delay)  begin
                             addr <= addr + 1;
                             cat_addr <= (cat_addr > MAX_CAT) ? MAX_CAT : cat_addr + 1;
                          end
                        end
	      3'b111  : begin
                          left_channel_data <= (data >>> vol) + (cat_data >>> vol_cat) + (dog_data >>> vol_cat);
                          right_channel_data <= (data >>> vol) + (cat_data >>> vol_cat) + (dog_data >>> vol_cat);

                          if(counter == delay)  begin
                             addr <= addr + 1;
                             cat_addr <= (cat_addr > MAX_CAT) ? MAX_CAT : cat_addr + 1;  
			     dog_addr <= (dog_addr > MAX_DOG) ? MAX_DOG : dog_addr + 1;   
                          end                        
                        end

	      default : begin
                           addr <= 0;
                           cat_addr <= 0;
                           dog_addr <= 0;
                        end
	    endcase

         end else begin
            left_channel_valid <= 0;
            right_channel_valid <= 0;
         end
            if(addr > MAX_BG || play == 0)
              addr <= 0;

            if(play_cat == 0)
              cat_addr <= 0;

            if(play_dog == 0)
              dog_addr <= 0;



     end
   end


endmodule
