#include <linux/module.h>
#include <linux/init.h>
#include <linux/errno.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/platform_device.h>
#include <linux/miscdevice.h>
#include <linux/slab.h>
#include <linux/io.h>
#include <linux/of.h>
#include <linux/of_address.h>
#include <linux/fs.h>
#include <linux/uaccess.h>
#include <stdio.h>      
#include <conio.h>  
#include <stdlib.h>  
#include "vga_ball.h"

#define DRIVER_NAME "vga_ball"

short AMT_FALL_BARREL = 4;
short AMOUNT_MOVE_X = 2;
short AMOUNT_MOVE_Y = 1;


short MARIO = 0;
short BARREL1 = 1;
short BARREL2 = 2;
short BARREL3 = 3;
short BARREL4 = 4;
short BARREL5 = 5;

WIDTH_SPRITE_X = 32;
WIDTH_SPRITE_Y = 32;

struct Coordinates {
    short x;
    short y;
};

struct Labels{
    short tag;
    short direction;
};

struct Sprite {
    int x;
    int y;
    int tag;
    int direction; 
};

//Barrel
short BARREL_HIDDEN = 0;
short BARREL_CIRCLE_VIEW = 1;
short BARREL_SIDEVIEW = 2;

//Barrel Flipping
short BARREL_NORM = 0;
short BARREL_FLIP = 1;


//sprite locations
short LOC_LINE = 0;
short LOC_SLOPE = 1;
short LOC_FALL = 2;
short LOC_LADDER = 3;
short LOC_WIN = 4;
short LOC_HAM = 5;
short OUT_OF_BOUNDS = 6;

//Bools
short FALSE = 0;
short TRUE  = 1;

static int SpriteLocation(short x, short y){
	// Takes a Pixel number, returns an integer, representing what part of the sprite 

	int tile_num_x = floor(x/16);
	int tile_num_y = floor(x/16);


	if (tile_num_y == 29 && tile_num_x <= 5 || tile_num_y == 29 && tile_num_x >= 33){
        struct Labels result = { OUT_OF_BOUNDS, DIR_RIGHT };
		return result;
	}
	else if (tile_num_y==29 && 6 <= tile_num_x <= 19){ 
		struct Labels result = { LOC_LINE, DIR_RIGHT };
        return result;
	}
	else if (tile_num_y==29 && 19 < tile_num_x < 33){ 
		struct Labels result = { LOC_SLOPE, DIR_RIGHT };
        return result;

	}
	//TO DO: do the rest of the board

}

static void run_game(struct Barrels barrels, int lives, int gamecount){
    while (lives > 0){
        int spawn_barrel = FALSE;

        if (gamecount % 1000 == 0){ //change this to make sense for time
            spawn_barrel = TRUE;
        }
        gamecount = gamecount + 1; //increment gamecount

        //barrels
        for (int i = 0; i < 8; i++) {
            struct Coordinates new_coords;
            struct Barrel b = list[i];
            struct Result res = SpriteLocation(b.x, b.y);
            int loc = res.loc;
            int dir = res.tag;

            if (b.tag != BARREL_HIDDEN){ //not hidden
                
                if (check_collison(mario.x, mario.y, b.x, b.y) == 1){ //if marios collided with a barrel
                    lives=lives-1;
                    reset_game(lives);
                    return
                }

                if (loc == LOC_LINE){ //on a straight line
                    if (dir == DIR_RIGHT){//right
                        new_coords = move(b.x, b.y, AMOUNT_MOVE_X, 0);
                    }
                    else{//left
                        new_coords = move(b.x, b.y, -AMOUNT_MOVE_X, 0);
                    }
                    b.x = new_coords.x;
                    b.y = new_coords.y;
                     
                    b.tag = BARREL_CIRCLE_VIEW; 
                    if (b.direction == DIR_LEFT){ //swap flipping of barrels
                        b.direction = DIR_RIGHT;
                    }
                    else{
                        b.direction = DIR_LEFT;
                    }
                }

                if (loc == 1){ //on a slope
                    if (dir == 0){//right
                        new_coords = move(b.x, b.y, AMOUNT_MOVE_X, -AMOUNT_MOVE_Y);
                    }
                    else{//left
                        new_coords = move(b.x, b.y, -AMOUNT_MOVE_X, -AMOUNT_MOVE_Y);
                    }
                    b.x = new_coords.x;
                    b.y = new_coords.y;
                     
                    b.tag = 1; 
                    if (b.direction == 0){ //swap flipping of barrels
                        b.direction = 1;
                    }
                    else{
                        b.direction = 0;
                    }
                }

                if (loc == 2 || loc ==5){ //falling
                    if (dir == 0){//right
                        new_coords = move(b.x, b.y, 0, -AMOUNT_MOVE_Y);
                    }
                    else{//left
                        new_coords = move(b.x, b.y, 0, -AMOUNT_MOVE_Y);
                    }
                    b.x = new_coords.x;
                    b.y = new_coords.y;
                     
                    b.tag = 2; //side

                    if (b.direction == 0){ //swap flipping of barrels
                        b.direction = 1;
                    }
                    else{
                        b.direction = 0;
                    }
                }

                if (loc == 3){ //ladder
                    int random = rand() * 4 / (RAND_MAX); //should give number 0 1 2 3
                    if (dir == 2 || random == 0){//DOWN!! This means its on the part of the ladder that goes down or randomly chosen to go down
                        new_coords = move(b.x, b.y, 0, -AMOUNT_LADDER);
                        b.tag = 2; 

                    }
                    else{//TO DO: Check if can assume slant or not
                        b.tag = 1; 
                        if (dir == 0){//right
                            new_coords = move(b.x, b.y, AMOUNT_MOVE_X, -AMOUNT_MOVE_Y);
                        }
                        else{//left
                            new_coords = move(b.x, b.y, -AMOUNT_MOVE_X, -AMOUNT_MOVE_Y);
                        }     
                    }

                    b.x = new_coords.x;
                    b.y = new_coords.y;
                    if (b.direction == 0){ //swap flipping of barrels
                        b.direction = 1;
                    }
                    else{
                        b.direction = 0;
                    } 
                }

            }
            else{ //barrel is invisible
                if (spawn_barrel ==1){

                    b.x = 0*16;
                    b.y = 4*16;
                    b.tag = 3; //side
                    b.label = 0; //right
                    spawn_barrel = 0;
                }
            }  
            
            set_coordinates(b, i+1); 
        }

    }
    

}

int main()
{
    printf("Donkey Kong program started\n");

    struct Barrels barrels;
    short lives; 
    

    barrels.barrel_list[0] = barrels.b1;
    barrels.barrel_list[1] = barrels.b2;
    barrels.barrel_list[2] = barrels.b3;
    barrels.barrel_list[3] = barrels.b4;
    barrels.barrel_list[4] = barrels.b5;

    for (int i = 0; i < 8; i++) {
        struct Sprite b = barrel_list[i];
        b.x = 4*16;
        b.y = 6*16;
        b.tag = 0; 
        b.direction = 0; //going right
        list[i] = b;

        set_coordinates(b, i+1);
    }

    run_game(barrels, lives, 0);

    usleep(20000);
    
}

