/*

 * 
 * CSEE 4840 Lab 2 for 2019
 * Ania Roza Krzyzanska ark2219
 * Ines Khouider ik2512
 * Sean Stothers sps2308
 */
//#include "fbputchar.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include "usbkeyboard.h"
#include "vga_ball.h"
#include <pthread.h>
#include <sys/ioctl.h>
#include <math.h>


#define SERVER_HOST "128.59.19.114"
#define SERVER_PORT 42000

#define BUFFER_SIZE 128

int sockfd; /* Socket file descriptor */

struct libusb_device_handle *keyboard;
uint8_t endpoint_address;

pthread_t network_thread;
void *network_thread_f(void *);
enum key_input{KEY_NONE, KEY_LEFT, KEY_RIGHT,KEY_UP, KEY_DOWN, KEY_A, KEY_B, KEY_START, KEY_SELECT};
int key_pressed;
int vga_ball_fd;

short MARIO = 0;
short BARREL1 = 1;
short BARREL2 = 2;
short BARREL3 = 3; 
short BARREL4 = 4;
short BARREL5 = 5;
short DONKEYKONG = 6;
short HAMMER = 7;
short HEART = 8;
short SCORE_1 = 9; //leftmost 
short SCORE_2 = 10;
short SCORE_3 = 11;
short SCORE_4 = 12; //rightmost 

short DIR_RIGHT = 0;
short DIR_LEFT = 1;
short DIR_UPDOWN = 2;

struct Coordinates {
    short x;
    short y;
};

struct Labels{
    short tag;
    short direction;
};

struct Sprite {
    short x;
    short y;
    short tag;
    short on;
    short direction; 
    short what_spite;
};

struct Barrels
{
    struct Sprite b1;
    struct Sprite b2;
    struct Sprite b3;
    struct Sprite b4;
    struct Sprite b5;
    
    struct Sprite barrel_list[5]; 

};


//sprite locations
short LOC_LINE = 0;
short LOC_SLOPE = 1;
short LOC_LADDER = 2;
short LOC_HAM = 3;
short LOC_FALL = 4;
short LOC_WIN = 5;
short OUT_OF_BOUNDS = 6;
short LOC_SNAP_UP = 7;

struct Result
{
	int loc;
	int tag;
    int snap;
};

struct Reset_Sprite{
  struct Sprite mario;
  struct Sprite b1;
  struct Sprite b2;
  struct Sprite b3;
  struct Sprite b4;
  struct Sprite b5;
  
};

static int collision(struct Sprite mario, struct Sprite barrel){
    int mx = mario.x + 4; 
    int mxmax = mario.x + 32 - 4 ;

	int mtop = mario.y;
    int mbottom = mario.y + 32;

    int bx = barrel.x  + 4; //barrel is 24 pixels
    int bxmax = barrel.x + 32 - 4;

	int btop = barrel.y + 20;
    int bbottom = barrel.y + 32;



    if (mx > bx && mx < bxmax || mx < bx && mx > bxmax){
		
		if ((mtop >= bbottom && mtop <= btop) ||(mtop <= bbottom && mtop >= btop)){
			return 1;
		}
		if ((mbottom >= bbottom && mbottom <= btop) || (mbottom <= bbottom && mbottom >= btop)){
			return 1;
		}

    }
	else if ((mxmax > bxmax && mxmax < bx) || (mxmax < bxmax && mxmax > bx)){		

		if (mtop >= bbottom && mtop <= btop || mtop <= bbottom && mtop >= btop){
	
			return 1;

		}
		if ((mbottom >= bbottom && mbottom <= btop) || (mbottom <= bbottom && mbottom >= btop)){
			return 1;

		}
	}
    return 0;
}

uint8_t tile_map[30][35] = {
{0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,11,19,19,19,19,19,19,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,11,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,11,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,20,20,20,20,20,20,20,20,12,20,12,20,20,20,20,20,12,20,84,84,85,85,86,86,0,0,0,0,0,0},
{0,0,0,0,0,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,46,19,19,0,0,0,0},
{0,0,0,0,0,0,0,113,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0},
{0,0,0,0,0,0,0,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,70,91,91,92,92,0,0},
{0,0,0,0,0,0,0,0,0,0,0,90,90,91,91,92,92,93,93,94,94,95,95,96,96,19,19,90,90,90,90,19,19,0,0},
{0,0,0,0,0,0,0,96,96,15,19,91,91,90,51,90,90,90,90,90,90,90,90,90,90,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,11,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,85,85,86,86,11,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,90,90,90,90,13,19,80,80,81,81,82,82,83,83,84,84,85,85,86,86,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,90,90,90,90,90,90,90,90,11,90,90,90,90,90,19,19,80,80,81,81,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,90,40,90,91,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,11,0,0,90,90,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,90,91,91,72,92,93,93,94,94,95,95,96,76,19,19,90,90,0,0},
{0,0,0,0,0,0,0,90,90,91,91,92,92,19,19,90,90,11,90,90,90,90,90,90,90,90,90,90,90,0,0,0,0,0,0},
{0,0,0,0,0,0,0,90,90,51,90,90,90,0,0,0,0,11,0,0,0,0,0,0,0,0,114,114,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,114,0,0,0,0,0,0,0,0},
{0,0,0,0,0,19,19,80,80,61,81,82,82,83,83,84,84,65,85,86,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,90,90,90,90,90,90,90,90,90,90,90,90,90,90,19,19,80,80,81,81,82,82,83,83,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,90,90,90,90,42,90,90,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,90,91,91,92,92,93,93,94,74,95,95,96,96,0,0},
{0,0,0,0,0,19,19,19,19,19,19,19,19,19,19,19,19,19,19,90,90,90,90,90,90,90,90,90,90,90,90,90,90,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};


//BarrelGoing from (368, 127) to Going from (368, 128)

short BARREL_HIDDEN = 0;
short BARREL_CIRCLE_VIEW = 2;
short BARREL_CIRCLE_VIEW_FLIP = 3;
short BARREL_SIDEVIEW = 2;

//Barrel Flipping
short BARREL_NORM = 0;
short BARREL_FLIP = 1;

//mario deaths
int MARIO_DEATH_1 = 3;
int MARIO_DEATH_2 = 12;
int MARIO_DEATH_3 = 13;
int MARIO_DEATH_4 = 14;
int MARIO_DEATH_5 = 15;

//mario win dance


int MARIO_HAMMER1 = 8;
int MARIO_HAMMER2 = 9;
int MARIO_HAMMER3 = 10;


short BFALL = 0;
short BRIGHT = 1;
short BRIGHTSLANT = 2;

short BLEFT = 3;
short BLEFTSLANT = 4;
short BSTART = 5; //this is also 1 technically

static struct Result SpriteLocation(short x, short y, int old_loc, int old_tag){
	int tile_num_x = (int)(x/16); 
	int tile_num_y = (int)(y/16);
	int offset;


    uint8_t code = tile_map[tile_num_y][tile_num_x];


    struct Result res;
	res.loc = old_loc;
	res.tag = old_tag;

    // printf("x is %d y is %d and tile number is %d", tile_num_x, tile_num_y, code);

    if (code == 0) {
        // printf("FALLING");
        res.loc = LOC_FALL;
    } else if ((19 <= code) && (96 >= code)){ //
	if ((code == 19) || (code == 13)) { //no offset
	    // printf("LINE");
	    res.loc = LOC_LINE;
	} else if (((code / 10) == 8) || ((code / 10) == 9) || ((code / 10) == 6) || ((code / 10) == 7)) { //offset
	    if (((code / 10) == 9) || ((code / 10) == 7)) {
	        offset = 14 - (2 * (code % 10));// maps code to offset from 16 tile grid (ex. 96 -> 2, 90 -> 14)
	    } else {
		offset = 2 + (2 * (code % 10));// maps code to offset from 16 tile grid (ex. 86 -> 14, 80 -> 2)
	    }
            if ((((y / 16) * 16) + offset) > y) {
		// printf("FALLING");
                res.loc = LOC_FALL;
	    } else if ((((y / 16) * 16) + offset) < y) {
		// printf("SNAP UP");
		res.loc = LOC_SNAP_UP;
		res.snap = (((y / 16) * 16) + offset) - y;
	    } else {
		// printf("LINE");
		res.loc = LOC_LINE;
	    }
	} else if ((code == 20) || (code == 12)) { //offset for no slope (numbers don't fit other equation)
	    offset = 8;// always 8
            if ((((y / 16) * 16) + offset) > y) {
		// printf("FALLING");
                res.loc = LOC_FALL;
	    } else if ((((y / 16) * 16) + offset) < y) {
		// printf("SNAP UP");
		res.loc = LOC_SNAP_UP;
		res.snap = (((y / 16) * 16) + offset) - y;
	    } else {
		// printf("LINE");
		res.loc = LOC_LINE;
	    }
	}
    } else if ((code == 11) || ((code / 10) == 4) || ((code / 10) == 5)){ //ladder tops here too for now
	if ((key_pressed == KEY_DOWN) || (key_pressed == KEY_UP)) {
            // printf("LADDER should only go down and up");
            res.loc = LOC_LADDER;
            res.tag = DIR_UPDOWN;
	} else {
	    // printf("LINE");
	    res.loc = LOC_LINE;
	}
    } else if (code == 12 || ((code / 10) == 6) || ((code / 10) == 7)){ //ladder bottoms
		if ((key_pressed == KEY_UP)) {
				// printf("LADDER can go up and down and left anf right ON SLOPE");
				res.loc = LOC_LADDER;
				res.tag = DIR_RIGHT;
		} else {
			// printf("LINE");
			res.loc = LOC_LINE;
		}
    }
	else{
		res.loc = old_loc;
		res.tag = old_tag;

	}



    return res;


}



	
vga_ball_sprite_state_t st = {.state=0};
vga_ball_sprite_state_t st1 = {.state=0};


static int get_location(short x, short y){
    int tile_num_x = (int)(x/16); 
	int tile_num_y = (int)(y/16);  
	
    int code = tile_map[tile_num_y][tile_num_x];
    
    return code;
    
}


/* Set the background color */
void send_to_HW(struct Sprite sprite, struct Sprite barrel0, struct Sprite barrel1, struct Sprite barrel2, struct Sprite barrel3, struct Sprite barrel4, short type)
{
    	   vga_ball_arg4_t vla4;
  	    //printf("MARIO\n");
  	    vga_ball_xy_t coord;
  	    vga_ball_arg3_t vla3;
  	   // fprintf(stderr, "\n coordinates: (%u, %u)\n", sprite.x, sprite.y);
  	    coord.x_coor = sprite.x;
  	    coord.y_coor = sprite.y;
  	    //sprite.tag = indicate;
  	    st.state = (sprite.tag << 1) + sprite.direction + (st.state & 4294967264); //FFFFFFE0 in decimal
  	    // printf("Mario state %x\n", st.state);
  	    vla3.coor = coord;
  	    vla4.m_state = st;
  	    if (ioctl(vga_ball_fd, VGA_BALL_MARIO_COORDINATES, &vla3))
  	    {
  	        perror("ioctl(VGA_BALL_MARIO_COORDINATES) failed");
  	        return;
  	    }
  	   
       
        vga_ball_barrel0_xy_t coord0;
        vga_ball_arg5_t vla5;
        coord0.bx0 = barrel0.x;
        coord0.by0 = barrel0.y;
        vla5.coor = coord0;
        // printf("writing to barrel 0 (%d,%d)\n", barrel0.x, barrel0.y);
        vga_ball_barrel1_xy_t coord1;
        vga_ball_arg6_t vla6;
        coord1.bx1 = barrel1.x;
        coord1.by1 = barrel1.y;
        vla6.coor = coord1;
	    //   printf("writing to barrel 1 (%d,%d)\n", barrel1.x, barrel1.y);
	vga_ball_barrel2_xy_t coord2;
        vga_ball_arg7_t vla7;
        coord2.bx2 = barrel2.x;
        coord2.by2 = barrel2.y;
        vla7.coor = coord2;
        // printf("writing to barrel 2 (%d,%d)\n", barrel2.x, barrel2.y);
	vga_ball_barrel3_xy_t coord3;
        vga_ball_arg8_t vla8;
        coord3.bx3 = barrel3.x;
        coord3.by3 = barrel3.y;
        vla8.coor = coord3;
        // printf("writing to barrel 3 (%d,%d)\n", coord3.bx3, coord3.by3);
	vga_ball_barrel4_xy_t coord4;
        vga_ball_arg9_t vla9;
        coord4.bx4 = barrel4.x;
        coord4.by4 = barrel4.y;
        vla9.coor = coord4;
        // printf("writing to barrel 4 (%d,%d)\n", coord4.bx4, coord4.by4);
	
        st.state = (barrel0.tag << 5) + (barrel0.direction << 7) + (st.state & 4294967071);   // this is the value of the bitmask with 32 1s and 0s at bits 5-7 (11111111111111111111100011111111)
        st.state = (barrel1.tag << 8) + (barrel1.direction << 10) + (st.state & 4294965503);  // in binary 1111_1111_1111_1111_1111_1000_1111_1111
        st.state = (barrel2.tag << 11) + (barrel2.direction << 13) + (st.state & 4294952959);  // in binary 1111_1111_1111_1111_1111_1000_1111_1111
	st.state = (barrel3.tag << 14) + (barrel3.direction << 16) + (st.state & 4294852607);
	st.state = (barrel4.tag << 17) + (barrel4.direction << 19) + (st.state & 4294049791);
	st.state = (barrel0.on << 23) + (st.state & (~(1 << 23)));
        st.state = (barrel1.on << 24) + (st.state & (~(1 << 24)));
	st.state = (barrel2.on << 25) + (st.state & (~(1 << 25)));
	st.state = (barrel3.on << 26) + (st.state & (~(1 << 26)));
	st.state = (barrel4.on << 27) + (st.state & (~(1 << 27)));
       
        vla4.m_state = st; //
        // printf("\n Barrel state %x\n", st.state);
	if (ioctl(vga_ball_fd, VGA_BALL_BARREL4_COORDINATES, &vla9))
        {
            perror("ioctl(VGA_BALL_b4) failed");
            return;
        }
	if (ioctl(vga_ball_fd, VGA_BALL_BARREL3_COORDINATES, &vla8))
        {
            perror("ioctl(VGA_BALL_b3) failed");
            return;
        }
	if (ioctl(vga_ball_fd, VGA_BALL_BARREL2_COORDINATES, &vla7))
        {
            perror("ioctl(VGA_BALL_b2) failed");
            return;
        }
        if (ioctl(vga_ball_fd, VGA_BALL_BARREL1_COORDINATES, &vla6))
        {
            perror("ioctl(VGA_BALL_b2) failed");
            return;
        }
        if (ioctl(vga_ball_fd, VGA_BALL_BARREL0_COORDINATES, &vla5))
        {
            perror("ioctl(VGA_BALL_b1) failed");
            return;
        }
        if (ioctl(vga_ball_fd, VGA_BALL_SPRITE_STATE, &vla4))
        {
            perror("ioctl(VGA_BALL_SPRITE_STATE) failed");
            return;
        }
}


static void mario_die(struct Sprite mario, struct Sprite b1, struct Sprite b2, struct Sprite b3, struct Sprite b4, struct Sprite b5){
	for (int death_cycle = 0; death_cycle < 400; death_cycle ++){
		if (death_cycle < 100){
				mario.tag = MARIO_DEATH_1;
		}
		else if ((death_cycle % 100) < 25){
						mario.tag = MARIO_DEATH_2;
			}
		else if ((death_cycle % 100) < 50){
						mario.tag = MARIO_DEATH_3;
			}
		else if ((death_cycle % 100) < 75){
						mario.tag = MARIO_DEATH_4;
			}
		else if ((death_cycle % 100) < 100){
						mario.tag = MARIO_DEATH_5;
		}
		send_to_HW(mario, b1, b2, b3, b4, b5, MARIO);

		usleep(20000);
	}

}

static void mario_hammer(struct Sprite mario, struct Sprite b1, struct Sprite b2, struct Sprite b3, struct Sprite b4, struct Sprite b5){
	for (int hammer_cycle = 0; hammer_cycle < 500; hammer_cycle ++){
		if ((hammer_cycle % 75) < 25){
			mario.tag = MARIO_HAMMER1;
		}
		else if ((hammer_cycle % 75) < 50){
			mario.tag = MARIO_HAMMER2;
		}
		else if ((hammer_cycle % 75) < 75){
			mario.tag = MARIO_HAMMER3;
		}
		if ((hammer_cycle % 75) == 0){
			if (mario.direction == 0){
				mario.direction = 1;
			}
			else{
				mario.direction = 0;
			}
		}
		send_to_HW(mario, b1, b2, b3, b4, b5, MARIO);

		usleep(20000);
	}

}

static struct Coordinates move(short x, short y, short movement_x, short movement_y){
    //these represent the walls
    short new_x = x + movement_x;
    short new_y = y + movement_y;

    //check in range of pixels the donkey kong map is at
    int begin_x = 4*16;
    int end_x = 35*16;
    int begin_y = 0*16;
    int end_y = 29*16;

    if (new_x < begin_x){
       new_x = begin_x;
    }
    if (new_x > end_x){
       new_x = end_x;
    }
    if (new_y < begin_y){
       new_y = begin_y;
    }
    if (new_y > end_y){
       new_y = end_y;
    }

    // fprintf(stderr, "Going from (%d, %d) to ", x, y);
    // fprintf(stderr, "Going from (%d, %d)\n", new_x, new_y);


    struct Coordinates result = { new_x, new_y };
    return result;

}

struct Reset_Sprite reset(){
   struct Reset_Sprite res;
   struct Sprite mario;
   struct Sprite b1;
   struct Sprite b2;
   struct Sprite b3;
   struct Sprite b4;
   struct Sprite b5;

    mario.x = 5*16 +8;
    mario.y = 27*16;
    mario.tag = 0;
    mario.on = 1;
    mario.direction = 0;

    b1.x = 5*16+8;
    b1.y = 6*16;
    b1.tag = BARREL_CIRCLE_VIEW;
    b1.direction = BARREL_NORM;
    b1.on = 1;

    b2.x = 12*16; //change this later
    b2.y = 27*16;
    b2.tag = BARREL_CIRCLE_VIEW;
    b2.direction = BARREL_NORM;
    b2.on = 1;

    b3.x = 16*16; //change this later
    b3.y = 27*16;
    b3.tag = BARREL_CIRCLE_VIEW;
    b3.direction = BARREL_NORM;
    b3.on = 1;

    b4.x = 16*16; //change this later
    b4.y = 11*16;
    b4.tag = BARREL_CIRCLE_VIEW;
    b4.direction = BARREL_NORM;
    b4.on = 1;

    b5.x = 16*16; //change this later
    b5.y = 7*16;
    b5.tag = BARREL_CIRCLE_VIEW;
    b5.direction = BARREL_NORM;
    b5.on = 1;

    res.mario = mario;
    res.b1  =b1;
    res.b2 = b2;
    res.b3 = b3;
    res.b4 = b4;
    res.b5 = b5;
    send_to_HW(mario, b1, b2, b3, b4, b5, MARIO);
    return res;
}

int main()
{

    //struct usb_keyboard_packet pac72:16: error: expected identifier or '(' before ')' token
    unsigned char data[8];
    int transferred;

    static const char filename[] = "/dev/vga_ball";

    if ( (vga_ball_fd = open(filename, O_RDWR)) == -1) {
        fprintf(stderr, "could not open %s\n", filename);
        return -1;
    }


    /* Open the keyboard */
    if ( (keyboard = openkeyboard(&endpoint_address)) == NULL ) {
        fprintf(stderr, "Did not find a keyboard\n");
        exit(1);
    } else{
	    fprintf(stderr, "Found keyboard!");
    }

    //write mario to start position
    int no_jump =1;	
    int jump_cycle = 0;	
    int walk_cycle = 0;


    struct Reset_Sprite reset_val= reset();
    
    struct Sprite b1 = reset_val.b1;
    struct Sprite b2 = reset_val.b2; 
    struct Sprite b3 = reset_val.b3;
    struct Sprite b4 = reset_val.b4;
    struct Sprite b5 = reset_val.b5;
    struct Sprite mario = reset_val.mario;



    int loc = get_location(b1.x, b1.y);
    struct Coordinates coords;




    printf("starting program");

    int walk_counter_r = 0;
    int walk_counter_l = 0;
    int offset;

    int location  = -1;
    int direction = -1;

    for (;;) {

		if (collision(mario, b1) == 1 || collision(mario, b2) == 1 ||collision(mario, b3) == 1 ||collision(mario, b4) == 1 ||collision(mario, b5) == 1){
				mario_death(mario, b1, b2, b3, b4, b5);

				reset_val = reset();

				b1 = reset_val.b1;
				b2 = reset_val.b2; 
				b3 = reset_val.b3;
				b4 = reset_val.b4;
				b5 = reset_val.b5;
				mario = reset_val.mario;
				send_to_HW(mario, b1, b2, b3, b4, b5, MARIO);

		}

		// if (win_state){
		// 	mario_hammer(mario, b1, b2, b3, b4, b5);
		// 	b1 = reset_val.b1;
		// 	b2 = reset_val.b2; 
		// 	b3 = reset_val.b3;
		// 	b4 = reset_val.b4;
		// 	b5 = reset_val.b5;
		// 	mario = reset_val.mario;
		// 	send_to_HW(mario, b1, b2, b3, b4, b5, MARIO);
		// }




        struct Result current_loc = SpriteLocation(mario.x, mario.y, location, direction);

        int location = current_loc.loc;
        int direction = current_loc.tag;
	    int snap_up = current_loc.snap;


	    libusb_interrupt_transfer(keyboard, endpoint_address,
                    data, sizeof(data),
                    &transferred, 0);
        if (transferred == sizeof(data)) {
            key_pressed= KEY_NONE;
		if(!no_jump){
			    if(jump_cycle <16){
					if(mario.direction == 0){
						coords = move(mario.x, mario.y, 2, -2);
						mario.x = coords.x;
    						mario.y = coords.y;
						
					}else{
						coords = move(mario.x, mario.y, -2, -2);
						mario.x = coords.x;
    						mario.y = coords.y;
					}
			} else if (jump_cycle < 20) {
					if(mario.direction == 0){
						coords = move(mario.x, mario.y, 2, -1);
						mario.x = coords.x;
    						mario.y = coords.y;
					}else{
						coords = move(mario.x, mario.y, -2, -1);
						mario.x = coords.x;
    						mario.y = coords.y;
					}
			} else if (jump_cycle < 24) {
					if(mario.direction == 0){
						coords = move(mario.x, mario.y, 2, 1);
						mario.x = coords.x;
    						mario.y = coords.y;
					}else{
						coords = move(mario.x, mario.y, -2, 1);
						mario.x = coords.x;
    						mario.y = coords.y;
					}
			} else if (jump_cycle < 34) {
					if(mario.direction == 0){
						coords = move(mario.x, mario.y, 2, 2);
						mario.x = coords.x;
    						mario.y = coords.y;
					}else{
						coords = move(mario.x, mario.y, -2, 2);
						mario.x = coords.x;
    						mario.y = coords.y;
					}
			} else {
					no_jump = 1;
					mario.tag = 0;
					jump_cycle=0;
			}
			jump_cycle++;
	        }else if (location == LOC_FALL && no_jump) {
		    coords = move(mario.x, mario.y,0,1);
			// fprintf(stderr, "Falling");
			mario.x = coords.x;
			mario.y = coords.y;
	
	        } else if (location == LOC_SNAP_UP && no_jump) {
	            coords = move(mario.x, mario.y,0,snap_up);
	                // fprintf(stderr, "Snap Up");
	                mario.x = coords.x;
	                mario.y = coords.y;
	        } else {
	                if(data[3]== 0 && no_jump){ //left pressed
	                    key_pressed = KEY_LEFT;
	                    if (location == LOC_LINE || location == LOC_FALL){
	                        coords = move(mario.x, mario.y,-1,0);
	                    }
	                    else if (location == LOC_SLOPE){
	                        if (direction == DIR_RIGHT){
	                            coords = move(mario.x, mario.y,-1,-1);
	                        }
	                        else{
	                            coords = move(mario.x, mario.y,-1,1);
	                        }
	                    }
	                    else{
	                        // printf("not in a place where you can go left");
	                    }
	                    mario.x = coords.x;
	                    mario.y = coords.y;
	                    mario.direction = 1;
	
	                    if((walk_cycle % 6) == 0){
	                        mario.tag =1;
	                    } else if ((walk_cycle % 6) == 2){
	                        mario.tag=0;
	                        }
	                    walk_cycle++;
	
	                    // fprintf(stderr, "Left");
	                }
	
	                else if(data[3]== 255 && no_jump){ //right pressed
	                    key_pressed = KEY_RIGHT;
	                    if (location == LOC_LINE  || location == LOC_FALL){
	                        coords = move(mario.x, mario.y,1,0);
	                    }
	                    else if (location == LOC_SLOPE){
	                        if (direction == DIR_RIGHT){
	                            coords = move(mario.x, mario.y,1,-1);
	                        }
	                        else{
	                            coords = move(mario.x, mario.y,1,1);
	
	                        }
	                    }
	                    else{
	                        // printf("not in a place where you can go right");
	                    }
	
	                    mario.x = coords.x;
	                    mario.y = coords.y;
	                    mario.direction = 0;
	                    if((walk_cycle % 6) == 0){
	                        mario.tag =1;
	                    } else if ((walk_cycle % 6) == 2){
	                        mario.tag=0;
	                    }
	                    walk_cycle++;
	
	                    // fprintf(stderr, "Right");
	                }
	
	
	                else if(data[4]== 0 && no_jump){ //up pressed
	                    key_pressed = KEY_UP;
	                    coords = move(mario.x, mario.y,0,-1);
	                    mario.x = coords.x;
	                    mario.y = coords.y;
	                    // fprintf(stderr, "Up");
	                    if((walk_cycle % 6) == 0 && mario.tag !=4){
	                        mario.tag =7;
	                    } else if ((walk_cycle % 6) == 2){
	                        mario.direction = 0;
	                        mario.tag=4;
	                    } else if ((walk_cycle % 6) == 5){
	                        mario.direction = 1;
	                        mario.tag=4;
	                    }
	                    walk_cycle++;
	                }
	
	                else if(data[4]== 255 && no_jump){ //Down pressed
	                    key_pressed = KEY_DOWN;
	                    coords = move(mario.x, mario.y,0,1);
	                    // fprintf(stderr, "Down");
	                    mario.x = coords.x;
	                    mario.y = coords.y;
	                    if((walk_cycle % 6) == 0 && mario.tag !=4){
	                        mario.tag =7;
	                    } else if ((walk_cycle % 6) == 2){
	                        mario.direction = 0;
	                        mario.tag=4;
	                    } else if ((walk_cycle % 6) == 5){
	                        mario.direction = 1;
	                        mario.tag=4;
	                    }
	                    walk_cycle++;
	                }
	
	
	                else if(data[5]== 47 && no_jump){ //A pressed
	                    // fprintf(stderr, "Jump");
	                    // if (location != LOC_FALL){
	                    //     coords = move(mario.x, mario.y,0,5);
	                    // }
	                    key_pressed = KEY_A;
	                    mario.tag = 2;
	                    no_jump = 0; //temp commented out
			    // printf("\nno jump in JUMP: %d \n", no_jump);	
	                    fprintf(stderr, "A");
	                }
	          
	            else if(data[5]== 79){ //B pressed
	                key_pressed = KEY_B;
	                fprintf(stderr, "B");
	            }
	            else if(data[5]== 111){ //A +B
	                fprintf(stderr, "A+B");
	            }
	            else if(data[6]== 32){ //start
	                key_pressed = KEY_START;
	                fprintf(stderr, "start");
	            }else if(data[6]== 16){ //select
	                key_pressed = KEY_SELECT;
	                fprintf(stderr, "select");
	            }else if(data[6]== 48){ //start + select
	                fprintf(stderr, "start + select");
	            }
	        }
        // int loc = get_location(b1.x, b1.y - 6); //account for the fact the barrel is shifted down by 6 since the bottom of the sprite is transparent


			usleep(20000);
			send_to_HW(mario, b1, b2, b3, b4, b5, MARIO);
		
	

        }


    }

}


