#include <stdio.h>
#include "vga_ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

#include <stdlib.h>
//#include <linux/stdint.h>

struct rgb {
    char red;
    char green;
    char blue;
};

char tile_map[32][32] = {
{0,0,0,0,0,0,0,0,0,0,0,47,48,49,47,0,50,51,52,53,54,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,55,55,55,55,55,55,0,0,0,0,55,55,55,55,55,55,0,0,0,0,45,46,1,1,0,0,0,0,0},
{0,0,0,65,65,0,0,0,0,0,11,0,11,93,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,11,0,11,95,96,0,0,0,0,0,0,0,0,70,71,72,73,74,75,0,0,0},
{0,0,81,82,83,0,116,117,118,119,11,0,11,97,98,0,0,0,0,0,0,0,0,76,99,99,99,99,77,0,0,0},
{0,0,84,85,86,120,121,133,123,124,11,0,11,19,19,19,19,19,19,0,0,0,0,78,79,79,79,79,80,0,0,0},
{0,0,87,88,89,125,126,127,128,129,11,0,11,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,90,91,92,130,131,132,133,134,11,0,11,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,93,94,95,135,136,137,138,139,23,37,23,37,37,37,37,37,23,37,38,38,39,39,40,40,0,0,0,0,0,0},
{0,0,30,30,30,30,30,30,30,30,30,30,30,15,30,30,30,30,30,30,31,31,32,32,33,18,19,19,0,0,0,0},
{0,0,0,0,113,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0},
{0,0,0,0,115,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,40,26,39,39,38,38,0,0},
{0,0,0,0,0,0,0,0,40,40,39,39,38,24,37,37,36,36,35,35,34,34,19,19,33,33,32,32,31,31,0,0},
{0,0,0,0,34,34,19,19,33,33,32,16,31,31,30,30,29,29,28,28,27,27,0,11,0,0,0,0,0,0,0,0},
{0,0,0,0,27,27,11,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,39,39,40,40,11,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,32,32,33,33,19,19,34,34,35,21,36,36,37,37,38,38,39,39,40,40,0,11,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,27,27,13,28,29,29,30,30,16,31,32,32,33,33,19,19,34,34,35,35,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,27,12,28,28,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,11,0,0,40,40,0,0},
{0,0,0,0,0,0,0,0,0,0,11,0,40,40,39,39,24,38,37,37,36,36,35,35,34,20,19,19,33,33,0,0},
{0,0,0,0,36,36,35,35,34,34,19,19,33,33,17,32,31,31,30,30,29,29,28,28,27,27,0,0,0,0,0,0},
{0,0,0,0,29,29,13,28,27,27,0,0,0,0,11,0,0,0,0,0,0,0,0,113,114,0,0,0,0,0,0,0},
{0,0,0,0,0,0,11,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,115,0,0,0,0,0,0,0,0},
{0,0,19,19,34,34,21,35,36,36,37,37,38,38,25,39,40,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,27,27,28,28,29,29,30,30,16,31,32,32,33,33,19,19,34,34,35,35,36,36,37,37,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,27,28,28,29,0,30,30,0,0,0,0},
{0,0,0,0,66,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0},
{0,0,0,0,68,69,0,0,0,0,0,0,11,0,0,0,40,40,39,39,38,38,37,37,36,22,35,35,34,34,0,0},
{0,0,19,19,19,19,19,19,19,19,19,19,19,19,19,19,33,33,32,32,31,31,30,30,29,29,28,28,27,27,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
};

char color_pallet(struct rgb pixel) {
    if ((pixel.red == 0) && (pixel.green == 0) && (pixel.blue == 0)) {
        return 0; //check
    } else if ((pixel.red == 255) && (pixel.green == 255) && (pixel.blue == 255)) { 
        return 1; //check
    } else if ((pixel.red == 255) && (pixel.green == 21) && (pixel.blue == 55)) { 
        return 2; //check
    } else if ((pixel.red == 250) && (pixel.green == 0) && (pixel.blue == 0)) {
        return 3; //ehck
    } else if ((pixel.red == 0) && (pixel.green == 251) && (pixel.blue == 255)) {
        return 4; //check
    } else if ((pixel.red == 151) && (pixel.green == 0) && (pixel.blue == 0)) {
        return 5; //check
    } else if ((pixel.red == 255) && (pixel.green == 104) && (pixel.blue == 0)) {
        return 6; //check
    } else if ((pixel.red == 255) && (pixel.green == 184) && (pixel.blue == 85)) {
        return 7; //check
    } else if ((pixel.red == 0) && (pixel.green == 0) && (pixel.blue == 248)) {
        return 8; //check
    } else if ((pixel.red == 183) && (pixel.green == 0) && (pixel.blue == 0)) {
        return 9; //check 
    } else if ((pixel.red == 250) && (pixel.green == 79) && (pixel.blue == 242)) {
        return 10; //check
    } else {
        return 15;
    }
}

//ppm reading code, output format (4 bits or 32 bits for a whole row)

void ppm_reader(char *tile_row_codes, int tile, int row) {
    FILE *image = fopen("new_tileset.ppm", "rb");
	
    int header_skip = 14; //get past headers
    fseek(image, header_skip, SEEK_SET);
	
    int row_width = 64; //row width of the ppm file

    struct rgb pixel;

    fseek(image, (((tile % 8) * 8) + ((tile / 8) * 8 * row_width)) * 3, SEEK_CUR); //start at 0,0 (top left) of tile
    fseek(image, (row * row_width) * 3, SEEK_CUR); //go to row j of tile
    
    for (int i = 0; i < 8; ++i) { //load it so tile_row_codes looks like ff ff ff ff for example, with even codes on left part of byte and odd on right
        fread(&pixel, sizeof(struct rgb), 1, image);
	if (i % 2) {
	    tile_row_codes[i / 2] = tile_row_codes[i / 2] + color_pallet(pixel);
	} else {
	    tile_row_codes[i / 2] = (color_pallet(pixel) << 4);
	}
    }

    fclose(image);
}

//vga ball stuff
int vga_ball_fd;

/* send background tile data + address to ioctl to load it into ram */
void initialize_tile_array(vga_ball_tile_array_data_t *d, vga_ball_tile_array_address_t *a)
{
  vga_ball_arg_t vla;
  vla.data = *d;
  vla.address = *a;
  if (ioctl(vga_ball_fd, VGA_BALL_TILE_ARRAY, &vla)) {
      perror("ioctl(VGA_BALL_TILE_ARRAY) failed");
      return;
  }
}

void initialize_tile_map(char d, short a)
{
  vga_ball_arg2_t vla2;
  vla2.tile_map.data = d;
  vla2.tile_map.address = a;
  vla2.tile_map.blank = 0;
  
  if (ioctl(vga_ball_fd, VGA_BALL_TILE_MAP, &vla2)) {
      perror("ioctl(VGA_BALL_TILE_MAP) failed");
      return;
  }
}

int main()
{
  vga_ball_arg_t vla;
  int i;
  static const char filename[] = "/dev/vga_ball";
	
  printf("VGA ball Userspace program started\n");

  if ( (vga_ball_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  //
	
  //load tile array
  char *tile_row_codes = malloc(sizeof(char) * 4);	
  vga_ball_tile_array_data_t data_i;
  vga_ball_tile_array_address_t address_i;
  int tile;
  int row;
  for (unsigned int i = 0 ; i < 139 * 8 ; i++) {
    tile = i / 8;
    row = i % 8;
    ppm_reader(tile_row_codes, tile, row);
	  
    data_i.tile_row0 = tile_row_codes[0];
    data_i.tile_row1 = tile_row_codes[1];
    data_i.tile_row2 = tile_row_codes[2];
    data_i.tile_row3 = tile_row_codes[3];
    address_i.address = i;
	  
    initialize_tile_array(&data_i, &address_i);
    fprintf(stderr, "D: %x %x %x %x, A: %d\n", tile_row_codes[0], tile_row_codes[1], tile_row_codes[2], tile_row_codes[3], i);
    usleep(75000);
  }
	
  free(tile_row_codes);

  //load tile map
  vga_ball_tile_map_t tile_map_i;
  for (short i = 0 ; i < 32 * 32 ; i++) {
    tile_map_i.data = tile_map[i / 32][i % 32];
    tile_map_i.address = i;
    initialize_tile_map(tile_map_i.data, tile_map_i.address);
    fprintf(stderr, "D: %d, A: %d\n", tile_map[i / 32][i % 32], i);
    usleep(75000);
  }
  
  printf("VGA BALL Userspace program terminating\n");
  return 0;
}
