/*
 * Avalon memory-mapped peripheral that generates VGA
 *
 * Stephen A. Edwards
 * Columbia University
 */

          /*if (hcount[10:4] == 7'd0 && vcount[9:3] == 7'd0) begin
	            {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
	        end else if (hcount[10:4] == 7'd1 && vcount[9:3] == 7'd0) begin
	            {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h0, 8'h0};
          end else if (hcount[10:4] == 7'd0 && vcount[9:3] == 7'd1) begin
              {VGA_R, VGA_G, VGA_B} = {8'h0, 8'hff, 8'h0};
          end else begin
              {VGA_R, VGA_G, VGA_B} = {background_r, background_g, background_b};
          end*/

/*if (graphics_loaded == 1'b0) begin loading in background not working
        
            if (tile_array_address[10:0] == 11'd1111) begin
                //graphics_loaded <= 1'b1;
                array_write_en <= 1'b0;
		bg_map_address <= 10'b00101_00110; //tile 121 is at hcount tile 6 (00110), vcount tile 5 (00101)
        	//bg_array_address <= (bg_map_q << 3) + vcount[3:1];
        	bg_array_address <= (hcount[10:1] << 1); //testing just displaying something non black from tile array
	    end

	    if (tile_map[17:8] == 10'd1023) begin
                map_write_en <= 1'b0;
                bg_map_address <= 10'b00101_00110; //tile 121 is at hcount tile 6 (00110), vcount tile 5 (00101)
        	//bg_array_address <= (bg_map_q << 3) + vcount[3:1];
        	bg_array_address <= (hcount[10:1] << 1); //testing just displaying something non black from tile array
	    end
    end else begin
        map_write_en <= 1'b0;
	array_write_en <= 1'b0;
        bg_map_address <= 10'b00101_00110; //tile 121 is at hcount tile 6 (00110), vcount tile 5 (00101)
        //bg_array_address <= (bg_map_q << 3) + vcount[3:1];
        bg_array_address <= (hcount[10:1] << 1); //testing just displaying something non black from tile array
        
    end
    end*/


module vga_ball(input logic        clk,
	        input logic 	   reset,
		input logic [31:0]  writedata,
		input logic 	   write,
		input 		   chipselect,
		input logic [3:0]  address,

		output logic [7:0] VGA_R, VGA_G, VGA_B,
		output logic 	   VGA_CLK, VGA_HS, VGA_VS,
		                   VGA_BLANK_n,
		output logic 	   VGA_SYNC_n,

		input L_READY,
		input R_READY,

		output logic [15:0] L_SAMPLE_DATA,
		output logic [15:0] R_SAMPLE_DATA,
		output logic L_VALID,
		output logic R_VALID);


   logic [10:0]	   hcount;
   logic [9:0]     vcount;

   logic [5:0]    background_x;
   logic [5:0]    background_y;

   logic [10:0]	   X;
   logic [9:0]     Y;

   logic [7:0] 	   background_r, background_g, background_b;

   logic [23:0]    display_color;
   logic [3:0]     display_color_code;

   logic [5:0]     h_address;

   //graphics logic
   logic graphics_loaded;

   logic [31:0]   tile_array_data;
   logic [31:0]   tile_array_address;
   logic [31:0]   tile_map;

   logic [10:0]    bg_array_address;
   logic [7:0]     bg_map_q;
   logic [7:0][3:0]    bg_array_q;
   logic [9:0]     bg_map_address;

	logic [3:0] color_code_in;

   //sprites 
   logic[31:0] sprite_state, barrel_0, barrel_1, barrel_2, barrel_3, barrel_4;
	
   //logic array_write_en;
   //logic REN;
   //logic map_write_en;

   //logic [639:0][3:0] sprite_buf;

   logic BG_REN;
   logic [9:0] load_bg_region;
   logic [7:0] tile_map_x_component; //make it 5 bits later
   logic [4:0] tile_map_y_component;

   logic [319:0][3:0] bg_buf;
   logic [7:0] load_bg_tile;

    //// MARIO ////

    logic [11:0] mario_address;
    logic [9:0] mario_address_x;
    logic [9:0] mario_address_y;
    logic [3:0] mario_output;
	//   soc_system_mario_unit mario_unit(.address(mario_address[7:0]),.clk(clk),.clken(1),.reset_req(0),.readdata(mario_output));
    logic mario_en;

    logic [9:0] mario_x;
    logic [9:0] mario_y;
    logic [3:0] mario_n;
    logic mario_hammer_flip;


    ///////////////

    //// HAMMER ////

    logic [11:0] hammer_address;
    logic [9:0] hammer_address_x;
    logic [9:0] hammer_address_y;
    logic [3:0] hammer_output;
    logic hammer_en;

    logic hammer_n;

    ///////////////

    //// barrel 0 ///

    logic [9:0] barrel_0_address;
    logic [9:0] barrel_0_address_x;
    logic [9:0] barrel_0_address_y;
    logic [3:0] barrel_0_output;
    logic barrel_0_en;

    logic [15:0] barrel_0_x;
    logic [15:0] barrel_0_y;
    logic [1:0]  barrel_0_n;
    logic barrel_0_flip;

    //// barrel 1 ///

    logic [9:0] barrel_1_address;
    logic [9:0] barrel_1_address_x;
    logic [9:0] barrel_1_address_y;
    logic [3:0] barrel_1_output;
    logic barrel_1_en;

    logic [15:0] barrel_1_x;
    logic [15:0] barrel_1_y;
    logic [1:0]  barrel_1_n;
    logic barrel_1_flip;

    //// barrel 2 ///

    logic [9:0] barrel_2_address;
    logic [9:0] barrel_2_address_x;
    logic [9:0] barrel_2_address_y;
    logic [3:0] barrel_2_output;
    logic barrel_2_en;

    logic [15:0] barrel_2_x;
    logic [15:0] barrel_2_y;
    logic [1:0]  barrel_2_n;
    logic barrel_2_flip;

    //// barrel 3 ///

    logic [9:0] barrel_3_address;
    logic [9:0] barrel_3_address_x;
    logic [9:0] barrel_3_address_y;
    logic [3:0] barrel_3_output;
    logic barrel_3_en;

    logic [15:0] barrel_3_x;
    logic [15:0] barrel_3_y;
    logic [1:0]  barrel_3_n;
    logic barrel_3_flip;

    //// barrel 4 ///

    logic [9:0] barrel_4_address;
    logic [9:0] barrel_4_address_x;
    logic [9:0] barrel_4_address_y;
    logic [3:0] barrel_4_output;
    logic barrel_4_en;

    logic [15:0] barrel_4_x;
    logic [15:0] barrel_4_y;
    logic [1:0]  barrel_4_n;
    logic barrel_4_flip;

    ///////////////

    // mario_dir: // for reference based on tank implementation, should be updated for mario
    // 2'b0 --> up
    // 2'b1 --> down
    // 2'b2 --> left
    // 2'b3 --> right

    //// MARIO ////
      
    //assign mario_x = mario[31:16];
    //assign mario_y = mario[15:0];
    assign mario_n = sprite_state[4:1];
    assign mario_hammer_flip = sprite_state[0];

    assign mario_address_x = hcount[10:1] - mario_x;
    assign mario_address_y = vcount[9:0] - mario_y;

    // assign mario_address = mario_address_x[4:1] + (mario_address_y[4:1] << 4) + (mario_n << 8);
    // assign mario_en = hcount[10:1] >= mario_x && hcount[10:1] <= (mario_x + 16'd31) && vcount[9:0] >= mario_y && vcount[9:0] <= (mario_y + 10'd31);
    // assign mario_en = (mario_address_x[9:5] == 5'b0) && (mario_address_y[9:5] == 5'b0); //these bits non zero when they're not 0 < x < 32

    ///////////////

    //// HAMMER ////

    assign hammer_address_x = hcount[10:1] - mario_x[9:0] + 10'd48;
    assign hammer_address_y = vcount[9:0] - mario_y[9:0] + 10'd32;
    assign hammer_n = ~mario_n[0]; //horizontal hammer lines up with even mario sprites, vertical odd

    // assign hammer_address = hammer_address_x[6:1] + (hammer_address_y[5:1] << 6) + (mario_n << 11);
    assign hammer_en = ((4'd8 <= mario_n) && (4'd11 >= mario_n)) && (hammer_address_x[9:7] == 7'b0) && (hammer_address_y[9:6] == 6'b0); //these bits non zero when they're not 0 < x < 32

    ///////////////

    //// BARREL 0 ////
      
    assign barrel_0_x = barrel_0[31:16];
    assign barrel_0_y = barrel_0[15:0];
    assign barrel_0_n = sprite_state[6:5];
    assign barrel_0_flip = sprite_state[7];

    assign barrel_0_address_x = hcount[10:1] - barrel_0_x[9:0];
    assign barrel_0_address_y = vcount[9:0] - barrel_0_y[9:0];

    //assign barrel_0_address = barrel_0_address_x[4:1] + (barrel_0_address_y[4:1] << 4) + (barrel_0_n << 8);
    assign barrel_0_en = sprite_state[23] && (barrel_0_address_x[9:5] == 5'b0) && (barrel_0_address_y[9:5] == 5'b0);

    //// BARREL 1 ////
      
    assign barrel_1_x = barrel_1[31:16];
    assign barrel_1_y = barrel_1[15:0];
    assign barrel_1_n = sprite_state[9:8];
    assign barrel_1_flip = sprite_state[10];

    assign barrel_1_address_x = hcount[10:1] - barrel_1_x[9:0];
    assign barrel_1_address_y = vcount[9:0] - barrel_1_y[9:0];

    //assign barrel_1_address = barrel_1_address_x[4:1] + (barrel_1_address_y[4:1] << 4) + (barrel_1_n << 8);
    assign barrel_1_en = sprite_state[24] && (barrel_1_address_x[9:5] == 5'b0) && (barrel_1_address_y[9:5] == 5'b0);

    //// BARREL 2 ////
      
    assign barrel_2_x = barrel_2[31:16];
    assign barrel_2_y = barrel_2[15:0];
    assign barrel_2_n = sprite_state[12:11];
    assign barrel_2_flip = sprite_state[13];

    assign barrel_2_address_x = hcount[10:1] - barrel_2_x[9:0];
    assign barrel_2_address_y = vcount[9:0] - barrel_2_y[9:0];

    //assign barrel_2_address = barrel_2_address_x[4:1] + (barrel_2_address_y[4:1] << 4) + (barrel_2_n << 8);
    assign barrel_2_en = sprite_state[25] && (barrel_2_address_x[9:5] == 5'b0) && (barrel_2_address_y[9:5] == 5'b0);

    //// BARREL 3 ////
      
    assign barrel_3_x = barrel_3[31:16];
    assign barrel_3_y = barrel_3[15:0];
    assign barrel_3_n = sprite_state[15:14];
    assign barrel_3_flip = sprite_state[16];

    assign barrel_3_address_x = hcount[10:1] - barrel_3_x[9:0];
    assign barrel_3_address_y = vcount[9:0] - barrel_3_y[9:0];

    //assign barrel_3_address = barrel_3_address_x[4:1] + (barrel_3_address_y[4:1] << 4) + (barrel_3_n << 8);
    assign barrel_3_en = sprite_state[26] && (barrel_3_address_x[9:5] == 5'b0) && (barrel_3_address_y[9:5] == 5'b0);

    //// BARREL 4 ////
      
    assign barrel_4_x = barrel_4[31:16];
    assign barrel_4_y = barrel_4[15:0];
    assign barrel_4_n = sprite_state[18:17];
    assign barrel_4_flip = sprite_state[19];

    assign barrel_4_address_x = hcount[10:1] - barrel_4_x[9:0];
    assign barrel_4_address_y = vcount[9:0] - barrel_4_y[9:0];

    //assign barrel_4_address = barrel_4_address_x[4:1] + (barrel_4_address_y[4:1] << 4) + (barrel_4_n << 8);
    assign barrel_4_en = sprite_state[27] && (barrel_4_address_x[9:5] == 5'b0) && (barrel_4_address_y[9:5] == 5'b0);

    ///////////////

         ///////////////////End mario sprite stuff//////////////////////////////////////////////////////////////
    assign background_x = hcount[10:5] - 6'd4; //offset to centre it
    assign background_y = vcount[9:4]; //bottom 4 LSBs define height of background tile

    assign load_bg_region = hcount[10:1] - 10'd640;
    assign BG_REN = ~(load_bg_region[0] | load_bg_region[1]); //NOR, load from bg rams when both 0 (so 1 every 4 pixels)
    //assign tile_map_x_component = background_x[4:0];
    assign tile_map_y_component = background_y[4:0];
    assign bg_map_address = (tile_map_y_component << 5) + tile_map_x_component[4:0];
    assign bg_array_address = (bg_map_q << 3) + vcount[3:1];

    assign load_bg_tile = load_bg_region[9:2]; //set so load_bg_tile goes from 0 to 39 in a region 160 pixels wide
    assign tile_map_x_component = hcount[10:3] - 8'd160 - 8'd4; //it increments by 1 every 4 pixels since ignoring bottom two lsbs of hcount[10:1]

    //assign bg_address = (vcount[3:1] << 3) + hcount[4:2];s

    // assign bg_map_address = 11'b11110010000 + vcount[3:1];
  


   vga_counters counters(.clk50(clk), .*);

   always_ff @(posedge clk) begin
     if (reset) begin
	/*graphics_loaded <= 1'b0;
        array_write_en <= 1'b1;
        map_write_en <= 1'b1;
        bg_map_address <= tile_map[17:8]; //address is 10 bits for map
	bg_array_address <= tile_array_address[10:0]; //address is 11 bits for array*/
        bg_buf <= {320{4'h0}};
        // sprite_buf <= {640{4'hf}};
	//mario <= 32'b0000_0001_0001_0000___0000_0001_1011_0000;
        mario_x <= 10'b01_0001_0000;
        mario_y <= 10'b01_1011_0000;
	sprite_state <= 32'b0;
        barrel_0 <= 32'b0000_0000_1101_1000___0000_0000_1101_1000;
	barrel_1 <= 32'b0000_0000_0110_1100___0000_0000_0110_1100;
        barrel_2 <= 32'b0000_0000_0011_0110___0000_0000_0011_0110;
        barrel_3 <= 32'b0000_0000_0001_1011___0000_0000_0001_1011;
        barrel_4 <= 32'b0000_0000_0000_0101___0000_0000_0000_0101;
     end else if (chipselect && write) begin
       case (address)
	 4'h0 : tile_array_data <= writedata;
	 4'h1 : tile_array_address <= writedata;
	 4'h2 : tile_map <= writedata;
	 4'h3 : begin 
                    mario_x <= writedata[25:16]; //sprite
                    mario_y <= writedata[9:0];
                end
         4'h4 : sprite_state <= writedata; //sprite
         4'h5 : barrel_0 <= writedata;
	 4'h6 : barrel_1 <= writedata;
         4'h7 : barrel_2 <= writedata;
         4'h8 : barrel_3 <= writedata;
         4'h9 : barrel_4 <= writedata;

       endcase
    end
	   
//////////////////////////////////////SPRITE LOGIC START/////////////////////////////////////////////////////////////////////
	   
	//     if (hcount[10:1] >= mario_x && hcount[10:1] <= (mario_x + 16'd31) && vcount[9:0] >= mario_y && vcount[9:0] <= (mario_y + 10'd31) ) begin
        
        //mario_en <= 1'b1;
	
	//case(p1tank_dir)
		     // mario_address <= mario_address_x[4:1] + (mario_address_y[4:1] << 4); //neglect lsb so 1 pixel from rom is displayed over 2 by 2 pixels on the screen
	 //2'b00 : mario_address <= hcount[10:1] - mario_x + (vcount[9:0] - mario_y) * 32;
         //2'b01 : mario_address <= hcount[10:1] - mario_x + (vcount[9:0] - mario_y) * 32 + 1024;
         //2'b10 : mario_address <= hcount[10:1] - mario_x + (vcount[9:0] - mario_y) * 32 + 2048;
         //2'b11 : mario_address <= hcount[10:1] - mario_x + (vcount[9:0] - mario_y) * 32 + 3072;
	//endcase
      
      //end else begin
        //mario_en <= 1'b0;

      //end
/////////////////////////////////////SPRITE LOGIC END//////////////////////////////////////////////////////////////////////////////       
  
    if ((hcount[10:1] > 655) && (hcount[10:1] < 784)) begin
        if (BG_REN) begin
        bg_buf[((hcount[10:1] - 10'd656) * 2) + 10'd16] <= bg_array_q[7]; // + 10'd32
        bg_buf[((hcount[10:1] - 10'd656) * 2) + 10'd16 + 10'd1] <= bg_array_q[6];
        bg_buf[((hcount[10:1] - 10'd656) * 2) + 10'd16 + 10'd2] <= bg_array_q[5];
        bg_buf[((hcount[10:1] - 10'd656) * 2) + 10'd16 + 10'd3] <= bg_array_q[4];
        bg_buf[((hcount[10:1] - 10'd656) * 2) + 10'd16 + 10'd4] <= bg_array_q[3];
        bg_buf[((hcount[10:1] - 10'd656) * 2) + 10'd16 + 10'd5] <= bg_array_q[2];
        bg_buf[((hcount[10:1] - 10'd656) * 2) + 10'd16 + 10'd6] <= bg_array_q[1];
        bg_buf[((hcount[10:1] - 10'd656) * 2) + 10'd16 + 10'd7] <= bg_array_q[0];
        //$display("BG buf index: %d", ((hcount[10:1] - 10'd640) << 1) + 10'd32);
        end
    end   


    if (hcount[10:1] >= mario_x && hcount[10:1] <= (mario_x + 16'd31) && vcount[9:0] >= mario_y && vcount[9:0] <= (mario_y + 10'd31)) begin
        mario_en <= 1'b1;
    end else begin
        mario_en <= 1'b0;
    end

    if (mario_hammer_flip == 1) begin 
        mario_address <= (mario_address_y[4:1] << 4) + (mario_n << 8) + (4'hf - mario_address_x[4:1]);
        hammer_address <= (hammer_address_y[5:1] << 6) + (mario_n << 11) + (6'b111111 - hammer_address_x[6:1]);
    end else begin
        mario_address <= mario_address_x[4:1] + (mario_address_y[4:1] << 4) + (mario_n << 8);
        hammer_address <= hammer_address_x[6:1] + (hammer_address_y[5:1] << 6) + (mario_n << 11);
    end

    if (barrel_0_flip == 1) begin 
        barrel_0_address <= (4'hf - barrel_0_address_x[4:1]) + (barrel_0_address_y[4:1] << 4) + (barrel_0_n << 8);
    end else begin
        barrel_0_address <= barrel_0_address_x[4:1] + (barrel_0_address_y[4:1] << 4) + (barrel_0_n << 8);
    end

    if (barrel_1_flip == 1) begin 
        barrel_1_address <= (4'hf - barrel_1_address_x[4:1]) + (barrel_1_address_y[4:1] << 4) + (barrel_1_n << 8);
    end else begin
        barrel_1_address <= barrel_1_address_x[4:1] + (barrel_1_address_y[4:1] << 4) + (barrel_1_n << 8);
    end
   
    if (barrel_2_flip == 1) begin 
        barrel_2_address <= (4'hf - barrel_2_address_x[4:1]) + (barrel_2_address_y[4:1] << 4) + (barrel_2_n << 8);
    end else begin
        barrel_2_address <= barrel_2_address_x[4:1] + (barrel_2_address_y[4:1] << 4) + (barrel_2_n << 8);
    end

    if (barrel_3_flip == 1) begin 
        barrel_3_address <= (4'hf - barrel_3_address_x[4:1]) + (barrel_3_address_y[4:1] << 4) + (barrel_3_n << 8);
    end else begin
        barrel_3_address <= barrel_3_address_x[4:1] + (barrel_3_address_y[4:1] << 4) + (barrel_3_n << 8);
    end

    if (barrel_4_flip == 1) begin 
        barrel_4_address <= (4'hf - barrel_4_address_x[4:1]) + (barrel_4_address_y[4:1] << 4) + (barrel_4_n << 8);
    end else begin
        barrel_4_address <= barrel_4_address_x[4:1] + (barrel_4_address_y[4:1] << 4) + (barrel_4_n << 8);
    end


   end //always ff            




//choose between background and sprite
always_comb begin
    if (mario_en & (!(mario_output[3] & mario_output[2] & mario_output[1] & mario_output[0]))) begin
	color_code_in = mario_output[3:0];
    end else if (hammer_en & (!(hammer_output[3] & hammer_output[2] & hammer_output[1] & hammer_output[0]))) begin
	color_code_in = hammer_output[3:0];
    end else if (barrel_0_en & (!(barrel_0_output[3] & barrel_0_output[2] & barrel_0_output[1] & barrel_0_output[0]))) begin
	color_code_in = barrel_0_output[3:0];
    end else if (barrel_1_en & (!(barrel_1_output[3] & barrel_1_output[2] & barrel_1_output[1] & barrel_1_output[0]))) begin
	color_code_in = barrel_1_output[3:0];
    end else if (barrel_2_en & (!(barrel_2_output[3] & barrel_2_output[2] & barrel_2_output[1] & barrel_2_output[0]))) begin
	color_code_in = barrel_2_output[3:0];
    end else if (barrel_3_en & (!(barrel_3_output[3] & barrel_3_output[2] & barrel_3_output[1] & barrel_3_output[0]))) begin
	color_code_in = barrel_3_output[3:0];
    end else if (barrel_4_en & (!(barrel_4_output[3] & barrel_4_output[2] & barrel_4_output[1] & barrel_4_output[0]))) begin
	color_code_in = barrel_4_output[3:0];
    end else begin
	color_code_in = bg_buf[hcount[10:2]][3:0];
    end
end

    //sprite memory

    mario mario_ram(.address(mario_address), .clock(clk), .data(4'b0), .rden(mario_en), .wren(1'b0), .q(mario_output));
    hammer hammer_ram(.address(hammer_address), .clock(clk), .data(4'b0), .rden(hammer_en), .wren(1'b0), .q(hammer_output));
  
    //barrels
    barrel barrel_0_ram(.address(barrel_0_address), .clock(clk), .data(4'b0), .rden(barrel_0_en), .wren(1'b0), .q(barrel_0_output));
    barrel barrel_1_ram(.address(barrel_1_address), .clock(clk), .data(4'b0), .rden(barrel_1_en), .wren(1'b0), .q(barrel_1_output));
    barrel barrel_2_ram(.address(barrel_2_address), .clock(clk), .data(4'b0), .rden(barrel_2_en), .wren(1'b0), .q(barrel_2_output));
    barrel barrel_3_ram(.address(barrel_3_address), .clock(clk), .data(4'b0), .rden(barrel_3_en), .wren(1'b0), .q(barrel_3_output));
    barrel barrel_4_ram(.address(barrel_4_address), .clock(clk), .data(4'b0), .rden(barrel_4_en), .wren(1'b0), .q(barrel_4_output));
    
    //backgrounds
    tile_map bg_map_ram(.address(bg_map_address), .clock(clk), .data(tile_map[7:0]), .rden(BG_REN), .wren(1'b0), .q(bg_map_q));
    tile_array bg_array_ram(.address(bg_array_address), .clock(clk), .data(tile_array_data), .rden(BG_REN), .wren(1'b0), .q(bg_array_q));

    //H H_Highscore(.address(bg_address), .clock(clk), .q(display_color_code));
    sprite_color_pallette color_table(.color_code(color_code_in), .color(display_color));

    always_comb begin
        {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
        if (VGA_BLANK_n ) begin
	     {VGA_R, VGA_G, VGA_B} = display_color;
        end
   end
                  
  //   always_ff @(posedge clk) begin

  //  end //alwaysff end

	       
endmodule

module vga_counters(
 input logic 	     clk50, reset,
 output logic [10:0] hcount,  // hcount[10:1] is pixel column
 output logic [9:0]  vcount,  // vcount[9:0] is pixel row
 output logic 	     VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n);

/*
 * 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
 * 
 * HCOUNT 1599 0             1279       1599 0
 *             _______________              ________
 * ___________|    Video      |____________|  Video
 * 
 * 
 * |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
 *       _______________________      _____________
 * |____|       VGA_HS          |____|
 */
   // Parameters for hcount
   parameter HACTIVE      = 11'd 1280,
             HFRONT_PORCH = 11'd 32,
             HSYNC        = 11'd 192,
             HBACK_PORCH  = 11'd 96,   
             HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC +
                            HBACK_PORCH; // 1600
   
   // Parameters for vcount
   parameter VACTIVE      = 10'd 480,
             VFRONT_PORCH = 10'd 10,
             VSYNC        = 10'd 2,
             VBACK_PORCH  = 10'd 33,
             VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC +
                            VBACK_PORCH; // 525

   logic endOfLine;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (endOfLine) hcount <= 0;
     else  	         hcount <= hcount + 11'd 1;

   assign endOfLine = hcount == HTOTAL - 1;
       
   logic endOfField;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (endOfLine)
       if (endOfField)   vcount <= 0;
       else              vcount <= vcount + 10'd 1;

   assign endOfField = vcount == VTOTAL - 1;

   // Horizontal sync: from 0x520 to 0x5DF (0x57F)
   // 101 0010 0000 to 101 1101 1111
   assign VGA_HS = !( (hcount[10:8] == 3'b101) &
		      !(hcount[7:5] == 3'b111));
   assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);

   assign VGA_SYNC_n = 1'b0; // For putting sync on the green signal; unused
   
   // Horizontal active: 0 to 1279     Vertical active: 0 to 479
   // 101 0000 0000  1280	       01 1110 0000  480
   // 110 0011 1111  1599	       10 0000 1100  524
   assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
			!( vcount[9] | (vcount[8:5] == 4'b1111) );

   /* VGA_CLK is 25 MHz
    *             __    __    __
    * clk50    __|  |__|  |__|
    *        
    *             _____       __
    * hcount[0]__|     |_____|
    */
   assign VGA_CLK = hcount[0]; // 25 MHz clock: rising edge sensitive
   
endmodule
