
module sprite_color_pallette(
	input logic [3:0] 	color_code,
	output logic [23:0]	color
	);
	always_comb begin
		case(color_code)
			4'h0 : color = 24'h000000;
			4'h1 : color = 24'hffffff;
			4'h2 : color = 24'hff2155;
			4'h3 : color = 24'hfa0000;
			4'h4 : color = 24'h00fbff;
			4'h5 : color = 24'h970000;
			4'h6 : color = 24'hff6800;
			4'h7 : color = 24'hffb855;
			4'h8 : color = 24'h0000f8;
			4'h9 : color = 24'hb70000;
			4'ha : color = 24'hfa4ef2;
      //colors b-f unused so far
			4'hb : color = 24'h203090;
			4'hc : color = 24'h2040A0;
			4'hd : color = 24'h2060C0;
			4'he : color = 24'h2090E0;
			4'hf : color = 24'h64a460;
			default : color = 24'h000000;
		endcase
	end
endmodule
