#include <unistd.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>
#include "controller.h"
#include "bomberman.h"


int vga_fd;
game_info_t global_info;
player_info_t player0_info;
player_info_t player1_info;
control_info_t control_info;
uint16_t *map;
struct controller_list controllers;
struct args_list c_args_list;
short map_change_list[12];
int map_change_list_next;

struct Bomb *bombs_head;
struct Explosion *explosion_head;
void write_tile(uint16_t tile_pos, uint16_t tile_type, unsigned short *pos);
uint16_t p1_win_arr[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
uint16_t p2_win_arr[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
uint16_t tie_arr[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

void start_explosion_sound(void)
{
    global_info.reserved_0 = (unsigned short) 1;
    return;
}
void init_explosion_sound(void)
{
    global_info.reserved_0 = (unsigned short) 0;
    return;
}

int start_explosion(struct Bomb *bomb)
{
    if (map_change_list_next >= 12)
        return -1;
    start_explosion_sound();
    printf("Start explosion at %d\n", bomb->pos);
    map_change_list_append_tile(bomb->pos, 5);
    map[(bomb->pos)] = 5;
    struct Explosion *new = (struct Explosion *) malloc(sizeof(struct Explosion));
    new->stage = 0;
    new->range = bomb->range;
    int pos = bomb -> pos;
    printf("map[%d]=%d\n", pos, map[pos]);
    new->stage_time_left =  50 / ((bomb->range) + 2);
    for (int i = 0; i < 4; i ++)
        new->ends[i] = pos;
    if (explosion_head == NULL){
        new->next = NULL;
        explosion_head = new;
    }
    else{
        new->next = explosion_head;
        explosion_head = new;
    }
    return 0;
}

void free_explosion(void)
{
    struct Explosion *curr;
    while (curr) {
        struct Explosion *temp = curr->next;
        free(temp);
        curr = temp;
    }
}

int is_flame(uint16_t tile) {
    return ((tile >= 5) && (tile <= 7));
}

int is_flame_obstacle(uint16_t tile) {
    return ((tile > 0) && (tile < 4) && (tile != 2));
}


int can_expand_flame(int from, int to) {
    uint16_t from_tile = map[from];
    if (is_flame(from_tile))
        if (!is_flame_obstacle(map[to]))
            return 1;
    return 0;
}
/*Modify ends, hw, map*/
int expand_flame(int ends[])
{
    /*Get number of registers needed for the map change*/
    int needs_modify[4]; /*A structure to denote which end needs to be expanded*/
    printf("Start expanding flame, ends = [%d %d %d %d]\n", ends[0], ends[1], ends[2], ends[3]);
    for (int i = 0; i < 4; i++) {
        int pos = ends[i];
        printf("map[%d] = %d\n", pos, map[pos]);
        int pos_r = pos / 40;
        int pos_c = pos % 40;
        int to_r;
        int to_c;
        switch (i) {
            case 0:
                to_r = pos_r + 1;
                to_c = pos_c;
                break;
            case 1:
                to_r = pos_r;
                to_c = pos_c - 1;
                break;
            case 2:
                to_r = pos_r - 1;
                to_c = pos_c;
                break;
            case 3:
                to_r = pos_r;
                to_c = pos_c + 1;
                break;
        }
        if ((to_r >= 0 && to_r < 30) && (to_c >= 0 && to_c < 40)) {
            int to_pos = to_r * 40 + to_c;
            if (can_expand_flame(pos, to_pos))
                needs_modify[i] = 1;
            else
                needs_modify[i] = 0;
        } else {
            needs_modify[i] = 0;
        }
    }
    int num_reg_needed = 0;
    for (int i = 0; i < 4; i++)
        num_reg_needed += needs_modify[i];
    if (map_change_list_next + num_reg_needed > 12)
        return -1;
    printf("Needs modify [%d, %d, %d, %d]\n", needs_modify[0], needs_modify[1], needs_modify[2], needs_modify[3]);
    for (int i = 0; i < 4; i++) {
        if(needs_modify[i]) {
            int pos = ends[i];
            int pos_r = pos / 40;
            int pos_c = pos % 40;
            int to_r;
            int to_c;
            switch (i) {
                case 0:
                    to_r = pos_r + 1;
                    to_c = pos_c;
                    break;
                case 1:
                    to_r = pos_r;
                    to_c = pos_c - 1;
                    break;
                case 2:
                    to_r = pos_r - 1;
                    to_c = pos_c;
                    break;
                case 3:
                    to_r = pos_r;
                    to_c = pos_c + 1;
                    break;
            }
            uint16_t target_flame;
            if (i % 2 == 0)
                target_flame = 6;
            else
                target_flame = 7;
            int to_pos = to_r * 40 + to_c;
            uint16_t original_tile = map[to_pos];
            uint16_t target_tile;
            if (is_flame(original_tile)) {
                if (target_flame != original_tile)
                    target_tile = 5;
                else {
                    target_tile = target_flame;
                }

            }
            else if (original_tile == 2)
                target_tile = 4;
            else {
                target_tile = target_flame;
            }
            /*Change the hw*/
            map_change_list_append_tile(to_pos, target_tile);
            map[to_pos] = target_tile;
            ends[i] = to_pos;
            printf("Write flame to row %d col %d\n", to_r, to_c);
        }
    }

    return 0;
}

int shrink_flame(int ends[], int center) {
    /*get number of registers to change*/
    printf("Start shrinking flame, ends = [%d, %d, %d, %d]\n", ends[0], ends[1], ends[2], ends[3]);
    int needs_modify[4];
    for (int i = 0; i < 4; i ++) {
        if ((is_flame(map[ends[i]]) || map[ends[i]] == 4) && ends[i] != center)
            needs_modify[i] = 1;
        else if (ends[i] != center) {
            int pos = ends[i];
            int pos_r = pos / 40;
            int pos_c = pos % 40;
            int to_r;
            int to_c;
            switch (i) {
                case 0:
                    to_r = pos_r - 1;
                    to_c = pos_c;
                    break;
                case 1:
                    to_r = pos_r;
                    to_c = pos_c + 1;
                    break;
                case 2:
                    to_r = pos_r + 1;
                    to_c = pos_c;
                    break;
                case 3:
                    to_r = pos_r;
                    to_c = pos_c - 1;
                    break;
            }
            int to_pos = to_r * 40 + to_c;
            ends[i] = to_pos;
            needs_modify[i] = 0;
        }
        else {
            needs_modify[i] = 0;
        }
    }
    int num_reg_needed = 0;
    for (int i = 0; i < 4; i ++)
        num_reg_needed += needs_modify[i];
    if (map_change_list_next + num_reg_needed > 12)
        return -1;
    for (int i = 0; i < 4; i ++) {
        if (needs_modify[i]) {
            int pos = ends[i];
            int pos_r = pos / 40;
            int pos_c = pos % 40;
            int to_r;
            int to_c;
            switch (i) {
                case 0:
                    to_r = pos_r - 1;
                    to_c = pos_c;
                    break;
                case 1:
                    to_r = pos_r;
                    to_c = pos_c + 1;
                    break;
                case 2:
                    to_r = pos_r + 1;
                    to_c = pos_c;
                    break;
                case 3:
                    to_r = pos_r;
                    to_c = pos_c - 1;
                    break;
            }
            if (map[ends[i]] != 5) {
                if (map[ends[i]] != 4) {
                    map_change_list_append_tile(ends[i], (uint16_t) 0);
                    map[ends[i]] = 0;
                    printf("delete flame at %d\n", ends[i]);
                }
                else {
                    uint16_t prop_id = rand() % 10;
                    if (prop_id < 3) {
                        map_change_list_append_tile(ends[i], (uint16_t) prop_id + 8);
                        map[ends[i]] = prop_id + 8;
                        printf("place prop %d at %d\n", prop_id, ends[i]);
                    }
                    else {
                        map_change_list_append_tile(ends[i], (uint16_t) 0);
                        map[ends[i]] = 0;
                        printf("delete flame at %d\n", ends[i]);
                    }
                }
            }
            else {
                if((i % 2) == 0) {
                    map_change_list_append_tile(ends[i], (uint16_t) 7);
                    map[ends[i]] = 7;
                }
                else {
                    map_change_list_append_tile(ends[i], (uint16_t) 6);
                    map[ends[i]] = 6;
                }
            }
            int to_pos = to_r * 40 + to_c;
            ends[i] = to_pos;
        }
    }
    return 0;
}

void handle_explosion(void)
{
    struct Explosion *curr = explosion_head;
    struct Explosion *prev = explosion_head;
    while(curr){
        if(curr->stage_time_left <= 0){
            int stage = curr->stage;
            int range = (int) curr->range;
            printf("stage = %d, range = %d\n", stage, range);
            if (stage < range) {
                if (expand_flame(curr->ends)) {
                    printf("Warning: Need enough registers to do the flame expansion!\n");
                    continue;
                }
            }
            else if ((stage > range) && (stage <= range * 2)) {
                int center_c = curr->ends[0] % 40;
                int center_r = curr->ends[1] / 40;
                int center = center_r * 40 + center_c;
                if (shrink_flame(curr->ends, center)) {
                    printf("Warning: Need enough registers to do the flame shrink!\n");
                    continue;
                }
            }
            else if (stage > range * 2){
                int center_c = curr->ends[0] % 40;
                int center_r = curr->ends[1] / 40;
                int center = center_r * 40 + center_c;
                for (int i = 0; i < 4; i++) {
                    if (curr->ends[i] != center)
                        printf("Warning: explosion has not been shrinked to 1\n");
                }
                if (map_change_list_append_tile(center, (uint16_t) 0)) {
                    printf("Warning: Need enough registers to do the flame deletion!\n");
                    continue;
                }
                map[center] = 0;
                if (curr == explosion_head) {
                    explosion_head = curr->next;
                    free(curr);
                    curr = explosion_head;
                    continue;
                }
                else {
                    prev->next = curr->next;
                    free(curr);
                    curr = prev->next;
                    continue;
                }
            }
            
            curr->stage ++;
            curr->stage_time_left = 50 / (curr->range + 2);
            prev = curr;
            curr = curr->next;
        }
        else {
            curr->stage_time_left --;
            prev = curr;
            curr = curr->next;
        }
    }
}

void insert_bomb(enum PLAYER player, uint16_t pos) {
    struct Bomb *new = (struct Bomb *) malloc(sizeof(struct Bomb));
    new->time_left = 300;
    new->player = player;
    new->pos = pos;
    switch (player) {
        case PLAYER0:
            new->range = player0_info.bomb_range;
            break;
        case PLAYER1:
            new->range = player1_info.bomb_range;
            break;
    }
    if (bombs_head == NULL) {
        bombs_head = new;
        bombs_head->next = NULL; 
    }
    else {
        new->next = bombs_head;
        bombs_head = new;
    }
}

void player_get_prop(uint16_t pos, player_info_t *info) {
    if (map[pos] == 8) {
        if (!map_change_list_append_tile(pos, (uint16_t) 0)) {
            map[pos] = 0;
            if (info->max_bombs < 6) {
                info->max_bombs ++;
                info->bombs_left ++;
                info->bomb_colddown = 50;
            }
        }
    }
    else if (map[pos] == 9) {
        if (!map_change_list_append_tile(pos, (uint16_t) 0)) {
            map[pos] = 0;
            if (info->bomb_range < 5) {
                info->bomb_range ++;
            }
        }
    }
    else if (map[pos] == 10) {
        if (!map_change_list_append_tile(pos, (uint16_t) 0)) {
            map[pos] = 0;
            if (info->vspeed < 4) {
                info->vspeed ++;
            }
        }
    }
}
void handle_player_prop_get()
{
    uint16_t vpos[2];
    get_player_vpos(vpos, &player0_info);
    uint16_t pos[2];
    pos[0] = vpos[0] / 3;
    pos[1] = vpos[1] / 3;
    int xpos = (int) pos[0];
    int ypos = (int) pos[1];
    int blocktlx = (xpos - 6) / 16;
    int blocktly = (ypos - 6) / 16;
    player_get_prop(blocktly * 40 + blocktlx, &player0_info);
    int blocktrx = (xpos + 7) / 16;
    int blocktry = (ypos - 6) / 16;
    player_get_prop(blocktry * 40 + blocktrx, &player0_info);
    int blockblx = (xpos - 6) / 16;
    int blockbly = (ypos + 7) / 16;
    player_get_prop(blockbly * 40 + blockblx, &player0_info);
    int blockbrx = (xpos + 7) / 16;
    int blockbry = (ypos + 7) / 16;
    player_get_prop(blockbry * 40 + blockbrx, &player0_info);
    get_player_vpos(vpos, &player1_info);
    pos[0] = vpos[0] / 3;
    pos[1] = vpos[1] / 3;
    xpos = (int) pos[0];
    ypos = (int) pos[1];
    blocktlx = (xpos - 6) / 16;
    blocktly = (ypos - 6) / 16;
    player_get_prop(blocktly * 40 + blocktlx, &player1_info);
    blocktrx = (xpos + 7) / 16;
    blocktry = (ypos - 6) / 16;
    player_get_prop(blocktry * 40 + blocktrx, &player1_info);
    blockblx = (xpos - 6) / 16;
    blockbly = (ypos + 7) / 16;
    player_get_prop(blockbly * 40 + blockblx, &player1_info);
    blockbrx = (xpos + 7) / 16;
    blockbry = (ypos + 7) / 16;
    player_get_prop(blockbry * 40 + blockbrx, &player1_info);
}
void handle_bomb_explode(void) {
    struct Bomb *curr = bombs_head;
    struct Bomb *prev = bombs_head;
    while(curr) {
        curr->time_left --;
        if (curr->time_left <= 0) {
            if (curr == bombs_head) {
                if (start_explosion(curr)) {
                    prev = curr;
                    curr = curr->next;
                    continue;
                }
                bombs_head = curr->next;
                switch(curr->player) {
                    case PLAYER0:
                        player0_info.bombs_left ++;
                        break;
                    case PLAYER1:
                        player1_info.bombs_left ++;
                        break;
                }
                struct Bomb* temp = curr->next;
                free(curr);
                curr = temp;
            }
            else {
                if (start_explosion(curr)) {
                    prev = curr;
                    curr = curr->next;
                    continue;
                }
                prev->next = curr->next;
                switch(curr->player) {
                    case PLAYER0:
                        player0_info.bombs_left ++;
                        break;
                    case PLAYER1:
                        player1_info.bombs_left ++;
                        break;
                }
                struct Bomb *temp = curr->next;
                free(curr);
                curr = temp;
            }
        }
        else {
            prev = curr;
            curr = curr->next;
        }

    }
}

void free_bombs(void) {
    struct Bomb* curr = bombs_head;
    while(curr) {
        struct Bomb *temp = curr->next;
        free(curr);
        curr = temp;
    }
}

void reset_map_change_list(void) {
    memset((void *) map_change_list, 0, 12 * sizeof(short));
    map_change_list_next = 0;
}

void sync_hw_map_change() {
    memcpy(&global_info.map_change_0, &map_change_list[0], sizeof(short));
    memcpy(&global_info.map_change_1, &map_change_list[1], sizeof(short));
    memcpy(&global_info.map_change_2, &map_change_list[2], sizeof(short));
    memcpy(&global_info.map_change_3, &map_change_list[3], sizeof(short));
    memcpy(&global_info.map_change_4, &map_change_list[4], sizeof(short));
    memcpy(&global_info.map_change_5, &map_change_list[5], sizeof(short));
    memcpy(&global_info.map_change_6, &map_change_list[6], sizeof(short));
    memcpy(&global_info.map_change_7, &map_change_list[7], sizeof(short));
    memcpy(&global_info.map_change_8, &map_change_list[8], sizeof(short));
    memcpy(&global_info.map_change_9, &map_change_list[9], sizeof(short));
    memcpy(&global_info.map_change_10, &map_change_list[10], sizeof(short));
    memcpy(&global_info.map_change_11, &map_change_list[11], sizeof(short));
}
void display_game_over()
{
    if (player0_info.dead && !player1_info.dead) {
        uint16_t pos[2] = {21, 21};
        uint16_t pos2[2] = {21, 42};
        set_player_pos(pos, &player0_info);
        set_player_pos(pos2, &player1_info);
        for(int i = 0; i < 100; i++) {
            write_tile(i * 12, p2_win_arr[i * 12], &global_info.map_change_0);
            write_tile(i * 12 + 1, p2_win_arr[i * 12 + 1], &global_info.map_change_1);
            write_tile(i * 12 + 2, p2_win_arr[i * 12 + 2], &global_info.map_change_2);
            write_tile(i * 12 + 3, p2_win_arr[i * 12 + 3], &global_info.map_change_3);
            write_tile(i * 12 + 4, p2_win_arr[i * 12 + 4], &global_info.map_change_4);
            write_tile(i * 12 + 5, p2_win_arr[i * 12 + 5], &global_info.map_change_5);
            write_tile(i * 12 + 6, p2_win_arr[i * 12 + 6], &global_info.map_change_6);
            write_tile(i * 12 + 7, p2_win_arr[i * 12 + 7], &global_info.map_change_7);
            write_tile(i * 12 + 8, p2_win_arr[i * 12 + 8], &global_info.map_change_8);
            write_tile(i * 12 + 9, p2_win_arr[i * 12 + 9], &global_info.map_change_9);
            write_tile(i * 12 + 10, p2_win_arr[i * 12 + 10], &global_info.map_change_10);
            write_tile(i * 12 + 11, p2_win_arr[i * 12 + 11], &global_info.map_change_11);
            write_player_info();
            pass_game_info();
            usleep(2000);
        }
        printf("player1 wins!\n");
    }
    else if (player1_info.dead && !player0_info.dead){
        uint16_t pos[2] = {21, 21};
        uint16_t pos2[2] = {21, 42};
        set_player_pos(pos, &player0_info);
        set_player_pos(pos2, &player1_info);
        for(int i = 0; i < 100; i++) {
            write_tile(i * 12, p1_win_arr[i * 12], &global_info.map_change_0);
            write_tile(i * 12 + 1, p1_win_arr[i * 12 + 1], &global_info.map_change_1);
            write_tile(i * 12 + 2, p1_win_arr[i * 12 + 2], &global_info.map_change_2);
            write_tile(i * 12 + 3, p1_win_arr[i * 12 + 3], &global_info.map_change_3);
            write_tile(i * 12 + 4, p1_win_arr[i * 12 + 4], &global_info.map_change_4);
            write_tile(i * 12 + 5, p1_win_arr[i * 12 + 5], &global_info.map_change_5);
            write_tile(i * 12 + 6, p1_win_arr[i * 12 + 6], &global_info.map_change_6);
            write_tile(i * 12 + 7, p1_win_arr[i * 12 + 7], &global_info.map_change_7);
            write_tile(i * 12 + 8, p1_win_arr[i * 12 + 8], &global_info.map_change_8);
            write_tile(i * 12 + 9, p1_win_arr[i * 12 + 9], &global_info.map_change_9);
            write_tile(i * 12 + 10, p1_win_arr[i * 12 + 10], &global_info.map_change_10);
            write_tile(i * 12 + 11, p1_win_arr[i * 12 + 11], &global_info.map_change_11);
            write_player_info();
            pass_game_info();
            usleep(2000);
        }
        printf("player0_wins!\n");
    }
    else {
        uint16_t pos[2] = {21, 21};
        uint16_t pos2[2] = {21, 42};
        set_player_pos(pos, &player0_info);
        set_player_pos(pos2, &player1_info);
        for(int i = 0; i < 100; i++) {
            write_tile(i * 12, tie_arr[i * 12], &global_info.map_change_0);
            write_tile(i * 12 + 1, tie_arr[i * 12 + 1], &global_info.map_change_1);
            write_tile(i * 12 + 2, tie_arr[i * 12 + 2], &global_info.map_change_2);
            write_tile(i * 12 + 3, tie_arr[i * 12 + 3], &global_info.map_change_3);
            write_tile(i * 12 + 4, tie_arr[i * 12 + 4], &global_info.map_change_4);
            write_tile(i * 12 + 5, tie_arr[i * 12 + 5], &global_info.map_change_5);
            write_tile(i * 12 + 6, tie_arr[i * 12 + 6], &global_info.map_change_6);
            write_tile(i * 12 + 7, tie_arr[i * 12 + 7], &global_info.map_change_7);
            write_tile(i * 12 + 8, tie_arr[i * 12 + 8], &global_info.map_change_8);
            write_tile(i * 12 + 9, tie_arr[i * 12 + 9], &global_info.map_change_9);
            write_tile(i * 12 + 10, tie_arr[i * 12 + 10], &global_info.map_change_10);
            write_tile(i * 12 + 11, tie_arr[i * 12 + 11], &global_info.map_change_11);
            write_player_info();
            pass_game_info();
            usleep(2000);
        }
        printf("It's a tie!\n");
    }
}
void set_player_status (uint16_t vxpos, uint16_t vypos, enum FACING facing, enum STAT status, enum POSE pose, uint16_t pos_tick, uint16_t vspeed, uint16_t bomb_range, uint16_t max_bombs, uint16_t bombs_left, uint16_t bomb_colddown, uint16_t dead, enum PLAYER player)
{
    player_info_t *target_info;
    if (player == PLAYER0)
        target_info = &player0_info;
    else
        target_info = &player1_info;
    target_info->vxpos = vxpos;
    target_info->vypos = vypos;
    target_info->facing = facing;
    target_info->status = status;
    target_info->pose = pose;
    target_info->pos_tick = pos_tick;
    target_info->vspeed = vspeed;
    target_info->bomb_range = bomb_range;
    target_info->max_bombs = max_bombs;
    target_info->bombs_left = bombs_left;
    target_info->bomb_colddown = bomb_colddown;
    target_info->dead = dead;
}

void init_players()
{
    set_player_status (PLAYER0_INIT_X * 3, PLAYER0_INIT_Y * 3, DOWN, STATIC, IDLE, 0, 1, 1, 1, 1, 0, 0, PLAYER0);
    set_player_status (PLAYER1_INIT_X * 3, PLAYER1_INIT_Y * 3, DOWN, STATIC, IDLE, 0, 1, 1, 1, 1, 0, 0, PLAYER1);
}


void write_player_info()
{
    uint16_t pos = 0;
    global_info.playerinfo00 = player0_info.vxpos / 3;
    if (player0_info.status == MOVING)
        SET_BIT(global_info.playerinfo00, 10);
    if (player0_info.pose == SIDE1 || player0_info.pose == DOWN1 || player0_info.pose == UP1)
            pos = 1;
    else if (player0_info.pose == SIDE2)
            pos = 2;
    SET_BITS(global_info.playerinfo00, 11, pos);
    global_info.playerinfo01 = player0_info.vypos / 3;
    SET_BITS(global_info.playerinfo01, 9, player0_info.facing);


    global_info.playerinfo10 = player1_info.vxpos / 3;
    if (player1_info.status == MOVING)
        SET_BIT(global_info.playerinfo10, 10);
    pos = 0;
    if (player1_info.pose == SIDE1 || player1_info.pose == DOWN1 || player1_info.pose == UP1)
            pos = 1;
    else if (player1_info.pose == SIDE2)
            pos = 2;
    SET_BITS(global_info.playerinfo10, 11, pos);
    global_info.playerinfo11 = player1_info.vypos / 3;
    SET_BITS(global_info.playerinfo11, 9, player1_info.facing);
}

void write_tile(uint16_t tile_pos, uint16_t tile_type, unsigned short *pos)
{
    *pos = tile_pos;
    SET_BITS(*pos, 11, tile_type);
    SET_BIT(*pos, 15);
}

void pass_game_info()
{
    vga_ball_arg_t vla;
    vla.background = global_info;
    if (ioctl(vga_fd, VGA_BALL_WRITE_BACKGROUND, &vla)) {
        perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
        return;
    }
}

uint16_t manhattan_distance(uint16_t x_0, uint16_t y_0, uint16_t x_1, uint16_t y_1)
{
    uint16_t x_diff;
    if (x_0 < x_1)
        x_diff = x_1 - x_0;
    else
        x_diff = x_0 - x_1;
    uint16_t y_diff;
    if (y_0 < y_1)
        y_diff = y_1 - y_0;
    else
        y_diff = y_0 - y_1;
    return x_diff + y_diff;

}

uint16_t is_obstacle(uint16_t tile)
{
    return ((tile > 0) && (tile < 8));
}

void generate_software_map()
{
    time_t t;
    srand((unsigned) time(&t));
    write_player_info();
    pass_game_info();
    map = (uint16_t *) malloc (MAP_SIZE * sizeof(uint16_t));
    uint16_t row_p0 = 10;
    uint16_t col_p0 = 10;
    uint16_t row_p1 = 20;
    uint16_t col_p1 = 30;
    for (uint16_t i = 0; i < MAP_SIZE; i ++) {
        uint16_t row = i / 40;
        uint16_t col = i % 40;
        if (row % 2 == 1 && col % 2 == 1) {
            map[i] = 1;
            continue;
        }
        if (rand() % 10 < 2 && manhattan_distance(row, col, row_p0, col_p0) > 10 && manhattan_distance(row, col, row_p1, col_p1) > 10) {
            map[i] = 2;
            continue;
        }
        map[i] = 0;
    }
    for (int i = 0; i < 100; i++) {
        write_tile(i * 12, map[i * 12], &global_info.map_change_0);
        write_tile(i * 12 + 1, map[i * 12 + 1], &global_info.map_change_1);
        write_tile(i * 12 + 2, map[i * 12 + 2], &global_info.map_change_2);
        write_tile(i * 12 + 3, map[i * 12 + 3], &global_info.map_change_3);
        write_tile(i * 12 + 4, map[i * 12 + 4], &global_info.map_change_4);
        write_tile(i * 12 + 5, map[i * 12 + 5], &global_info.map_change_5);
        write_tile(i * 12 + 6, map[i * 12 + 6], &global_info.map_change_6);
        write_tile(i * 12 + 7, map[i * 12 + 7], &global_info.map_change_7);
        write_tile(i * 12 + 8, map[i * 12 + 8], &global_info.map_change_8);
        write_tile(i * 12 + 9, map[i * 12 + 9], &global_info.map_change_9);
        write_tile(i * 12 + 10, map[i * 12 + 10], &global_info.map_change_10);
        write_tile(i * 12 + 11, map[i * 12 + 11], &global_info.map_change_11);
        pass_game_info();
        usleep(2000);
    }
}

int is_player_moving(player_info_t *info)
{
    if (info -> status == STATIC)
        return 0;
    else
        return 1;
}

enum FACING get_player_facing(player_info_t *info)
{
    return info -> facing; 
}

void get_player_vpos(uint16_t *pos, player_info_t *info)
{
    pos[0] = info -> vxpos;
    pos[1] = info -> vypos;
}

uint16_t get_player_vspeed(player_info_t *info)
{
    return info -> vspeed;
}

void set_player_moving (int moving, player_info_t *info)
{
    if (moving)
        info -> status = MOVING;
    else
        info -> status = STATIC;
}

void set_player_pos (uint16_t *pos, player_info_t *info)
{
    info -> vxpos = pos[0];
    info -> vypos = pos[1];
}

void set_player_sprite(enum POSE pos, player_info_t *info)
{
    info -> pose = pos;
}

void set_player_facing(enum FACING facing, player_info_t *info)
{
    info -> facing = facing;
}

int detect_static_flame_collision(uint16_t *pos) {
    int xpos = (int) pos[0];
    int ypos = (int) pos[1];
    int blocktlx = (xpos - 6) / 16;
    int blocktly = (ypos - 6) / 16;
    int blocktrx = (xpos + 7) / 16;
    int blocktry = (ypos - 6) / 16;
    int blockblx = (xpos - 6) / 16;
    int blockbly = (ypos + 7) / 16;
    int blockbrx = (xpos + 7) / 16;
    int blockbry = (ypos + 7) / 16;
    uint16_t tile_tl = map[blocktly * 40 + blocktlx];
    uint16_t tile_tr = map[blocktry * 40 + blocktrx];
    uint16_t tile_bl = map[blockbly * 40 + blockblx];
    uint16_t tile_br = map[blockbry * 40 + blockbrx];
    return (is_flame(tile_tl) || is_flame(tile_tr) || is_flame(tile_br) || is_flame(tile_bl));
}
void handle_player_movement()
{
    uint16_t player0_curr_vpos[2];
    uint16_t player1_curr_vpos[2];
    uint16_t player0_attempt_vpos[2];
    uint16_t player1_attempt_vpos[2];
    get_player_vpos(player0_curr_vpos, &player0_info);
    get_player_vpos(player1_curr_vpos, &player1_info);
    memcpy((void *) player0_attempt_vpos, (void *) player0_curr_vpos, 2 * sizeof(uint16_t));
    memcpy((void *) player1_attempt_vpos, (void *) player1_curr_vpos, 2 * sizeof(uint16_t));
    if (control_info.direction0 == get_player_facing(&player0_info) && control_info.press_tick0 > 10 && control_info.idle0 == 0) {
        uint16_t player0_vs = get_player_vspeed(&player0_info);
        switch (control_info.direction0) {
            case DOWN:
                player0_attempt_vpos[1] += player0_vs;
                break;
            case LEFT:
                player0_attempt_vpos[0] -= player0_vs;
                break;
            case UP:
                player0_attempt_vpos[1] -= player0_vs;
                break;
            case RIGHT:
                player0_attempt_vpos[0] += player0_vs;
                break;
        }
        uint16_t player0_attempt_xpos = player0_attempt_vpos[0] / 3;
        uint16_t player0_attempt_ypos = player0_attempt_vpos[1] / 3;
        int num_corner = 0;
        int fit = 0;
        int blocktlx = (player0_attempt_xpos - 6) / 16;
        int blocktly = (player0_attempt_ypos - 6) / 16;
        if (is_obstacle(map[blocktly * 40 + blocktlx])){
            if (is_flame(map[blocktly * 40 + blocktlx]))
                player0_info.dead = 1;
            num_corner++;
            if (get_player_facing(&player0_info) == LEFT){
                fit = 0; //move down
            }
            else{
                fit = 1; //move right
            }   
        }
        
        int blocktrx = (player0_attempt_xpos + 7) / 16;
        int blocktry = (player0_attempt_ypos - 6) / 16;
        if (is_obstacle(map[blocktry * 40 + blocktrx])){
            if (is_flame(map[blocktry * 40 + blocktrx]))
                player0_info.dead = 1;
            num_corner++;
            if (get_player_facing(&player0_info) == RIGHT){
                fit = 0; //move down
            }
            else{
                fit = 2; //move left
            }   
        }

        int blockblx = (player0_attempt_xpos - 6) / 16;
        int blockbly = (player0_attempt_ypos + 7) / 16;
        if (is_obstacle(map[blockbly * 40 + blockblx])){
            if (is_flame(map[blockbly * 40 + blockblx]))
                player0_info.dead = 1;
            num_corner++;
            if (get_player_facing(&player0_info) == LEFT){
                fit = 3; //move up
            }
            else{
                fit = 1; //move right
            }   
        }

        int blockbrx = (player0_attempt_xpos + 7) / 16;
        int blockbry = (player0_attempt_ypos + 7) / 16;
        if (is_obstacle(map[blockbry * 40 + blockbrx])){
            if (is_flame(map[blockbry * 40 + blockbrx]))
                player0_info.dead = 1;
            num_corner++;
            if (get_player_facing(&player0_info) == RIGHT){
                fit = 3; //move up
            }
            else{
                fit = 2; //move left
            } 
        }
        if (num_corner == 1){
            memcpy((void *) player0_attempt_vpos, (void *) player0_curr_vpos, 2 * sizeof(uint16_t));
            switch(fit){
                case 0:
                    player0_attempt_vpos[1] += 1;
                    break;
                case 1:
                    player0_attempt_vpos[0] += 1;
                    break;
                case 2:
                    player0_attempt_vpos[0] -= 1;
                    break;
                case 3:
                    player0_attempt_vpos[1] -= 1;
                    break;
            }
        }
        if (num_corner > 1){
            memcpy((void *) player0_attempt_vpos, (void *) player0_curr_vpos, 2 * sizeof(uint16_t));
        }
        if (player0_attempt_xpos > PLAYER_X_UPPER_LIM || player0_attempt_xpos < PLAYER_X_LOWER_LIM || player0_attempt_ypos > PLAYER_Y_UPPER_LIM || player0_attempt_ypos < PLAYER_Y_LOWER_LIM)
            memcpy((void *) player0_attempt_vpos, (void *) player0_curr_vpos, 2 * sizeof(uint16_t));
        if (abs_diff(player0_attempt_xpos, player1_curr_vpos[0] / 3) < 16 && abs_diff(player0_attempt_ypos, player1_curr_vpos[1] / 3) < 16)
            memcpy((void *) player0_attempt_vpos, (void *) player0_curr_vpos, 2 * sizeof(uint16_t));
        set_player_pos(player0_attempt_vpos, &player0_info);
        printf("player0_attempt_vpos = (%d, %d)\n", player0_attempt_xpos, player0_attempt_ypos);
        set_player_moving(1, &player0_info);
        /*Determine the pose*/
        uint16_t pos_tick = ++ player0_info.pos_tick;
        if (pos_tick > 1000)
            pos_tick = 0;
        player0_info.pos_tick = pos_tick;
        enum POSE pos;
        switch (control_info.direction0) {
            case DOWN:
                if ((pos_tick / 20) % 2 == 1) pos = DOWN1;
                else pos = DOWN0;
                break;
            case LEFT:
                if ((pos_tick / 20) % 3 == 1) pos = SIDE1;
                else if (((pos_tick / 20) % 3 == 2)) pos = SIDE2;
                else pos = SIDE0;
                break;
            case UP:
                if ((pos_tick / 20) % 2 == 1) pos = UP1;
                else pos = UP0;
                break;
            case RIGHT:
                if ((pos_tick / 20) % 3 == 1) pos = SIDE1;
                else if (((pos_tick / 20) % 3 == 2)) pos = SIDE2;
                else pos = SIDE0;
                break;
        }
        set_player_sprite(pos, &player0_info);

        
    }
    else {
        /*Turn*/
        uint16_t player0_vpos[2];
        uint16_t player0_pos[2];
        get_player_vpos(player0_vpos, &player0_info);
        player0_pos[0] = player0_vpos[0] / 3;
        player0_pos[1] = player0_vpos[1] / 3;
        if (detect_static_flame_collision(player0_pos))
            player0_info.dead = 1;
        set_player_facing(control_info.direction0, &player0_info);
        set_player_moving(0, &player0_info);
        player0_info.pos_tick = 0;
        set_player_sprite(IDLE, &player0_info);
    }
    /*Update p0 pos*/
    get_player_vpos(player0_curr_vpos, &player0_info);

    /*Player1*/
    if (control_info.direction1 == get_player_facing(&player1_info) && control_info.press_tick1 > 10 && control_info.idle1 == 0) {
        uint16_t player1_vs = get_player_vspeed(&player1_info);
        switch (control_info.direction1) {
            case DOWN:
                player1_attempt_vpos[1] += player1_vs;
                break;
            case LEFT:
                player1_attempt_vpos[0] -= player1_vs;
                break;
            case UP:
                player1_attempt_vpos[1] -= player1_vs;
                break;
            case RIGHT:
                player1_attempt_vpos[0] += player1_vs;
                break;
        }

        uint16_t player1_attempt_xpos = player1_attempt_vpos[0] / 3;
        uint16_t player1_attempt_ypos = player1_attempt_vpos[1] / 3;

        int num_corner = 0;
        int fit = 0;
        int blocktlx = (player1_attempt_xpos - 6) / 16;
        int blocktly = (player1_attempt_ypos - 6) / 16;
        if (is_obstacle(map[blocktly * 40 + blocktlx])){
            if (is_flame(map[blocktly * 40 + blocktlx]))
                player1_info.dead = 1;
            num_corner++;
            if (get_player_facing(&player1_info) == LEFT){
                fit = 0; //move down
            }
            else{
                fit = 1; //move right
            }   
        }
        
        int blocktrx = (player1_attempt_xpos + 7) / 16;
        int blocktry = (player1_attempt_ypos - 6) / 16;
        if (is_obstacle(map[blocktry * 40 + blocktrx])){
            if (is_flame(map[blocktry * 40 + blocktrx]))
                player1_info.dead = 1;
            num_corner++;
            if (get_player_facing(&player1_info) == RIGHT){
                fit = 0; //move down
            }
            else{
                fit = 2; //move left
            }   
        }

        int blockblx = (player1_attempt_xpos - 6) / 16;
        int blockbly = (player1_attempt_ypos + 7) / 16;
        if (is_obstacle(map[blockbly * 40 + blockblx])){
            if (is_flame(map[blockbly * 40 + blockblx]))
                player1_info.dead = 1;
            num_corner++;
            if (get_player_facing(&player1_info) == LEFT){
                fit = 3; //move up
            }
            else{
                fit = 1; //move right
            }   
        }

        int blockbrx = (player1_attempt_xpos + 7) / 16;
        int blockbry = (player1_attempt_ypos + 7) / 16;
        if (is_obstacle(map[blockbry * 40 + blockbrx])){
            if (is_flame(map[blockbry * 40 + blockbrx]))
                player1_info.dead = 1;
            num_corner++;
            if (get_player_facing(&player1_info) == RIGHT){
                fit = 3; //move up
            }
            else{
                fit = 2; //move left
            } 
        }
        if (num_corner == 1){
            memcpy((void *) player1_attempt_vpos, (void *) player1_curr_vpos, 2 * sizeof(uint16_t));
            switch(fit){
                case 0:
                    player1_attempt_vpos[1] += 1;
                    break;
                case 1:
                    player1_attempt_vpos[0] += 1;
                    break;
                case 2:
                    player1_attempt_vpos[0] -= 1;
                    break;
                case 3:
                    player1_attempt_vpos[1] -= 1;
                    break;
            }
        }
        if (num_corner > 1){
            memcpy((void *) player1_attempt_vpos, (void *) player1_curr_vpos, 2 * sizeof(uint16_t));
        }
        if (player1_attempt_xpos > PLAYER_X_UPPER_LIM || player1_attempt_xpos < PLAYER_X_LOWER_LIM || player1_attempt_ypos > PLAYER_Y_UPPER_LIM || player1_attempt_ypos < PLAYER_Y_LOWER_LIM)
            memcpy((void *) player1_attempt_vpos, (void *) player1_curr_vpos, 2 * sizeof(uint16_t));
        if ((abs_diff(player1_attempt_xpos, (player0_curr_vpos[0] / (uint16_t) 3)) < (uint16_t) 16) && (abs_diff(player1_attempt_ypos, (player0_curr_vpos[1] / (uint16_t) 3)) < (uint16_t) 16))
            memcpy((void *) player1_attempt_vpos, (void *) player1_curr_vpos, 2 * sizeof(uint16_t));
        set_player_pos(player1_attempt_vpos, &player1_info);
        printf("player1_attempt_vpos = (%d, %d)\n", player1_attempt_xpos, player1_attempt_ypos);
        set_player_moving(1, &player1_info);
        /*Determine the pose*/
        uint16_t pos_tick = ++ player1_info.pos_tick;
        if (pos_tick > 1000)
            pos_tick = 0;
        player1_info.pos_tick = pos_tick;
        enum POSE pos;
        switch (control_info.direction1) {
            case DOWN:
                if ((pos_tick / 20) % 2 == 1) pos = DOWN1;
                else pos = DOWN0;
                break;
            case LEFT:
                if ((pos_tick / 20) % 3 == 1) pos = SIDE1;
                else if (((pos_tick / 20) % 3 == 2)) pos = SIDE2;
                else pos = SIDE0;
                break;
            case UP:
                if ((pos_tick / 20) % 2 == 1) pos = UP1;
                else pos = UP0;
                break;
            case RIGHT:
                if ((pos_tick / 20) % 3 == 1) pos = SIDE1;
                else if (((pos_tick / 20) % 3 == 2)) pos = SIDE2;
                else pos = SIDE0;
                break;
        }
        set_player_sprite(pos, &player1_info);

        
    }
    else {
        uint16_t player1_vpos[2];
        uint16_t player1_pos[2];
        get_player_vpos(player1_vpos, &player1_info);
        player1_pos[0] = player1_vpos[0] / 3;
        player1_pos[1] = player1_vpos[1] / 3;
        if (detect_static_flame_collision(player1_pos))
            player1_info.dead = 1;
        /*Turn*/
        set_player_facing(control_info.direction1, &player1_info);
        set_player_moving(0, &player1_info);
        player1_info.pos_tick = 0;
        set_player_sprite(IDLE, &player1_info);
    }

}

int can_player_place_bomb(player_info_t *info) {
    return (info->bomb_colddown == 0) && (info->bombs_left > 0);
}
/*Change the memory*/
int map_change_list_append_tile(uint16_t pos, uint16_t tile)
{
    if (map_change_list_next >= 12)
        return -1;
    else {
        write_tile(pos, tile, &map_change_list[map_change_list_next]);
        map_change_list_next ++;
        return 0;
    }
}


void handle_player_place_bomb ()
{
    int can_player0_place_bomb = can_player_place_bomb(&player0_info);
    if (control_info.attempt_place_bomb_0 || control_info.attempt_place_bomb_1) {
        printf("Player 0: bombs left %d, bomb colddown %d\n", player0_info.bombs_left, player0_info.bomb_colddown);
        printf("Player 1: bombs left %d, bomb colddown %d\n", player1_info.bombs_left, player1_info.bomb_colddown);
    }
    if (can_player0_place_bomb && control_info.attempt_place_bomb_0) {
        enum FACING facing = get_player_facing(&player0_info);
        uint16_t curr_vpos[2];
        get_player_vpos(curr_vpos, &player0_info);
        int player_x = (int) curr_vpos[0] / 3;
        int player_y = (int) curr_vpos[1] / 3;
        int attempt_pos_r;
        int attempt_pos_c;
        int player_r = player_y / 16;
        int player_c = player_x / 16;
        switch (facing) {
            case DOWN:
                attempt_pos_r = player_r + 1;
                attempt_pos_c = player_c;
                break;
            case LEFT:
                attempt_pos_r = player_r;
                attempt_pos_c = player_c - 1;
                break;
            case UP:
                attempt_pos_r = player_r - 1;
                attempt_pos_c = player_c;
                break;
            case RIGHT:
                attempt_pos_r = player_r;
                attempt_pos_c = player_c + 1;
                break;
        }
        if (attempt_pos_r >= 0 && attempt_pos_r < 30 && attempt_pos_c >= 0 && attempt_pos_c < 40) {

            int attempt_center_x = attempt_pos_c * 16 + 7;
            int attempt_center_y = attempt_pos_r * 16 + 7;
            int md = abs_diff(player_x, attempt_center_x) + abs_diff(player_y, attempt_center_y);
            int attempt_pos = attempt_pos_c + attempt_pos_r * 40;
            if (map[attempt_pos] == 0 && md > 12) {
                if (map[attempt_pos] == 0) {
                    if (map_change_list_append_tile((uint16_t) attempt_pos, (uint16_t) 3) == 0) {
                        map[attempt_pos] = 3;
                        if (md <= 16) {
                            uint16_t player_next_vpos[2];
                            player_next_vpos[0] = (uint16_t) (player_c * 16 + 8)* 3;
                            player_next_vpos[1] = (uint16_t) (player_r * 16 + 8)* 3;
                            set_player_pos(player_next_vpos, &player0_info);
                        } 
                        insert_bomb(PLAYER0, attempt_pos);
                        player0_info.bombs_left --;
                        player0_info.bomb_colddown = 50;
                    }
                }
            }
        }
    }
    else {
        if (player0_info.bomb_colddown > 0)
            player0_info.bomb_colddown --;
    }
    int can_player1_place_bomb = can_player_place_bomb(&player1_info);
    if (can_player1_place_bomb && control_info.attempt_place_bomb_1) {
        enum FACING facing = get_player_facing(&player1_info);
        uint16_t curr_vpos[2];
        get_player_vpos(curr_vpos, &player1_info);
        int player_x = (int) curr_vpos[0] / 3;
        int player_y = (int) curr_vpos[1] / 3;
        int attempt_pos_r;
        int attempt_pos_c;
        int player_r = player_y / 16;
        int player_c = player_x / 16;
        switch (facing) {
            case DOWN:
                attempt_pos_r = player_r + 1;
                attempt_pos_c = player_c;
                break;
            case LEFT:
                attempt_pos_r = player_r;
                attempt_pos_c = player_c - 1;
                break;
            case UP:
                attempt_pos_r = player_r - 1;
                attempt_pos_c = player_c;
                break;
            case RIGHT:
                attempt_pos_r = player_r;
                attempt_pos_c = player_c + 1;
                break;
        }
        if (attempt_pos_r >= 0 && attempt_pos_r < 30 && attempt_pos_c >= 0 && attempt_pos_c < 40) {

            int attempt_center_x = attempt_pos_c * 16 + 7;
            int attempt_center_y = attempt_pos_r * 16 + 7;
            int md = abs_diff(player_x, attempt_center_x) + abs_diff(player_y, attempt_center_y);
            int attempt_pos = attempt_pos_c + attempt_pos_r * 40;
            if (map[attempt_pos] == 0 && md > 12) {
                if (map[attempt_pos] == 0) {
                    if (map_change_list_append_tile((uint16_t) attempt_pos, (uint16_t) 3) == 0) {
                        map[attempt_pos] = 3;
                        if (md <= 16) {
                            uint16_t player_next_vpos[2];
                            player_next_vpos[0] = (uint16_t) (player_c * 16 + 8)* 3;
                            player_next_vpos[1] = (uint16_t) (player_r * 16 + 8)* 3;
                            set_player_pos(player_next_vpos, &player1_info);
                            
                        } 
                        insert_bomb(PLAYER1, attempt_pos);
                        player1_info.bombs_left --;
                        player1_info.bomb_colddown = 50;
                    }
                }
            }
        }
    }
    else {
        if (player1_info.bomb_colddown > 0)
            player1_info.bomb_colddown --;
    }
}