import matplotlib.pyplot as plt
import matplotlib.image as mpimg

img_rog = mpimg.imread('./tiles.png')

for i in range(4):
        for j in range(4):
                img = [[[ round(num) for num in pixel ] for pixel in row[5 + j * 100 : (j + 1) * 100 - 5] ] for row in img_rog[5 + i * 100 : (i + 1) * 100 - 5] ]
                f = open(f'./tile_{2 ** (i * 4 + j + 1)}.mif', 'w')
                f.write('\n' + 
                        '-- MADE BY PYTHON\n' + 
                        '-- WIDTH =  256\n' + 
                        '-- HEIGHT =  256\n' + 
                        '\n' + 
                        f'DEPTH =  {90 * 90};\n' + 
                        'WIDTH = 3;\n' + 
                        'ADDRESS_RADIX = DEC;\n' + 
                        'DATA_RADIX = DEC;\n' + 
                        'CONTENT\n' + 
                        'BEGIN\n'
                        )

                cnt = 0
                for row in img:
                        for pixel in row:
                                r = pixel[0]
                                g = pixel[1]
                                b = pixel[2]
                                match (r, g, b):
                                        case (1, 1, 1):
                                                f.write(f'{cnt}:\t0;\n')
                                        case (1, 0, 0):
                                                f.write(f'{cnt}:\t1;\n')
                                        case (0, 1, 0):
                                                f.write(f'{cnt}:\t2;\n')
                                        case (0, 0, 1):
                                                f.write(f'{cnt}:\t3;\n')
                                        case (0, 0, 0):
                                                f.write(f'{cnt}:\t4;\n')
                                        case (1, 1, 0):
                                                f.write(f'{cnt}:\t5;\n')
                                        case (0, 1, 1):
                                                f.write(f'{cnt}:\t6;\n')
                                cnt += 1
                f.write('END;')
                