import matplotlib.pyplot as plt
import matplotlib.image as mpimg

img_rog = mpimg.imread('./numbers.png')

for i in range(10):
        img = [[[ round(num) for num in pixel ] for pixel in row[i * 48 : (i + 1) * 48] ] for row in img_rog ]
        f = open(f'./num_{i}.mif', 'w')
        f.write('\n' + 
                '-- MADE BY PYTHON\n' + 
                '-- WIDTH =  256\n' + 
                '-- HEIGHT =  256\n' + 
                '\n' + 
                f'DEPTH =  {48 * 48};\n' + 
                'WIDTH = 2;\n' + 
                'ADDRESS_RADIX = DEC;\n' + 
                'DATA_RADIX = DEC;\n' + 
                'CONTENT\n' + 
                'BEGIN\n'
                )

        cnt = 0
        for row in img:
                for pixel in row:
                        r = pixel[0]
                        g = pixel[1]
                        b = pixel[2]
                        match (r, g, b):
                                case (1, 1, 1):
                                        f.write(f'{cnt}:\t0;\n')
                                case (0, 1, 1):
                                        f.write(f'{cnt}:\t1;\n')
                        cnt += 1
        f.write('END;')
        